/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.colormanip;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.swing.binding.BindingContext;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.image.ImageManager;
import org.esa.snap.rcp.colormanip.Bundle;
import org.esa.snap.rcp.colormanip.ColorManipulationForm;
import org.esa.snap.rcp.colormanip.FormModel;
import org.esa.snap.rcp.colormanip.MoreOptionsForm;
import org.openide.util.HelpCtx;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="UncertaintyVisualisationTopComponent", iconBase="org/esa/snap/rcp/icons/UncertaintyStretch.png", persistenceType=0)
public class UncertaintyVisualisationTopComponent
extends TopComponent {
    public static final String UNCERTAINTY_MODE_PROPERTY = "uncertaintyMode";

    public UncertaintyVisualisationTopComponent() {
        this.setName(Bundle.CTL_UncertaintyVisualisationTopComponent_ComponentName());
        ColorManipulationForm cmf = new ColorManipulationForm(this, new MyFormModel());
        this.setLayout(new BorderLayout());
        this.add(cmf.getContentPanel(), "Center");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("showUncertaintyManipulationWnd");
    }

    private static class MyFormModel
    extends FormModel {
        private MyFormModel() {
        }

        @Override
        public String getTitlePrefix() {
            return Bundle.CTL_UncertaintyVisualisationTopComponent_Name();
        }

        @Override
        public boolean isValid() {
            return super.isValid() && this.getRaster() != null;
        }

        @Override
        public RasterDataNode getRaster() {
            RasterDataNode raster = this.getProductSceneView().getRaster();
            return ImageManager.getUncertaintyBand((RasterDataNode)raster);
        }

        @Override
        public RasterDataNode[] getRasters() {
            RasterDataNode raster = this.getRaster();
            if (raster != null) {
                return new RasterDataNode[]{raster};
            }
            return null;
        }

        @Override
        public void setRasters(RasterDataNode[] rasters) {
        }

        @Override
        public ImageInfo getOriginalImageInfo() {
            return this.getRaster().getImageInfo(ProgressMonitor.NULL);
        }

        @Override
        public void applyModifiedImageInfo() {
            this.getProductSceneView().updateImage();
        }

        @Override
        public boolean canUseHistogramMatching() {
            return false;
        }

        @Override
        public boolean isMoreOptionsFormCollapsedOnInit() {
            return false;
        }

        @Override
        public void modifyMoreOptionsForm(MoreOptionsForm moreOptionsForm) {
            JComboBox<ImageInfo.UncertaintyVisualisationMode> modeBox = new JComboBox<ImageInfo.UncertaintyVisualisationMode>(ImageInfo.UncertaintyVisualisationMode.values());
            modeBox.setEditable(false);
            moreOptionsForm.insertRow(0, new JLabel("Visualisation mode: "), modeBox);
            Property modeProperty = Property.create((String)UncertaintyVisualisationTopComponent.UNCERTAINTY_MODE_PROPERTY, ImageInfo.UncertaintyVisualisationMode.class);
            RasterDataNode uncertaintyBand = this.getRaster();
            try {
                if (uncertaintyBand != null) {
                    modeProperty.setValue((Object)uncertaintyBand.getImageInfo(ProgressMonitor.NULL).getUncertaintyVisualisationMode());
                } else {
                    modeProperty.setValue((Object)ImageInfo.UncertaintyVisualisationMode.None);
                }
            }
            catch (ValidationException validationException) {
                // empty catch block
            }
            moreOptionsForm.getBindingContext().getPropertySet().addProperty(modeProperty);
            moreOptionsForm.getBindingContext().bind(modeProperty.getName(), modeBox);
            moreOptionsForm.getBindingContext().addPropertyChangeListener(modeProperty.getName(), evt -> {
                RasterDataNode uncertainBand = this.getRaster();
                if (uncertainBand != null) {
                    ImageInfo.UncertaintyVisualisationMode uvMode = (ImageInfo.UncertaintyVisualisationMode)evt.getNewValue();
                    ImageInfo imageInfo = uncertainBand.getImageInfo();
                    imageInfo.setUncertaintyVisualisationMode(uvMode);
                    this.setModifiedImageInfo(imageInfo);
                    this.applyModifiedImageInfo();
                    moreOptionsForm.getChildForm().updateFormModel(moreOptionsForm.getParentForm().getFormModel());
                }
            });
        }

        @Override
        public void updateMoreOptionsFromImageInfo(MoreOptionsForm moreOptionsForm) {
            super.updateMoreOptionsFromImageInfo(moreOptionsForm);
            BindingContext bindingContext = moreOptionsForm.getBindingContext();
            ImageInfo.UncertaintyVisualisationMode mode = this.getModifiedImageInfo().getUncertaintyVisualisationMode();
            bindingContext.getBinding(UncertaintyVisualisationTopComponent.UNCERTAINTY_MODE_PROPERTY).setPropertyValue((Object)mode);
        }

        @Override
        public void updateImageInfoFromMoreOptions(MoreOptionsForm moreOptionsForm) {
            super.updateImageInfoFromMoreOptions(moreOptionsForm);
            BindingContext bindingContext = moreOptionsForm.getBindingContext();
            ImageInfo.UncertaintyVisualisationMode mode = (ImageInfo.UncertaintyVisualisationMode)bindingContext.getBinding(UncertaintyVisualisationTopComponent.UNCERTAINTY_MODE_PROPERTY).getPropertyValue();
            this.getModifiedImageInfo().setUncertaintyVisualisationMode(mode);
        }

        @Override
        public Component createEmptyContentPanel() {
            return new JLabel("<html>This tool window is used to visualise the<br><b>uncertainty information</b> associated<br>with a band shown in an image view.<br>Right now, there is no selected image view or<br>uncertainty information is unavailable.", 0);
        }
    }
}

