/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.colormanip;

import com.bc.ceres.core.Assert;
import java.awt.Color;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.util.math.MathUtils;
import org.esa.snap.ui.AbstractImageInfoEditorModel;

class ImageInfoEditorModel3B
extends AbstractImageInfoEditorModel {
    private static final Color[] RGB_COLORS = new Color[]{Color.RED, Color.GREEN, Color.BLUE};
    private final int channel;
    private byte[] gammaCurve;

    ImageInfoEditorModel3B(ImageInfo imageInfo, int channel) {
        super(imageInfo);
        Assert.argument((imageInfo.getRgbChannelDef() != null ? 1 : 0) != 0, (String)"imageInfo");
        this.channel = channel;
        this.updateGammaCurve();
    }

    public int getSliderCount() {
        return 2;
    }

    public double getSliderSample(int index) {
        if (index == 0) {
            return this.getImageInfo().getRgbChannelDef().getMinDisplaySample(this.channel);
        }
        return this.getImageInfo().getRgbChannelDef().getMaxDisplaySample(this.channel);
    }

    public void setSliderSample(int index, double sample) {
        if (index == 0) {
            this.getImageInfo().getRgbChannelDef().setMinDisplaySample(this.channel, sample);
        } else {
            this.getImageInfo().getRgbChannelDef().setMaxDisplaySample(this.channel, sample);
        }
        this.fireStateChanged();
    }

    public boolean isColorEditable() {
        return false;
    }

    public Color getSliderColor(int index) {
        if (index == 0) {
            return Color.BLACK;
        }
        return RGB_COLORS[this.channel];
    }

    public void setSliderColor(int index, Color color) {
        throw new IllegalStateException("not implemented for RGB");
    }

    public void createSliderAfter(int index) {
        throw new IllegalStateException("not implemented for RGB");
    }

    public void removeSlider(int removeIndex) {
        throw new IllegalStateException("not implemented for RGB");
    }

    public Color[] createColorPalette() {
        Color color = RGB_COLORS[this.channel];
        Color[] palette = new Color[256];
        int redMult = color.getRed() / 255;
        int greenMult = color.getGreen() / 255;
        int blueMult = color.getBlue() / 255;
        for (int i = 0; i < palette.length; ++i) {
            int j = i;
            if (this.gammaCurve != null) {
                j = this.gammaCurve[i] & 0xFF;
            }
            int r = j * redMult;
            int g = j * greenMult;
            int b = j * blueMult;
            palette[i] = new Color(r, g, b);
        }
        return palette;
    }

    public boolean isGammaUsed() {
        return this.getImageInfo().getRgbChannelDef().isGammaUsed(this.channel);
    }

    public double getGamma() {
        return this.getImageInfo().getRgbChannelDef().getGamma(this.channel);
    }

    public void setGamma(double gamma) {
        this.getImageInfo().getRgbChannelDef().setGamma(this.channel, gamma);
        this.updateGammaCurve();
        this.fireStateChanged();
    }

    public byte[] getGammaCurve() {
        return this.gammaCurve;
    }

    private void updateGammaCurve() {
        this.gammaCurve = (byte[])(this.isGammaUsed() ? MathUtils.createGammaCurve((double)this.getGamma(), null) : null);
    }
}

