/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.window;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import javax.swing.undo.UndoManager;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.util.Debug;
import org.esa.snap.netbeans.docwin.DocumentWindow;
import org.esa.snap.netbeans.docwin.DocumentWindowManager;
import org.esa.snap.netbeans.docwin.WindowUtilities;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.window.Bundle;
import org.esa.snap.rcp.windows.ProductSceneViewTopComponent;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.product.ProductSceneImage;
import org.esa.snap.ui.product.ProductSceneView;
import org.openide.awt.UndoRedo;

public class OpenImageViewAction
extends AbstractAction {
    RasterDataNode raster;

    public OpenImageViewAction(RasterDataNode rasterDataNode) {
        this.raster = rasterDataNode;
        this.putValue("Name", Bundle.CTL_OpenImageViewActionName());
        this.setActivateIfExists(true);
    }

    public static OpenImageViewAction create(RasterDataNode rasterDataNode, boolean activateIfExists) {
        OpenImageViewAction action = new OpenImageViewAction(rasterDataNode);
        action.setActivateIfExists(activateIfExists);
        return action;
    }

    public static void showImageView(RasterDataNode rasterDataNode) {
        OpenImageViewAction.create(rasterDataNode, true).execute();
    }

    public static void openImageView(RasterDataNode rasterDataNode) {
        OpenImageViewAction.create(rasterDataNode, false).execute();
    }

    public boolean getActivateIfExists() {
        Object value = this.getValue("activateIfExists");
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    public void setActivateIfExists(boolean value) {
        this.putValue("activateIfExists", value);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.execute();
    }

    public void execute() {
        if (this.getActivateIfExists()) {
            ProductSceneViewTopComponent tc = OpenImageViewAction.getProductSceneViewTopComponent(this.raster);
            if (tc != null) {
                tc.requestSelected();
            } else {
                this.openProductSceneView();
            }
        } else {
            this.openProductSceneView();
        }
    }

    private void openProductSceneView() {
        final SnapApp snapApp = SnapApp.getDefault();
        snapApp.setStatusBarMessage("Opening image view...");
        UIUtils.setRootFrameWaitCursor((Component)snapApp.getMainFrame());
        String progressMonitorTitle = MessageFormat.format("Creating image for ''{0}''", this.raster.getName());
        final ProductSceneView existingView = OpenImageViewAction.getProductSceneView(this.raster);
        ProgressMonitorSwingWorker<ProductSceneImage, Object> worker = new ProgressMonitorSwingWorker<ProductSceneImage, Object>((Component)snapApp.getMainFrame(), progressMonitorTitle){

            protected ProductSceneImage doInBackground(ProgressMonitor pm) throws Exception {
                try {
                    ProductSceneImage productSceneImage = OpenImageViewAction.this.createProductSceneImage(OpenImageViewAction.this.raster, existingView, pm);
                    return productSceneImage;
                }
                finally {
                    if (pm.isCanceled()) {
                        OpenImageViewAction.this.raster.unloadRasterData();
                    }
                }
            }

            public void done() {
                UIUtils.setRootFrameDefaultCursor((Component)snapApp.getMainFrame());
                snapApp.setStatusBarMessage("");
                try {
                    ProductSceneImage sceneImage = (ProductSceneImage)this.get();
                    UndoRedo.Manager undoManager = SnapApp.getDefault().getUndoManager(sceneImage.getProduct());
                    ProductSceneView view = new ProductSceneView(sceneImage, (UndoManager)undoManager);
                    OpenImageViewAction.this.openDocumentWindow(view);
                }
                catch (Exception e) {
                    snapApp.handleError(MessageFormat.format("Failed to open image view.\n\n{0}", e.getMessage()), e);
                }
            }
        };
        worker.execute();
    }

    private ProductSceneViewTopComponent openDocumentWindow(ProductSceneView view) {
        UndoRedo.Manager undoManager = SnapApp.getDefault().getUndoManager(view.getProduct());
        ProductSceneViewTopComponent productSceneViewWindow = new ProductSceneViewTopComponent(view, (UndoRedo)undoManager);
        DocumentWindowManager.getDefault().openWindow((DocumentWindow)productSceneViewWindow);
        productSceneViewWindow.requestSelected();
        return productSceneViewWindow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProductSceneImage createProductSceneImage(RasterDataNode raster, ProductSceneView existingView, ProgressMonitor pm) {
        Debug.assertNotNull((Object)raster);
        Debug.assertNotNull((Object)pm);
        try {
            pm.beginTask("Creating image...", 1);
            ProductSceneImage sceneImage = existingView != null ? new ProductSceneImage(raster, existingView) : new ProductSceneImage(raster, SnapApp.getDefault().getPreferencesPropertyMap(), SubProgressMonitor.create((ProgressMonitor)pm, (int)1));
            sceneImage.initVectorDataCollectionLayer();
            sceneImage.initMaskCollectionLayer();
            ProductSceneImage productSceneImage = sceneImage;
            return productSceneImage;
        }
        finally {
            pm.done();
        }
    }

    public static ProductSceneViewTopComponent getProductSceneViewTopComponent(RasterDataNode raster) {
        return WindowUtilities.getOpened(ProductSceneViewTopComponent.class).filter(topComponent -> topComponent.getView().getNumRasters() == 1 && raster == topComponent.getView().getRaster()).findFirst().orElse(null);
    }

    public static ProductSceneView getProductSceneView(RasterDataNode raster) {
        ProductSceneViewTopComponent component = OpenImageViewAction.getProductSceneViewTopComponent(raster);
        return component != null ? component.getView() : null;
    }

    public static void updateProductSceneViewImage(ProductSceneView view) {
        SwingUtilities.invokeLater(() -> ((ProductSceneView)view).updateImage());
    }

    public static void updateProductSceneViewImages(RasterDataNode[] rasters) {
        OpenImageViewAction.updateProductSceneViewImages(rasters, ProductSceneViewImageUpdater.DEFAULT);
    }

    public static void updateProductSceneViewImages(RasterDataNode[] rasters, ProductSceneViewImageUpdater updateMethod) {
        List views = WindowUtilities.getOpened(ProductSceneViewTopComponent.class).map(ProductSceneViewTopComponent::getView).collect(Collectors.toList());
        for (ProductSceneView view : views) {
            boolean updateView = false;
            for (int j = 0; j < rasters.length && !updateView; ++j) {
                RasterDataNode raster = rasters[j];
                for (int k = 0; k < view.getNumRasters() && !updateView; ++k) {
                    if (view.getRaster(k) != raster) continue;
                    updateView = true;
                }
            }
            if (!updateView) continue;
            SwingUtilities.invokeLater(() -> updateMethod.updateView(view));
        }
    }

    public static interface ProductSceneViewImageUpdater {
        public static final ProductSceneViewImageUpdater DEFAULT = ProductSceneView::updateImage;

        public void updateView(ProductSceneView var1);
    }
}

