/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.file;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductManager;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.file.Bundle;
import org.esa.snap.rcp.actions.file.CloseProductAction;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class CloseOtherProductsAction
extends AbstractAction
implements ContextAwareAction,
LookupListener {
    private final Lookup lkp;
    private Product[] products;

    public CloseOtherProductsAction() {
        this(Utilities.actionsGlobalContext());
    }

    public CloseOtherProductsAction(Lookup lkp) {
        super(Bundle.CTL_CloseAllOthersActionName());
        this.lkp = lkp;
        Lookup.Result lkpContext = lkp.lookupResult(ProductNode.class);
        lkpContext.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, (Object)lkpContext));
        ProductManager productManager = SnapApp.getDefault().getProductManager();
        productManager.addListener((ProductManager.Listener)new CloseOtherProductListener());
        this.setEnableState();
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new CloseOtherProductsAction(actionContext);
    }

    public void resultChanged(LookupEvent ev) {
        this.setEnableState();
    }

    private void setEnableState() {
        this.products = SnapApp.getDefault().getProductManager().getProducts();
        ProductNode productNode = (ProductNode)this.lkp.lookup(ProductNode.class);
        this.setEnabled(productNode != null && this.products.length > 1);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        ProductNode productNode = (ProductNode)this.lkp.lookup(ProductNode.class);
        this.products = SnapApp.getDefault().getProductManager().getProducts();
        Product selectedProduct = productNode.getProduct();
        ArrayList<Product> productsToClose = new ArrayList<Product>(this.products.length);
        for (Product product : this.products) {
            if (product == selectedProduct) continue;
            productsToClose.add(product);
        }
        new CloseProductAction(productsToClose).execute();
        this.setEnableState();
    }

    private class CloseOtherProductListener
    implements ProductManager.Listener {
        private CloseOtherProductListener() {
        }

        public void productAdded(ProductManager.Event event) {
            this.updateEnableState();
        }

        public void productRemoved(ProductManager.Event event) {
            this.updateEnableState();
        }

        private void updateEnableState() {
            CloseOtherProductsAction.this.setEnableState();
        }
    }
}

