/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.python.gpf;

import java.net.URL;
import org.esa.snap.core.gpf.descriptor.DefaultOperatorDescriptor;
import org.esa.snap.core.gpf.descriptor.ParameterDescriptor;
import org.esa.snap.python.gpf.PyOperator;
import org.junit.Assert;
import org.junit.Test;

public class PyOperatorDescriptor_FromXmlTest {
    @Test
    public void testReadingXml() {
        URL url = this.getClass().getResource("ExampleOp-info.xml");
        DefaultOperatorDescriptor opDescriptor = DefaultOperatorDescriptor.fromXml((URL)url, (ClassLoader)DefaultOperatorDescriptor.class.getClassLoader());
        Assert.assertEquals((Object)"ExampleOp", (Object)opDescriptor.getAlias());
        Assert.assertEquals((Object)"org.esa.snap.ExampleOp", (Object)opDescriptor.getName());
        Assert.assertEquals(PyOperator.class, (Object)opDescriptor.getOperatorClass());
        Assert.assertEquals((Object)"Description text.", (Object)opDescriptor.getDescription());
        Assert.assertEquals((Object)"SNAP Devs", (Object)opDescriptor.getAuthors());
        Assert.assertEquals((Object)"2017 ESA", (Object)opDescriptor.getCopyright());
        Assert.assertEquals((Object)"Special Test Example Operator", (Object)opDescriptor.getLabel());
        Assert.assertTrue((boolean)opDescriptor.isInternal());
        Assert.assertTrue((boolean)opDescriptor.isAutoWriteDisabled());
        ParameterDescriptor[] paramDescriptors = opDescriptor.getParameterDescriptors();
        Assert.assertEquals((long)4L, (long)paramDescriptors.length);
        ParameterDescriptor algorithmDescriptor = paramDescriptors[0];
        Assert.assertEquals((Object)"algorithm", (Object)algorithmDescriptor.getName());
        Assert.assertEquals((Object)"Algorithm", (Object)algorithmDescriptor.getLabel());
        Assert.assertEquals((Object)"Algorithm to be used", (Object)algorithmDescriptor.getDescription());
        Assert.assertEquals(String.class, (Object)algorithmDescriptor.getDataType());
        Assert.assertEquals((Object)"split", (Object)algorithmDescriptor.getDefaultValue());
        Assert.assertArrayEquals((Object[])new String[]{"split", "mono"}, (Object[])algorithmDescriptor.getValueSet());
        ParameterDescriptor rangeDescriptor = paramDescriptors[3];
        Assert.assertEquals((Object)"range", (Object)rangeDescriptor.getName());
        Assert.assertEquals((Object)"Allowed range", (Object)rangeDescriptor.getDescription());
        Assert.assertEquals(Integer.TYPE, (Object)rangeDescriptor.getDataType());
        Assert.assertEquals((Object)"12", (Object)rangeDescriptor.getDefaultValue());
        Assert.assertEquals((Object)"[10,20)", (Object)rangeDescriptor.getInterval());
    }
}

