/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.opensearch;

import com.bc.ceres.core.ProgressMonitor;
import java.io.IOException;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.productlibrary.opendata.OpenData;
import org.esa.snap.productlibrary.opensearch.OpenSearch;
import org.junit.Ignore;
import org.junit.Test;

public class TestCopernicusOpenSearch {
    private static final String COPERNICUS_HOST = "https://scihub.copernicus.eu";
    private static final String searchURL = "https://scihub.copernicus.eu/dhus/search?q=( footprint:\"Intersects(POLYGON((-74.24323771090575 -34.81331346157173,-31.2668365052604 -34.81331346157173,-31.2668365052604 5.647318588641241,-74.24323771090575 5.647318588641241,-74.24323771090575 -34.81331346157173)))\" ) AND ( beginPosition:[2016-01-25T00:00:00.000Z TO 2016-01-25T23:59:59.999Z] AND endPosition:[2016-01-25T00:00:00.000Z TO 2016-01-25T23:59:59.999Z] ) AND (platformname:Sentinel-1 AND producttype:GRD)";
    private static final String COPERNICUS_ODATA_ROOT = "https://scihub.copernicus.eu/dhus/odata/v1/";
    private static final String outputFolder = "e:\\tmp\\";

    @Test
    @Ignore
    public void testConnect() throws IOException {
        block6: {
            OpenSearch openSearch = new OpenSearch(COPERNICUS_HOST);
            OpenSearch.PageResult pageResult = openSearch.getPages(searchURL);
            try {
                OpenSearch.ProductResult[] productResults = openSearch.getProductResults(pageResult, ProgressMonitor.NULL);
                SystemUtils.LOG.info("Retrieved " + productResults.length + " Product Ids");
                for (OpenSearch.ProductResult productResult : productResults) {
                }
                OpenData openData = new OpenData(COPERNICUS_HOST, COPERNICUS_ODATA_ROOT);
                for (OpenSearch.ProductResult result : productResults) {
                    OpenData.Entry entry = openData.getEntryByID(result.id);
                    SystemUtils.LOG.info(entry.fileName);
                }
            }
            catch (Exception e) {
                System.out.println("TestCopernicusOpenSearch.testConnect: caught exception:" + e.getMessage());
                if (!(e instanceof IOException)) break block6;
                throw new IOException(e.getMessage());
            }
        }
    }
}

