/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.db;

import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileFilter;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.util.ProductFunctions;
import org.esa.snap.engine_utilities.util.TestUtils;
import org.esa.snap.productlibrary.db.ProductDB;
import org.esa.snap.productlibrary.db.ProductEntry;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class TestProductDao {
    public static final String sep = File.separator;
    public static final String rootPathTestProducts = SystemUtils.getApplicationHomeDir() + sep + ".." + sep + ".." + sep + ".." + sep + ".." + sep + "testdata";
    public static final String inputSAR = rootPathTestProducts + sep + "input" + sep + "SAR" + sep;
    public static final File inputTestFolder = new File(inputSAR);
    private ProductDB db;

    @Before
    public void setUp() throws Exception {
        this.db = ProductDB.instance();
    }

    @Test
    @Ignore
    public void testAddAll() throws Exception {
        if (!inputTestFolder.exists()) {
            TestUtils.skipTest((Object)this, (String)(inputTestFolder + " not found"));
            return;
        }
        TestProductDao.recurseProcessFolder(inputTestFolder, this.db);
    }

    public static void recurseProcessFolder(File folder, ProductDB db) throws SQLException {
        File[] fileList = folder.listFiles((FileFilter)new ProductFunctions.ValidProductFileFilter(true));
        if (fileList == null) {
            return;
        }
        for (File file : fileList) {
            ProductReader reader;
            if (file.isDirectory()) {
                TestProductDao.recurseProcessFolder(file, db);
                continue;
            }
            if (db.pathExistsInDB(file) || (reader = ProductIO.getProductReaderForInput((Object)file)) == null) continue;
            Product sourceProduct = null;
            try {
                sourceProduct = reader.readProductNodes((Object)file, null);
            }
            catch (Exception e) {
                System.out.println("Unable to read " + file.getAbsolutePath());
            }
            if (sourceProduct == null) continue;
            db.saveProduct(sourceProduct);
            sourceProduct.dispose();
        }
    }

    @Ignore(value="fails")
    public void testListAll() throws SQLException {
        ProductEntry[] list;
        for (ProductEntry productEntry : list = this.db.getProductEntryList(false)) {
        }
    }

    @Test
    public void testGetAllMissions() throws SQLException {
        String[] missions;
        TestUtils.log.info("Missions:");
        for (String str : missions = this.db.getAllMissions()) {
            TestUtils.log.info(str);
        }
    }

    @Ignore(value="fails")
    public void testGetENVISATProductTypes() throws SQLException {
        String[] productTypes;
        TestUtils.log.info("ENVISAT productTypes:");
        for (String str : productTypes = this.db.getProductTypes(new String[]{"ENVISAT"})) {
            TestUtils.log.info(str);
        }
    }

    @Ignore(value="fails")
    public void testGetAllProductTypes() throws SQLException {
        String[] productTypes;
        TestUtils.log.info("All productTypes:");
        for (String str : productTypes = this.db.getAllProductTypes()) {
            TestUtils.log.info(str);
        }
    }

    @Ignore(value="fails")
    public void testSelect() throws SQLException {
        String strGetProductsWhere = "SELECT * FROM APP.PRODUCTS WHERE MISSION='ENVISAT'";
        try (Statement queryStatement = this.db.getConnection().createStatement();){
            ResultSet resultSet = queryStatement.executeQuery("SELECT * FROM APP.PRODUCTS WHERE MISSION='ENVISAT'");
        }
    }

    @Ignore(value="fails")
    public static void testRectIntersect() {
        Rectangle2D.Float a = new Rectangle2D.Float(-10.0f, 10.0f, 100.0f, 100.0f);
        Rectangle2D.Float b = new Rectangle2D.Float(-20.0f, 20.0f, 50.0f, 50.0f);
        boolean r1 = a.intersects(b);
        boolean r2 = b.intersects(a);
        System.out.println();
    }
}

