/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.opensearch;

import com.bc.ceres.core.ProgressMonitor;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.abdera.Abdera;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.model.Link;
import org.apache.abdera.protocol.Response;
import org.apache.abdera.protocol.client.AbderaClient;
import org.apache.abdera.protocol.client.ClientResponse;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.productlibrary.db.Credentials;

public class OpenSearch {
    private final String host;
    private final AbderaClient client;
    private String searchURL;
    private static final int numRows = 100;
    private static final int TIMEOUT = 60000;

    public OpenSearch(String host) throws IOException {
        this.host = host;
        try {
            this.client = new AbderaClient(new Abdera());
            this.client.usePreemptiveAuthentication(true);
            this.client.setConnectionTimeout(60000);
            this.client.setConnectionManagerTimeout(60000L);
            this.client.setSocketTimeout(60000);
            this.client.setMaxConnectionsPerHost(2);
            Credentials.CredentialInfo credentialInfo = this.getCredentialInfo();
            this.client.addCredentials(host, null, null, (org.apache.commons.httpclient.Credentials)new UsernamePasswordCredentials(credentialInfo.getUser(), credentialInfo.getPassword()));
            AbderaClient.registerTrustManager();
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    public PageResult getPages(String searchURL) throws IOException {
        this.searchURL = searchURL;
        ClientResponse[] response = new ClientResponse[1];
        Feed feed = this.connect(searchURL, "&start=0&rows=100", response);
        response[0].getInputStream().close();
        if (feed == null) {
            return null;
        }
        PageResult result = new PageResult(feed);
        SystemUtils.LOG.info("OpenSearch: " + result.totalResults + " total results on " + result.pages + " pages.");
        return result;
    }

    public ProductResult[] getProductResults(PageResult result, ProgressMonitor pm) throws Exception {
        ArrayList<ProductResult> productResultList = new ArrayList<ProductResult>();
        boolean ok = true;
        ClientResponse[] response = new ClientResponse[1];
        pm.beginTask("Searching...", result.totalResults / 100);
        for (int item = 0; item < result.totalResults && !pm.isCanceled(); item += 100) {
            try {
                Feed feed = this.connect(this.searchURL, "&start=" + item + "&rows=" + 100, response);
                List entries = feed.getEntries();
                for (Entry entry : entries) {
                    productResultList.add(new ProductResult(entry));
                }
                response[0].getInputStream().close();
            }
            catch (Exception e) {
                ok = false;
                SystemUtils.LOG.severe("item = " + item + " Error retrieving product results " + e.getMessage());
            }
            pm.worked(1);
        }
        pm.done();
        if (ok) {
            return productResultList.toArray(new ProductResult[productResultList.size()]);
        }
        return null;
    }

    private Feed connect(String searchURL, String compl, ClientResponse[] response) throws IOException {
        SystemUtils.LOG.info("OpenSearch: " + searchURL);
        int end = searchURL.indexOf("search") + 9;
        String init = searchURL.substring(0, end);
        String last = searchURL.substring(end);
        try {
            searchURL = init + URLEncoder.encode(last, "UTF-8") + compl;
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException(e);
        }
        ClientResponse resp = this.client.get(searchURL);
        if (resp.getType() == Response.ResponseType.SUCCESS) {
            Document doc = resp.getDocument();
            response[0] = resp;
            return (Feed)doc.getRoot();
        }
        throw new IOException("Error in OpenSearch query: " + resp.getType() + " [" + resp.getStatus() + ']');
    }

    private static void dumpFeed(Feed feed) {
        List entries = feed.getEntries();
        int i = 1;
        for (Entry entry : entries) {
            System.out.println("Item " + i + " of " + entries.size());
            System.out.println(entry.getId().toString());
            System.out.println(entry.getSummary());
            System.out.println(entry.getTitle());
            List links = entry.getLinks();
            for (Link link : links) {
                System.out.println("link: " + link.toString());
            }
            List attrib = entry.getAttributes();
            for (QName qName : attrib) {
                System.out.println("Atrib: " + qName.toString());
            }
            ++i;
        }
    }

    private Credentials.CredentialInfo getCredentialInfo() throws IOException {
        Credentials.CredentialInfo credentialInfo = Credentials.instance().get(this.host);
        if (credentialInfo == null) {
            throw new IOException("Credentials for " + this.host + " not set");
        }
        return credentialInfo;
    }

    public static class ProductResult {
        public final String id;
        public final String name;
        public final String size;
        public final String mode;
        public final String mission;
        public final ProductData.UTC utc;
        public String productLink;
        public String quicklookLink;
        public String manifestLink;
        private static final String SIZE = "Size:";
        private static final String SATELLITE = "Satellite:";
        private static final String DATE = "Date:";
        private static final String MODE = "Mode:";
        public final DateFormat dateFormat = ProductData.UTC.createDateFormat((String)"yyy-MM-dd HH:mm:ss");

        public ProductResult(Entry entry) {
            this.id = entry.getId().toString();
            this.name = entry.getTitle();
            String summary = entry.getSummary();
            this.mission = ProductResult.getMission(summary);
            this.utc = AbstractMetadata.parseUTC((String)ProductResult.getDate(summary), (DateFormat)this.dateFormat);
            this.size = ProductResult.getSize(summary);
            this.mode = ProductResult.getMode(summary);
            List links = entry.getLinks();
            for (Link link : links) {
                if (link.getRel() == null) {
                    this.productLink = link.getHref().toString();
                    this.manifestLink = this.productLink.substring(0, this.productLink.lastIndexOf(47)) + "/Nodes('" + this.name + ".SAFE')/Nodes('manifest.safe')/$value";
                    continue;
                }
                if (!link.getRel().equals("icon")) continue;
                this.quicklookLink = link.getHref().toString();
            }
        }

        private static String getDate(String text) {
            int start = text.indexOf(DATE);
            if (start >= 0) {
                int end = text.indexOf(44, start);
                return text.substring(start + DATE.length(), end < 0 ? text.length() : end).trim().replace("T", " ").replace("Z", "");
            }
            return "";
        }

        private static String getMission(String text) {
            int start = text.indexOf(SATELLITE);
            if (start >= 0) {
                int end = text.indexOf(44, start);
                return text.substring(start + SATELLITE.length(), end < 0 ? text.length() : end).trim();
            }
            return "";
        }

        private static String getSize(String text) {
            int start = text.indexOf(SIZE);
            if (start >= 0) {
                int end = text.indexOf(44, start);
                return text.substring(start + SIZE.length(), end < 0 ? text.length() : end).trim();
            }
            return "";
        }

        private static String getMode(String text) {
            int start = text.indexOf(MODE);
            if (start >= 0) {
                int end = text.indexOf(44, start);
                return text.substring(start + MODE.length(), end < 0 ? text.length() : end).trim();
            }
            return "";
        }
    }

    public static class PageResult {
        public final int totalResults;
        public final int itemsPerPage;
        public final int pages;
        private static final QName trQn = new QName("http://a9.com/-/spec/opensearch/1.1/", "totalResults");
        private static final QName ippQn = new QName("http://a9.com/-/spec/opensearch/1.1/", "itemsPerPage");

        public PageResult(Feed feed) {
            this.totalResults = Integer.parseInt(feed.getExtension(trQn).getText());
            this.itemsPerPage = Integer.parseInt(feed.getExtension(ippQn).getText());
            this.pages = this.totalResults / this.itemsPerPage + 1;
        }
    }
}

