/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.opensearch;

import java.awt.geom.Rectangle2D;
import java.util.Calendar;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.productlibrary.db.DBQuery;

class CopernicusQueryBuilder {
    private final DBQuery dbQuery;
    private static final String COPERNICUS_HOST = "https://scihub.copernicus.eu";
    private static final String SEARCH_ROOT = "/dhus/search?q=";

    CopernicusQueryBuilder(DBQuery dbQuery) {
        this.dbQuery = dbQuery;
    }

    String getSearchURL() throws Exception {
        StringBuilder str = new StringBuilder();
        str.append("( ");
        String footprint = this.getFootprint();
        if (footprint.isEmpty() || footprint.lastIndexOf(44) == footprint.indexOf(44)) {
            throw new Exception("No area is selected");
        }
        str.append(footprint);
        str.append(this.getDate());
        str.append(this.getMission());
        str.append(this.getProductType());
        str.append(this.getSensorMode());
        str.append(this.getProductName());
        str.append(this.getOrbitDirection());
        str.append(this.getRelativeOrbit());
        str.append(this.getPolarization());
        str.append(this.getCloudCover());
        str.append(" )");
        return "https://scihub.copernicus.eu/dhus/search?q=" + str.toString();
    }

    private String getFootprint() {
        Rectangle2D.Double rect = this.dbQuery.getSelectionRectangle();
        if (rect != null && rect.width != 0.0 && rect.height != 0.0) {
            StringBuilder str = new StringBuilder();
            str.append("( footprint:\"Intersects(POLYGON((");
            str.append(rect.y);
            str.append(' ');
            str.append(rect.x);
            str.append(", ");
            str.append(rect.y);
            str.append(' ');
            str.append(rect.x + rect.width);
            str.append(", ");
            str.append(rect.y + rect.height);
            str.append(' ');
            str.append(rect.x + rect.width);
            str.append(", ");
            str.append(rect.y + rect.height);
            str.append(' ');
            str.append(rect.x);
            str.append(", ");
            str.append(rect.y);
            str.append(' ');
            str.append(rect.x);
            str.append(")))\" )");
            return str.toString();
        }
        if (rect != null) {
            StringBuilder str = new StringBuilder();
            str.append("( footprint:\"Intersects(");
            str.append(rect.y);
            str.append(", ");
            str.append(rect.x);
            str.append(")\" )");
            return str.toString();
        }
        return "";
    }

    private String getDate() {
        Calendar start = this.dbQuery.getStartDate();
        Calendar end = this.dbQuery.getEndDate();
        if (start != null || end != null) {
            StringBuilder str = new StringBuilder();
            str.append(" AND ( ");
            if (start != null) {
                str.append("beginPosition:[");
                int year = start.get(1);
                int month = start.get(2) + 1;
                int day = start.get(5);
                str.append(String.valueOf(year) + '-' + month + '-' + day);
                str.append("T00:00:00.000Z TO ");
                if (end != null) {
                    int year2 = end.get(1);
                    int month2 = end.get(2) + 1;
                    int day2 = end.get(5);
                    str.append(String.valueOf(year2) + '-' + month2 + '-' + day2);
                    str.append("T00:00:00.000Z");
                } else {
                    str.append("NOW");
                }
                str.append("] ");
            } else {
                str.append("beginPosition:[");
                str.append("2014-01-01T00:00:00.000Z TO ");
                int year2 = end.get(1);
                int month2 = end.get(2) + 1;
                int day2 = end.get(5);
                str.append(String.valueOf(year2) + '-' + month2 + '-' + day2);
                str.append("T00:00:00.000Z");
                str.append("] ");
            }
            str.append(" )");
            return str.toString();
        }
        return "";
    }

    private String getMission() {
        String[] missions = this.dbQuery.getSelectedMissions();
        if (missions != null && missions.length > 0 && !StringUtils.contains((String[])missions, (String)"All_Missions")) {
            StringBuilder str = new StringBuilder();
            str.append(" AND (");
            for (int i = 0; i < missions.length; ++i) {
                if (i > 0) {
                    str.append(" OR ");
                }
                str.append("platformname:" + missions[i]);
            }
            str.append(" )");
            return str.toString();
        }
        return "";
    }

    private String getProductType() {
        String[] productTypes = this.dbQuery.getSelectedProductTypes();
        if (productTypes != null && productTypes.length > 0 && !StringUtils.contains((String[])productTypes, (String)"All_Types")) {
            StringBuilder str = new StringBuilder();
            str.append(" AND (");
            for (int i = 0; i < productTypes.length; ++i) {
                if (i > 0) {
                    str.append(" OR ");
                }
                str.append("producttype:" + productTypes[i]);
            }
            str.append(" )");
            return str.toString();
        }
        return "";
    }

    private String getProductName() {
        String name = this.dbQuery.getSelectedName();
        if (name != null && !name.isEmpty()) {
            return " AND (filename:*" + name + "*  )";
        }
        return "";
    }

    private String getSensorMode() {
        String mode = this.dbQuery.getSelectedAcquisitionMode();
        if (mode != null && !mode.isEmpty() && !mode.equals("All_Modes")) {
            return " AND (sensoroperationalmode:" + mode + " )";
        }
        return "";
    }

    private String getOrbitDirection() {
        String pass = this.dbQuery.getSelectedPass();
        if (pass != null && !pass.isEmpty() && !pass.equals("All_Passes")) {
            return " AND (orbitdirection:" + pass + " )";
        }
        return "";
    }

    private String getRelativeOrbit() {
        String track = this.dbQuery.getSelectedTrack();
        if (track != null && !track.isEmpty()) {
            return " AND (relativeorbitnumber:" + track + " )";
        }
        return "";
    }

    private String getPolarization() {
        String pol = this.dbQuery.getSelectedPolarization();
        if (pol != null && !pol.isEmpty() && !pol.equals("Any")) {
            if (pol.equals("Dual-Pol")) {
                return " AND ((polarisationmode:HH HV) OR (polarisationmode:VV VH) OR (polarisationmode:HH VV) )";
            }
            return " AND (polarisationmode:" + this.covertPolization(pol) + " )";
        }
        return "";
    }

    private String covertPolization(String pol) {
        if (pol.equals("Quad-Pol")) {
            return "HH HV VV VH";
        }
        return pol.replace('+', ' ');
    }

    private String getCloudCover() throws Exception {
        String cloudCover = CopernicusQueryBuilder.convertToCloudCoverFormat(this.dbQuery.getSelectedCloudCover());
        if (cloudCover != null && !cloudCover.isEmpty()) {
            if (cloudCover.contains("ERROR")) {
                throw new Exception("Invalid cloud cover; must be single integer value from 0 to 100 or range, e.g., 5-75");
            }
            return " AND (cloudcoverpercentage:" + cloudCover + " )";
        }
        return "";
    }

    private static String convertToCloudCoverFormat(String cloudCoverText) {
        if (cloudCoverText == null || cloudCoverText.isEmpty()) {
            return null;
        }
        String[] parts = cloudCoverText.split("-");
        if (parts.length == 2) {
            int cloudCoverMin = CopernicusQueryBuilder.getIntFromString(parts[0]);
            int cloudCoverMax = CopernicusQueryBuilder.getIntFromString(parts[1]);
            if (cloudCoverMin < 0 || cloudCoverMax < 0 || cloudCoverMin > 100 || cloudCoverMax > 100 || cloudCoverMin >= cloudCoverMax) {
                return "ERROR";
            }
            return "[" + cloudCoverMin + " TO " + cloudCoverMax + "]";
        }
        if (parts.length == 1) {
            int cloudCover = CopernicusQueryBuilder.getIntFromString(parts[0]);
            if (cloudCover < 0 || cloudCover > 100) {
                return "ERROR";
            }
            return Integer.toString(cloudCover);
        }
        return "ERROR";
    }

    private static int getIntFromString(String s) {
        try {
            int intVal = Integer.parseInt(s);
            return intVal;
        }
        catch (Exception e) {
            return -1;
        }
    }
}

