/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.opensearch;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.core.SubProgressMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.productlibrary.db.Credentials;
import org.esa.snap.productlibrary.db.DBQuery;
import org.esa.snap.productlibrary.db.ProductEntry;
import org.esa.snap.productlibrary.db.ProductQueryInterface;
import org.esa.snap.productlibrary.opendata.OpenData;
import org.esa.snap.productlibrary.opensearch.CopernicusQueryBuilder;
import org.esa.snap.productlibrary.opensearch.OpenSearch;

public class CopernicusProductQuery
implements ProductQueryInterface {
    private static CopernicusProductQuery instance;
    private ProductEntry[] productEntryListFull = null;
    private ProductEntry[] productEntryList = null;
    public static final String NAME = "ESA SciHub";
    public static final String COPERNICUS_HOST = "https://scihub.copernicus.eu";
    private static final String COPERNICUS_ODATA_ROOT = "https://scihub.copernicus.eu/dhus/odata/v1/";
    private static final String[] emptyStringList;
    private static final String[] COPERNICUS_MISSIONS;
    private static final String[] S1_PRODUCT_TYPES;
    private static final String[] S2_PRODUCT_TYPES;
    private static final String[] S3_PRODUCT_TYPES;
    private static final String[] S1_MODES;
    private static final String[] S2_MODES;
    private static final String[] S3_MODES;

    private CopernicusProductQuery() {
    }

    public static CopernicusProductQuery instance() {
        if (instance == null) {
            instance = new CopernicusProductQuery();
        }
        return instance;
    }

    @Override
    public boolean isReady() {
        return true;
    }

    @Override
    public boolean partialQuery(DBQuery dbQuery) throws Exception {
        ProductEntry[] productEntries = dbQuery.intersectMapSelection(this.productEntryListFull, true);
        if (productEntries != null) {
            this.productEntryList = productEntries;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean fullQuery(DBQuery dbQuery, ProgressMonitor pm) throws Exception {
        pm.beginTask("Searching ESA SciHub...", 20);
        try {
            OpenSearch openSearch = new OpenSearch(COPERNICUS_HOST);
            pm.worked(1);
            if (pm.isCanceled()) {
                boolean bl = true;
                return bl;
            }
            CopernicusQueryBuilder queryBuilder = new CopernicusQueryBuilder(dbQuery);
            OpenSearch.PageResult pageResult = openSearch.getPages(queryBuilder.getSearchURL());
            pm.setTaskName("Searching ESA SciHub (" + pageResult.totalResults + " entries)...");
            pm.worked(1);
            if (pm.isCanceled()) {
                boolean bl = true;
                return bl;
            }
            OpenSearch.ProductResult[] productResults = openSearch.getProductResults(pageResult, SubProgressMonitor.create((ProgressMonitor)pm, (int)7));
            if (productResults == null) {
                throw new Exception("SciHub search failed");
            }
            OpenData openData = new OpenData(COPERNICUS_HOST, COPERNICUS_ODATA_ROOT);
            SystemUtils.LOG.info("CopernicusProductQuery.fullQuery: after openData");
            pm.worked(1);
            if (pm.isCanceled()) {
                boolean bl = true;
                return bl;
            }
            ProgressMonitor pm2 = SubProgressMonitor.create((ProgressMonitor)pm, (int)10);
            pm2.beginTask("Retrieving entry information...", productResults.length);
            pm2.setSubTaskName("Retrieving entry information (" + productResults.length + " entries)...");
            ArrayList<ProductEntry> resultList = new ArrayList<ProductEntry>();
            int cnt = 0;
            int pct = 1;
            int part = Math.max(50, (int)((double)productResults.length / 100.0 + 0.5));
            SystemUtils.LOG.info("CopernicusProductQuery.fullQuery: part = " + part);
            for (OpenSearch.ProductResult result : productResults) {
                if (pm.isCanceled()) break;
                if (cnt >= pct * part) {
                    SystemUtils.LOG.info("CopernicusProductQuery.fullQuery: get entries " + cnt + " out of " + productResults.length + " done");
                    ++pct;
                }
                if (pm.isCanceled()) break;
                ProductEntry productEntry = new ProductEntry(result);
                OpenData.Entry entry = openData.getEntryByID(result.id);
                productEntry.setGeoBoundary(entry.footprint);
                resultList.add(productEntry);
                ++cnt;
                pm2.worked(1);
            }
            if (cnt == productResults.length) {
                SystemUtils.LOG.info("CopernicusProductQuery.fullQuery: get entries " + cnt + " all of " + productResults.length + " done");
            }
            pm2.done();
            if (pm.isCanceled()) {
                boolean bl = true;
                return bl;
            }
            this.productEntryList = resultList.toArray(new ProductEntry[resultList.size()]);
            this.productEntryListFull = (ProductEntry[])this.productEntryList.clone();
            pm.worked(1);
            boolean bl = true;
            return bl;
        }
        finally {
            pm.done();
        }
    }

    private static Credentials.CredentialInfo getCredentials(String host) throws IOException {
        Credentials.CredentialInfo credentialInfo = Credentials.instance().get(host);
        if (credentialInfo == null) {
            throw new IOException("Credentials for " + host + " not found.");
        }
        return credentialInfo;
    }

    @Override
    public ProductEntry[] getProductEntryList() {
        if (this.productEntryList == null) {
            this.productEntryList = new ProductEntry[0];
        }
        return this.productEntryList;
    }

    @Override
    public String[] getAllMissions() {
        return COPERNICUS_MISSIONS;
    }

    @Override
    public String[] getAllProductTypes(String[] missions) {
        if (missions == null) {
            return emptyStringList;
        }
        ArrayList<String> productTypeList = new ArrayList<String>();
        if (StringUtils.contains((String[])missions, (String)COPERNICUS_MISSIONS[0])) {
            productTypeList.addAll(Arrays.asList(S1_PRODUCT_TYPES));
        }
        if (StringUtils.contains((String[])missions, (String)COPERNICUS_MISSIONS[1])) {
            productTypeList.addAll(Arrays.asList(S2_PRODUCT_TYPES));
        }
        if (StringUtils.contains((String[])missions, (String)COPERNICUS_MISSIONS[2])) {
            productTypeList.addAll(Arrays.asList(S3_PRODUCT_TYPES));
        }
        return productTypeList.toArray(new String[productTypeList.size()]);
    }

    @Override
    public String[] getAllAcquisitionModes(String[] missions) {
        if (missions == null) {
            return emptyStringList;
        }
        ArrayList<String> modesList = new ArrayList<String>();
        if (StringUtils.contains((String[])missions, (String)COPERNICUS_MISSIONS[0])) {
            modesList.addAll(Arrays.asList(S1_MODES));
        }
        if (StringUtils.contains((String[])missions, (String)COPERNICUS_MISSIONS[1])) {
            modesList.addAll(Arrays.asList(S2_MODES));
        }
        if (StringUtils.contains((String[])missions, (String)COPERNICUS_MISSIONS[2])) {
            modesList.addAll(Arrays.asList(S3_MODES));
        }
        return modesList.toArray(new String[modesList.size()]);
    }

    static {
        emptyStringList = new String[0];
        COPERNICUS_MISSIONS = new String[]{"Sentinel-1", "Sentinel-2", "Sentinel-3"};
        S1_PRODUCT_TYPES = new String[]{"SLC", "GRD", "OCN"};
        S2_PRODUCT_TYPES = new String[]{"S2MSI1C"};
        S3_PRODUCT_TYPES = new String[]{"OLCI"};
        S1_MODES = new String[]{"SM", "IW", "EW", "WV"};
        S2_MODES = new String[]{"S2MSI1C"};
        S3_MODES = new String[]{"OLCI"};
    }
}

