/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.opendata;

import com.bc.ceres.core.ProgressMonitor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import javax.net.ssl.HttpsURLConnection;
import org.apache.olingo.odata2.api.commons.HttpStatusCodes;
import org.esa.snap.core.util.SystemUtils;

class HTTPDownloader {
    private static final String HTTP_HEADER_ACCEPT = "Accept";
    private static final String HTTP_METHOD_PUT = "PUT";
    private static final String HTTP_METHOD_POST = "POST";
    static final String HTTP_METHOD_GET = "GET";
    private static final String HTTP_HEADER_CONTENT_TYPE = "Content-Type";
    private static final int BUFFER_SIZE = 8192;
    private static final int MB = 0x100000;
    private static final char[] hexArray = "0123456789ABCDEF".toCharArray();

    HTTPDownloader() {
    }

    public static InputStream connect(String relativeUri, String contentType, String httpMethod, String user, String password) throws IOException {
        HttpURLConnection connection = HTTPDownloader.initializeConnection(relativeUri, contentType, httpMethod, user, password);
        connection.connect();
        HTTPDownloader.checkStatus(connection);
        return connection.getInputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EntryFileProperty getEntryFilePropertyFromUrlString(String urlStr, String fileName, long completeFileSize, String contentType, File outputFolder, String user, String password, ProgressMonitor pm) throws IOException {
        long downloadedFileSize;
        File outFile;
        block96: {
            outFile = new File(outputFolder, fileName);
            DownloaderThreadChecker tChecker = new DownloaderThreadChecker(outFile, completeFileSize);
            HttpsURLConnection connection = null;
            OutputStream fos = null;
            InputStream in = null;
            OutputStream bout = null;
            RandomAccessFile randomAccessfile = null;
            downloadedFileSize = 0L;
            try {
                Authenticator.setDefault(new SeHttpAuthenticator(user, password));
                URL url = new URL(urlStr);
                connection = (HttpsURLConnection)url.openConnection();
                connection.setRequestProperty(HTTP_HEADER_ACCEPT, contentType);
                byte[] data = null;
                int bytesread = 0;
                int bytesBuffered = 0;
                if (outFile.exists()) {
                    downloadedFileSize = outFile.length();
                    int mbLength = (int)((completeFileSize - downloadedFileSize) / 1024L);
                    pm.beginTask("Downloading", mbLength);
                    if (downloadedFileSize < completeFileSize) {
                        SystemUtils.LOG.info("Incomplete download. Resuming.");
                        connection.setRequestProperty("Range", "bytes=" + downloadedFileSize + '-');
                        connection.connect();
                        try {
                            HTTPDownloader.checkStatus(connection);
                            if (!tChecker.isAlive()) {
                                tChecker.start();
                            }
                        }
                        catch (IOException e) {
                            SystemUtils.LOG.severe("Error: " + e.getMessage());
                            EntryFileProperty entryFileProperty = null;
                            pm.done();
                            if (bout != null) {
                                try {
                                    bout.flush();
                                }
                                catch (IOException e2) {
                                    e2.printStackTrace();
                                }
                                try {
                                    bout.close();
                                }
                                catch (IOException e3) {
                                    e3.printStackTrace();
                                }
                            }
                            if (fos != null) {
                                try {
                                    fos.flush();
                                }
                                catch (IOException e4) {
                                    e4.printStackTrace();
                                }
                                try {
                                    ((FileOutputStream)fos).close();
                                }
                                catch (IOException e5) {
                                    e5.printStackTrace();
                                }
                            }
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (IOException e6) {
                                    e6.printStackTrace();
                                }
                            }
                            if (randomAccessfile != null) {
                                try {
                                    randomAccessfile.close();
                                }
                                catch (IOException e7) {
                                    e7.printStackTrace();
                                }
                            }
                            if (connection != null) {
                                connection.disconnect();
                            }
                            if (tChecker.isAlive()) {
                                tChecker.forceStop();
                            }
                            return entryFileProperty;
                        }
                        long contentLength = connection.getContentLength();
                        if (contentLength < 1L) {
                            contentLength = completeFileSize;
                        }
                        randomAccessfile = new RandomAccessFile(outFile, "rw");
                        randomAccessfile.seek(downloadedFileSize);
                        in = connection.getInputStream();
                        long downloadDiff = completeFileSize - downloadedFileSize;
                        data = downloadDiff > 8192L ? new byte[8192] : new byte[(int)downloadDiff];
                        while ((bytesread = in.read(data)) > -1) {
                            randomAccessfile.write(data, 0, bytesread);
                            pm.worked((int)((downloadedFileSize += (long)bytesread) / 1024L));
                        }
                        break block96;
                    }
                    SystemUtils.LOG.warning("File already downloaded.");
                    break block96;
                }
                int mbLength = (int)(completeFileSize / 1024L);
                pm.beginTask("Downloading", mbLength);
                SystemUtils.LOG.info("Starting download to " + outFile.getAbsolutePath());
                connection.connect();
                try {
                    HTTPDownloader.checkStatus(connection);
                    if (!tChecker.isAlive()) {
                        tChecker.start();
                    }
                }
                catch (IOException e) {
                    SystemUtils.LOG.severe(e.getMessage());
                    EntryFileProperty entryFileProperty = null;
                    pm.done();
                    if (bout != null) {
                        try {
                            bout.flush();
                        }
                        catch (IOException e8) {
                            e8.printStackTrace();
                        }
                        try {
                            bout.close();
                        }
                        catch (IOException e9) {
                            e9.printStackTrace();
                        }
                    }
                    if (fos != null) {
                        try {
                            fos.flush();
                        }
                        catch (IOException e10) {
                            e10.printStackTrace();
                        }
                        try {
                            ((FileOutputStream)fos).close();
                        }
                        catch (IOException e11) {
                            e11.printStackTrace();
                        }
                    }
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException e12) {
                            e12.printStackTrace();
                        }
                    }
                    if (randomAccessfile != null) {
                        try {
                            randomAccessfile.close();
                        }
                        catch (IOException e13) {
                            e13.printStackTrace();
                        }
                    }
                    if (connection != null) {
                        connection.disconnect();
                    }
                    if (tChecker.isAlive()) {
                        tChecker.forceStop();
                    }
                    return entryFileProperty;
                }
                in = connection.getInputStream();
                fos = new FileOutputStream(outFile);
                bout = new BufferedOutputStream(fos, 8192);
                data = new byte[8192];
                while ((bytesread = in.read(data)) > -1) {
                    bout.write(data, 0, bytesread);
                    downloadedFileSize += (long)bytesread;
                    if ((bytesBuffered += bytesread) <= 0x100000) continue;
                    bytesBuffered = 0;
                    bout.flush();
                    pm.worked((int)(downloadedFileSize / 1024L));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                pm.done();
                if (bout != null) {
                    try {
                        bout.flush();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    try {
                        bout.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (fos != null) {
                    try {
                        fos.flush();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    try {
                        ((FileOutputStream)fos).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (randomAccessfile != null) {
                    try {
                        randomAccessfile.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (connection != null) {
                    connection.disconnect();
                }
                if (tChecker.isAlive()) {
                    tChecker.forceStop();
                }
            }
        }
        return new EntryFileProperty(outFile.getAbsolutePath(), HTTPDownloader.bytesToHex(HTTPDownloader.md5CheksumFromFilePath(outFile)), null, downloadedFileSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] md5CheksumFromFilePath(File fSource) {
        byte[] byteArrayChecksum = null;
        InputStream is = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            is = new FileInputStream(fSource);
            byte[] dataBytes = new byte[1024];
            int nread = 0;
            while ((nread = is.read(dataBytes)) != -1) {
                md.update(dataBytes, 0, nread);
            }
            byteArrayChecksum = md.digest();
        }
        catch (IOException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return byteArrayChecksum;
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    private static void printDownloadedProgress(long completeFileSize, long downloadedFileSize) {
        SystemUtils.LOG.info(HTTPDownloader.formatDownloadedProgress(completeFileSize, downloadedFileSize) + '\r');
    }

    private static String formatDownloadedProgress(long completeFileSize, long downloadedFileSize) {
        DecimalFormat dfa = new DecimalFormat("000.0");
        DecimalFormat dfb = new DecimalFormat("###,###,###,###");
        double currentProgress = (double)downloadedFileSize * 100.0 / (double)completeFileSize;
        return dfa.format(currentProgress) + "% " + dfb.format(downloadedFileSize) + " bytes";
    }

    private static String formatDownloadedProgressOnlyNumber(long completeFileSize, long downloadedFileSize) {
        DecimalFormat dfa = new DecimalFormat("000.0");
        double currentProgress = (double)downloadedFileSize * 100.0 / (double)completeFileSize;
        return dfa.format(currentProgress);
    }

    private static void checkStatus(HttpURLConnection connection) throws IOException {
        HttpStatusCodes httpStatusCode = HttpStatusCodes.fromStatusCode((int)connection.getResponseCode());
        if (400 <= httpStatusCode.getStatusCode() && httpStatusCode.getStatusCode() <= 599) {
            throw new IOException("Http Connection failed with status " + httpStatusCode.getStatusCode() + ' ' + httpStatusCode.toString() + ' ' + connection.getURL().toString());
        }
        SystemUtils.LOG.finer("HTTP Response Code: " + httpStatusCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HttpURLConnection initializeConnection(String absolutUri, String contentType, String httpMethod, String user, String password) throws IOException {
        Authenticator.setDefault(new SeHttpAuthenticator(user, password));
        HttpURLConnection connection = null;
        try {
            URL url = new URL(absolutUri);
            connection = (HttpsURLConnection)url.openConnection();
            connection.setRequestMethod(httpMethod);
            connection.setRequestProperty(HTTP_HEADER_ACCEPT, contentType);
            if (HTTP_METHOD_POST.equals(httpMethod) || HTTP_METHOD_PUT.equals(httpMethod)) {
                connection.setDoOutput(true);
                connection.setRequestProperty(HTTP_HEADER_CONTENT_TYPE, contentType);
            }
            connection.setRequestProperty("User-Agent", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/47.0.2526.106 Safari/537.36");
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return connection;
    }

    private static class DownloaderThreadChecker
    extends Thread {
        private final File outputFileNamePath;
        private final long len;
        private boolean forceStop = false;
        private ExtractorStatus status;
        private static final int THREAD_SLEEP = 60000;

        DownloaderThreadChecker(File outputFileNamePath, long len) {
            this.outputFileNamePath = outputFileNamePath;
            this.len = len;
        }

        void forceStop() {
            this.forceStop = true;
            this.status = ExtractorStatus.FORCE_STOP;
            SystemUtils.LOG.info("ThreadChecker status:    " + (Object)((Object)this.status));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            RandomAccessFile raf = null;
            long lenT0 = -1L;
            long lenT1 = -1L;
            while (lenT1 < this.len && !this.forceStop) {
                try {
                    raf = new RandomAccessFile(this.outputFileNamePath, "r");
                    lenT0 = raf.length();
                    Thread.sleep(60000L);
                    lenT1 = raf.length();
                    String statusDescription = this.outputFileNamePath + " | " + HTTPDownloader.formatDownloadedProgress(this.len, lenT1);
                    if (lenT1 > lenT0) {
                        this.status = ExtractorStatus.DOWNLOADING;
                        SystemUtils.LOG.info("ThreadChecker status:\t" + HTTPDownloader.formatDownloadedProgress(this.len, lenT1));
                        continue;
                    }
                    if (this.len == lenT1 || this.len == lenT0) {
                        this.status = ExtractorStatus.FINISHED;
                        SystemUtils.LOG.info("ThreadChecker status: " + (Object)((Object)this.status));
                        continue;
                    }
                    if (lenT0 != lenT1) continue;
                    this.status = ExtractorStatus.STALLED;
                    SystemUtils.LOG.info("ThreadChecker status: " + (Object)((Object)this.status) + "         FORCE QUITING!");
                    System.exit(1);
                }
                catch (FileNotFoundException e) {
                }
                catch (IOException | InterruptedException e) {
                    e.printStackTrace();
                }
                finally {
                    if (raf == null) continue;
                    try {
                        raf.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private static class SeHttpAuthenticator
    extends Authenticator {
        private String user = null;
        private String password = null;

        SeHttpAuthenticator(String user, String password) {
            this.user = user;
            this.password = password;
        }

        @Override
        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.user, this.password.toCharArray());
        }
    }

    static class EntryFileProperty {
        private String name = null;
        private String md5Checksum = null;
        private String uuid = null;
        private long size = -1L;

        EntryFileProperty(String name, String md5Checksum, String uuid, long size) {
            this.name = name;
            this.md5Checksum = md5Checksum;
            this.uuid = uuid;
            this.size = size;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getMd5Checksum() {
            return this.md5Checksum;
        }

        public String getUuid() {
            return this.uuid;
        }

        public long getSize() {
            return this.size;
        }

        public void setSize(long size) {
            this.size = size;
        }
    }

    public static enum ExtractorStatus {
        STARTING("Starting"),
        PROCESSING_QUERY("Processing query"),
        DOWNLOADING("Downloading"),
        STALLED("Stalled"),
        FORCE_STOP("Force Stop"),
        FINISHED("Finished");

        private String value = null;

        private ExtractorStatus(String value) {
            this.value = value;
        }
    }
}

