/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.db;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Calendar;
import org.esa.snap.core.datamodel.ProductData;

public class SQLUtils {
    public static String getOrList(String columnStr, String[] values) {
        StringBuilder orListStr = new StringBuilder(columnStr.length() * values.length);
        orListStr.append('(');
        int i = 0;
        for (String v : values) {
            if (i > 0) {
                orListStr.append(" OR ");
            }
            orListStr.append(columnStr);
            orListStr.append(" = '");
            orListStr.append(v);
            orListStr.append("'");
            ++i;
        }
        orListStr.append(')');
        return orListStr.toString();
    }

    public static Date toSQLDate(ProductData.UTC utc) {
        return SQLUtils.toSQLDate(utc.getAsCalendar());
    }

    public static Date toSQLDate(Calendar cal) {
        return new Date(cal.getTimeInMillis());
    }

    public static String[] prependString(String firstValue, String[] origList) {
        String[] newList = new String[origList.length + 1];
        newList[0] = firstValue;
        System.arraycopy(origList, 0, newList, 1, origList.length);
        return newList;
    }

    public static void addAND(StringBuilder str) {
        if (str.length() > 0) {
            str.append(" AND ");
        }
    }

    public static String insertTableName(String[] tokens, String tableName, String freeQuery) {
        String query = freeQuery;
        for (String tok : tokens) {
            query = query.replaceAll(tok, tableName + '.' + tok);
        }
        return query;
    }

    public static void printResults(ResultSet results) throws SQLException {
        while (results.next()) {
            ResultSetMetaData meta = results.getMetaData();
            int colCnt = meta.getColumnCount();
            for (int i = 1; i <= colCnt; ++i) {
                String str = results.getString(i);
                System.out.print(meta.getColumnName(i) + ":" + str + " ");
            }
            System.out.println();
        }
    }
}

