/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.db;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.productlibrary.db.ProductEntry;
import org.esa.snap.productlibrary.db.SQLUtils;
import org.esa.snap.productlibrary.db.TableInterface;

public class ProductTable
implements TableInterface {
    public static final String TABLE = "APP.PRODUCTS";
    private final Connection dbConnection;
    private PreparedStatement stmtSaveNewRecord;
    private PreparedStatement stmtGetProduct;
    private PreparedStatement stmtGetProductWithPath;
    private PreparedStatement stmtGetProductInPath;
    private PreparedStatement stmtDeleteProduct;
    private PreparedStatement stmtAllMissions;
    private PreparedStatement stmtAllProductTypes;
    private PreparedStatement stmtAllAcquisitionModes;
    private static final String[] colNames = new String[]{"PATH", "PRODUCT", "MISSION", "PRODUCT_TYPE", "ACQUISITION_MODE", "PASS", "first_near_lat", "first_near_long", "first_far_lat", "first_far_long", "last_near_lat", "last_near_long", "last_far_lat", "last_far_long", "range_spacing", "azimuth_spacing", "first_line_time", "file_size", "last_modified", "file_format", "geo_boundary"};
    private static final String[] colTypes = new String[]{"VARCHAR(255)", "VARCHAR(255)", "VARCHAR(30)", "VARCHAR(30)", "VARCHAR(30)", "VARCHAR(30)", "DOUBLE", "DOUBLE", "DOUBLE", "DOUBLE", "DOUBLE", "DOUBLE", "DOUBLE", "DOUBLE", "DOUBLE", "DOUBLE", "DATE", "DOUBLE", "DOUBLE", "VARCHAR(40)", "VARCHAR(1200)"};
    private static final String strCreateProductTable = TableInterface.createTableString("APP.PRODUCTS", colNames, colTypes);
    private static final String strGetProduct = "SELECT * FROM APP.PRODUCTS WHERE ID = ?";
    private static final String strSaveProduct = TableInterface.createSaveString("APP.PRODUCTS", colNames);
    private static final String strGetListEntries = "SELECT * FROM APP.PRODUCTS ORDER BY MISSION ASC";
    private static final String strGetProductWithPath = "SELECT * FROM APP.PRODUCTS WHERE PATH = ?";
    private static final String strUpdateProduct = "UPDATE APP.PRODUCTS SET PATH = ?, MISSION = ?, PRODUCT_TYPE = ? WHERE ID = ?";
    private static final String strDeleteProduct = "DELETE FROM APP.PRODUCTS WHERE ID = ?";
    private static final String strAllMissions = "SELECT DISTINCT MISSION FROM APP.PRODUCTS";
    private static final String strAllProductTypes = "SELECT DISTINCT PRODUCT_TYPE FROM APP.PRODUCTS";
    private static final String strAllAcquisitionModes = "SELECT DISTINCT ACQUISITION_MODE FROM APP.PRODUCTS";

    public ProductTable(Connection dbConnection) throws SQLException {
        this.dbConnection = dbConnection;
    }

    @Override
    public void createTable() throws SQLException {
        try (Statement statement = this.dbConnection.createStatement();){
            statement.execute(strCreateProductTable);
        }
    }

    @Override
    public void validateTable() throws SQLException {
        this.validateTable(this.dbConnection, TABLE, colNames, colTypes);
    }

    @Override
    public void prepareStatements() throws SQLException {
        this.stmtSaveNewRecord = this.dbConnection.prepareStatement(strSaveProduct, 1);
        this.stmtGetProductWithPath = this.dbConnection.prepareStatement(strGetProductWithPath);
        this.stmtDeleteProduct = this.dbConnection.prepareStatement(strDeleteProduct);
        this.stmtAllMissions = this.dbConnection.prepareStatement(strAllMissions);
        this.stmtAllProductTypes = this.dbConnection.prepareStatement(strAllProductTypes);
        this.stmtAllAcquisitionModes = this.dbConnection.prepareStatement(strAllAcquisitionModes);
    }

    public ResultSet addRecord(ProductEntry record) throws SQLException {
        this.stmtSaveNewRecord.clearParameters();
        int i = 1;
        if (record.getFile() == null) {
            this.stmtSaveNewRecord.setString(i++, "");
        } else {
            this.stmtSaveNewRecord.setString(i++, record.getFile().getAbsolutePath());
        }
        this.stmtSaveNewRecord.setString(i++, record.getName());
        this.stmtSaveNewRecord.setString(i++, record.getMission());
        this.stmtSaveNewRecord.setString(i++, record.getProductType());
        this.stmtSaveNewRecord.setString(i++, record.getAcquisitionMode());
        this.stmtSaveNewRecord.setString(i++, record.getPass());
        this.stmtSaveNewRecord.setDouble(i++, record.getFirstNearGeoPos().getLat());
        this.stmtSaveNewRecord.setDouble(i++, record.getFirstNearGeoPos().getLon());
        this.stmtSaveNewRecord.setDouble(i++, record.getFirstFarGeoPos().getLat());
        this.stmtSaveNewRecord.setDouble(i++, record.getFirstFarGeoPos().getLon());
        this.stmtSaveNewRecord.setDouble(i++, record.getLastNearGeoPos().getLat());
        this.stmtSaveNewRecord.setDouble(i++, record.getLastNearGeoPos().getLon());
        this.stmtSaveNewRecord.setDouble(i++, record.getLastFarGeoPos().getLat());
        this.stmtSaveNewRecord.setDouble(i++, record.getLastFarGeoPos().getLon());
        this.stmtSaveNewRecord.setDouble(i++, record.getRangeSpacing());
        this.stmtSaveNewRecord.setDouble(i++, record.getAzimuthSpacing());
        this.stmtSaveNewRecord.setDate(i++, SQLUtils.toSQLDate(record.getFirstLineTime()));
        this.stmtSaveNewRecord.setDouble(i++, record.getFileSize());
        this.stmtSaveNewRecord.setDouble(i++, record.getLastModified());
        this.stmtSaveNewRecord.setString(i++, record.getFileFormat());
        String geoStr = record.formatGeoBoundayString();
        if (geoStr.length() > 1200) {
            SystemUtils.LOG.warning("Geoboundary string exceeds 1200");
            this.stmtSaveNewRecord.setString(i++, "");
        } else {
            this.stmtSaveNewRecord.setString(i++, geoStr);
        }
        int rowCount = this.stmtSaveNewRecord.executeUpdate();
        return this.stmtSaveNewRecord.getGeneratedKeys();
    }

    public void deleteRecord(int id) throws SQLException {
        this.stmtDeleteProduct.clearParameters();
        this.stmtDeleteProduct.setInt(1, id);
        this.stmtDeleteProduct.executeUpdate();
    }

    public ProductEntry getProductEntry(File path) throws SQLException {
        this.stmtGetProductWithPath.clearParameters();
        this.stmtGetProductWithPath.setString(1, path.getAbsolutePath());
        ResultSet results = this.stmtGetProductWithPath.executeQuery();
        if (results.next()) {
            return new ProductEntry(results);
        }
        return null;
    }

    public boolean pathExists(File path) throws SQLException {
        if (path == null) {
            return false;
        }
        this.stmtGetProductWithPath.clearParameters();
        this.stmtGetProductWithPath.setString(1, path.getAbsolutePath());
        ResultSet results = this.stmtGetProductWithPath.executeQuery();
        return results.next();
    }

    public ProductEntry[] getProductEntryList() throws SQLException {
        ArrayList<ProductEntry> listEntries = new ArrayList<ProductEntry>();
        try (Statement queryStatement = this.dbConnection.createStatement();){
            ResultSet results = queryStatement.executeQuery(strGetListEntries);
            while (results.next()) {
                listEntries.add(new ProductEntry(results));
            }
            ProductEntry[] productEntryArray = listEntries.toArray(new ProductEntry[listEntries.size()]);
            return productEntryArray;
        }
    }

    public String[] getAllMissions() throws SQLException {
        if (this.stmtAllMissions == null) {
            return new String[0];
        }
        ArrayList<String> listEntries = new ArrayList<String>();
        ResultSet results = this.stmtAllMissions.executeQuery();
        while (results.next()) {
            listEntries.add(results.getString(1));
        }
        return listEntries.toArray(new String[listEntries.size()]);
    }

    public String[] getAllProductTypes() throws SQLException {
        ArrayList<String> listEntries = new ArrayList<String>();
        ResultSet results = this.stmtAllProductTypes.executeQuery();
        while (results.next()) {
            listEntries.add(results.getString(1));
        }
        return listEntries.toArray(new String[listEntries.size()]);
    }

    public String[] getProductTypes(String[] missions) throws SQLException {
        if (missions == null || missions.length == 0) {
            return new String[0];
        }
        String strMissionProductTypes = "SELECT DISTINCT PRODUCT_TYPE FROM APP.PRODUCTS WHERE ";
        strMissionProductTypes = strMissionProductTypes + SQLUtils.getOrList("MISSION", missions);
        ArrayList<String> listEntries = new ArrayList<String>();
        try (Statement queryStatement = this.dbConnection.createStatement();){
            ResultSet results = queryStatement.executeQuery(strMissionProductTypes);
            while (results.next()) {
                listEntries.add(results.getString(1));
            }
            String[] stringArray = listEntries.toArray(new String[listEntries.size()]);
            return stringArray;
        }
    }

    public String[] getAllAcquisitionModes() throws SQLException {
        ArrayList<String> listEntries = new ArrayList<String>();
        ResultSet results = this.stmtAllAcquisitionModes.executeQuery();
        while (results.next()) {
            listEntries.add(results.getString(1));
        }
        return listEntries.toArray(new String[listEntries.size()]);
    }

    public String[] getAcquisitionModes(String[] missions) throws SQLException {
        if (missions == null || missions.length == 0) {
            return new String[0];
        }
        String strMissionAcquisitionModes = "SELECT DISTINCT ACQUISITION_MODE FROM APP.PRODUCTS WHERE ";
        strMissionAcquisitionModes = strMissionAcquisitionModes + SQLUtils.getOrList("MISSION", missions);
        ArrayList<String> listEntries = new ArrayList<String>();
        try (Statement queryStatement = this.dbConnection.createStatement();){
            ResultSet results = queryStatement.executeQuery(strMissionAcquisitionModes);
            while (results.next()) {
                listEntries.add(results.getString(1));
            }
            String[] stringArray = listEntries.toArray(new String[listEntries.size()]);
            return stringArray;
        }
    }
}

