/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.db;

import com.bc.ceres.core.ProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.quicklooks.Quicklook;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.gpf.CommonReaders;
import org.esa.snap.engine_utilities.util.ProductFunctions;
import org.esa.snap.productlibrary.db.ProductDB;
import org.esa.snap.productlibrary.opensearch.OpenSearch;
import org.w3c.dom.Document;

public class ProductEntry {
    public static final String FILE_SIZE = "file_size";
    public static final String LAST_MODIFIED = "last_modified";
    public static final String FILE_FORMAT = "file_format";
    public static final String GEO_BOUNDARY = "geo_boundary";
    public final DateFormat yyyMMdd_Format = ProductData.UTC.createDateFormat((String)"yyy-MM-dd");
    private final DecimalFormat decimalFormat = new DecimalFormat("0.0000");
    private int id;
    private File file;
    private long fileSize;
    private String fileSizeString = null;
    private String name;
    private String mission;
    private String productType;
    private String acquisitionMode;
    private ProductData.UTC firstLineTime;
    private String pass;
    private double range_spacing;
    private double azimuth_spacing;
    private long lastModified;
    private String fileFormat;
    private String refID;
    private MetadataElement absRoot = null;
    private final GeoPos firstNear = new GeoPos();
    private final GeoPos firstFar = new GeoPos();
    private final GeoPos lastNear = new GeoPos();
    private final GeoPos lastFar = new GeoPos();
    private GeoPos[] geoboundary;
    private boolean useGeoboundaryForBox = false;
    private Quicklook quicklook = null;

    public ProductEntry(int id, String name, File file) {
        this.id = id;
        this.name = name;
        this.file = file;
    }

    public ProductEntry(Product product) {
        this.file = product.getFileLocation();
        if (this.file != null) {
            this.lastModified = this.file.lastModified();
        }
        this.fileSize = ProductEntry.calculateFileSize(product);
        this.fileFormat = product.getProductReader().getReaderPlugIn().getFormatNames()[0];
        this.absRoot = AbstractMetadata.getAbstractedMetadata((Product)product).createDeepClone();
        if (this.absRoot != null) {
            this.name = this.absRoot.getAttributeString("PRODUCT");
            this.mission = this.absRoot.getAttributeString("MISSION");
            this.productType = this.absRoot.getAttributeString("PRODUCT_TYPE");
            this.acquisitionMode = this.absRoot.getAttributeString("ACQUISITION_MODE");
            this.pass = this.absRoot.getAttributeString("PASS");
            this.range_spacing = this.absRoot.getAttributeDouble("range_spacing");
            this.azimuth_spacing = this.absRoot.getAttributeDouble("azimuth_spacing");
            this.firstLineTime = this.absRoot.getAttributeUTC("first_line_time");
        }
        if (this.name.isEmpty() || this.name.equals("-")) {
            this.name = product.getName();
        }
        if (this.productType.isEmpty() || this.productType.equals("-")) {
            this.productType = product.getProductType();
        }
        if (this.firstLineTime.equals((Object)AbstractMetadata.NO_METADATA_UTC)) {
            this.firstLineTime = product.getStartTime();
        }
        this.getCornerPoints(product);
        if (this.mission.equals("SMOS")) {
            this.geoboundary = ProductEntry.getSMOSGeoBoundary(product);
            this.useGeoboundaryForBox = true;
        } else {
            this.geoboundary = ProductEntry.getGeoBoundary(product);
        }
        this.quicklook = product.getDefaultQuicklook();
        this.id = -1;
    }

    public ProductEntry(ResultSet results) throws SQLException {
        this.id = results.getInt(1);
        this.file = new File(results.getString("PATH"));
        this.name = results.getString("PRODUCT");
        this.mission = results.getString("MISSION");
        this.productType = results.getString("PRODUCT_TYPE");
        this.acquisitionMode = results.getString("ACQUISITION_MODE");
        this.pass = results.getString("PASS");
        this.range_spacing = results.getDouble("range_spacing");
        this.azimuth_spacing = results.getDouble("azimuth_spacing");
        Date date = results.getDate("first_line_time");
        this.firstLineTime = AbstractMetadata.parseUTC((String)date.toString(), (DateFormat)this.yyyMMdd_Format);
        this.fileSize = (long)results.getDouble(FILE_SIZE);
        this.lastModified = (long)results.getDouble(LAST_MODIFIED);
        this.fileFormat = results.getString(FILE_FORMAT);
        this.firstNear.setLocation(results.getDouble("first_near_lat"), results.getDouble("first_near_long"));
        this.firstFar.setLocation(results.getDouble("first_far_lat"), results.getDouble("first_far_long"));
        this.lastNear.setLocation(results.getDouble("last_near_lat"), results.getDouble("last_near_long"));
        this.lastFar.setLocation(results.getDouble("last_far_lat"), results.getDouble("last_far_long"));
        this.geoboundary = ProductEntry.parseGeoBoundaryStr(results.getString(GEO_BOUNDARY));
        this.quicklook = new Quicklook(this.file);
        if (this.mission.equals("SMOS")) {
            this.useGeoboundaryForBox = true;
        }
    }

    public ProductEntry(OpenSearch.ProductResult productResult) {
        this.id = -1;
        this.name = productResult.name;
        this.mission = productResult.mission;
        this.firstLineTime = productResult.utc;
        this.refID = productResult.id;
        this.acquisitionMode = productResult.mode;
        this.pass = "";
        this.fileFormat = "";
        String productType = productResult.name.substring(7, 10);
        this.productType = productType.equals("GRD") || productType.equals("SLC") || productType.equals("OCN") ? productType : "";
        this.fileSizeString = productResult.size;
        this.quicklook = new Quicklook(null);
        this.quicklook.setQuicklookLink(productResult.quicklookLink);
        if (this.quicklook.getImage(null) == null) {
            SystemUtils.LOG.warning("No quicklook for SciHub search product " + this.name + "; quicklookLink = " + productResult.quicklookLink);
        }
        this.useGeoboundaryForBox = true;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            Document doc = factory.newDocumentBuilder().parse(new URL(productResult.manifestLink).openStream());
            if (doc == null) {
                SystemUtils.LOG.warning("Null manifest for SciHub search product; manifestLink = " + productResult.manifestLink);
            }
        }
        catch (Exception e) {
            SystemUtils.LOG.warning("No manifest for SciHub search product; " + e.getMessage() + "; manifestLink = " + productResult.manifestLink);
        }
    }

    public void dispose() {
        if (this.absRoot != null) {
            this.absRoot.dispose();
        }
    }

    public static void dispose(ProductEntry[] productEntryList) {
        for (ProductEntry e : productEntryList) {
            e.dispose();
        }
    }

    private static long calculateFileSize(Product product) {
        File file = product.getFileLocation();
        if (file != null && file.getName().toLowerCase().endsWith(".zip")) {
            return file.length();
        }
        return ProductFunctions.getRawStorageSize((Product)product);
    }

    private void getCornerPoints(Product product) {
        GeoCoding geoCoding = product.getSceneGeoCoding();
        if (geoCoding == null) {
            return;
        }
        if (!geoCoding.canGetGeoPos()) {
            return;
        }
        int w = product.getSceneRasterWidth();
        int h = product.getSceneRasterHeight();
        geoCoding.getGeoPos(new PixelPos(0.0, 0.0), this.firstNear);
        geoCoding.getGeoPos(new PixelPos((double)w, 0.0), this.firstFar);
        geoCoding.getGeoPos(new PixelPos(0.0, (double)h), this.lastNear);
        geoCoding.getGeoPos(new PixelPos((double)w, (double)h), this.lastFar);
    }

    private static GeoPos[] getSMOSGeoBoundary(Product product) {
        GeoCoding gc = product.getSceneGeoCoding();
        if (gc == null) {
            return new GeoPos[0];
        }
        Band band = product.getBand("Latitude");
        if (band == null) {
            band = product.getBandAt(0);
        }
        int width = band.getRasterWidth();
        int height = band.getRasterHeight();
        float[] line = new float[width];
        double nodata = band.getNoDataValue();
        PixelPos pix = new PixelPos();
        int stepX = 20;
        int stepY = 300;
        int min = 1500;
        int max = Math.min(height, 6000);
        int size = 2 * (max - 1500) / 300;
        ArrayList<Object> geoPoints = new ArrayList<Object>(size);
        ArrayList<GeoPos> geoPoints2 = new ArrayList<GeoPos>(size);
        try {
            for (int y = 1500; y < max; y += 300) {
                band.readPixels(0, y, width, 1, line, ProgressMonitor.NULL);
                int x1 = 20;
                int x2 = width - 20;
                boolean haveX1 = false;
                boolean haveX2 = false;
                while (!(x1 >= width || x2 <= 0 || haveX1 && haveX2)) {
                    if (!haveX1) {
                        if ((double)line[x1] != nodata) {
                            haveX1 = true;
                        }
                        x1 += 20;
                    }
                    if (haveX2) continue;
                    if ((double)line[x2] != nodata) {
                        haveX2 = true;
                    }
                    x2 -= 20;
                }
                if (!haveX1 || !haveX2 || x2 - x1 <= 200) continue;
                pix.setLocation((double)x1, (double)y);
                geoPoints.add(gc.getGeoPos(pix, null));
                pix.setLocation((double)x2, (double)y);
                geoPoints2.add(gc.getGeoPos(pix, null));
            }
            for (int i = geoPoints2.size() - 1; i >= 0; --i) {
                geoPoints.add(geoPoints2.get(i));
            }
        }
        catch (Exception e) {
            SystemUtils.LOG.severe("Error reading SMOS " + e.getMessage());
        }
        return geoPoints.toArray(new GeoPos[geoPoints.size()]);
    }

    private static GeoPos[] getGeoBoundary(Product product) {
        GeoCoding gc = product.getSceneGeoCoding();
        if (gc == null) {
            return new GeoPos[0];
        }
        int step = Math.max(30, (product.getSceneRasterWidth() + product.getSceneRasterHeight()) / 10);
        GeoPos[] geoPoints = ProductUtils.createGeoBoundary((Product)product, null, (int)step, (boolean)true);
        if (geoPoints.length > 1 && !geoPoints[0].equals((Object)geoPoints[geoPoints.length - 1])) {
            GeoPos[] newgeoPoints = new GeoPos[geoPoints.length + 1];
            int i = 0;
            for (GeoPos geoPos : geoPoints) {
                newgeoPoints[i++] = geoPos;
            }
            newgeoPoints[i] = new GeoPos(geoPoints[0]);
            geoPoints = newgeoPoints;
        }
        ProductUtils.normalizeGeoPolygon((GeoPos[])geoPoints);
        return geoPoints;
    }

    public String formatGeoBoundayString() {
        StringBuilder str = new StringBuilder(this.geoboundary.length * 20);
        for (GeoPos geo : this.geoboundary) {
            str.append(this.decimalFormat.format(geo.getLat()));
            str.append(',');
            str.append(this.decimalFormat.format(geo.getLon()));
            str.append(',');
        }
        return str.toString();
    }

    private static GeoPos[] parseGeoBoundaryStr(String str) {
        ArrayList<GeoPos> geoPos = new ArrayList<GeoPos>(100);
        if (str != null && !str.isEmpty()) {
            StringTokenizer st = new StringTokenizer(str, ",");
            while (st.hasMoreTokens()) {
                geoPos.add(new GeoPos((double)Float.parseFloat(st.nextToken()), (double)Float.parseFloat(st.nextToken())));
            }
        }
        return geoPos.toArray(new GeoPos[geoPos.size()]);
    }

    public File getFile() {
        return this.file;
    }

    public String getName() {
        return this.name;
    }

    public String getMission() {
        return this.mission;
    }

    public String getProductType() {
        return this.productType;
    }

    public String getAcquisitionMode() {
        return this.acquisitionMode;
    }

    public String getPass() {
        return this.pass;
    }

    public double getRangeSpacing() {
        return this.range_spacing;
    }

    public double getAzimuthSpacing() {
        return this.azimuth_spacing;
    }

    public GeoPos getFirstNearGeoPos() {
        return this.firstNear;
    }

    public GeoPos getFirstFarGeoPos() {
        return this.firstFar;
    }

    public GeoPos getLastNearGeoPos() {
        return this.lastNear;
    }

    public GeoPos getLastFarGeoPos() {
        return this.lastFar;
    }

    public GeoPos[] getGeoBoundary() {
        if (this.geoboundary == null || this.geoboundary.length == 0) {
            return this.getBox();
        }
        return this.geoboundary;
    }

    public void setGeoBoundary(GeoPos[] geo) {
        this.geoboundary = geo;
    }

    public ProductData.UTC getFirstLineTime() {
        return this.firstLineTime;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public String getFileSizeString() {
        return this.fileSizeString;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public String getRefID() {
        return this.refID;
    }

    public MetadataElement getMetadata() {
        if (this.absRoot == null) {
            try {
                this.absRoot = ProductDB.instance().getProductMetadata(this.id);
            }
            catch (Exception e) {
                SystemUtils.LOG.severe(e.getMessage());
            }
        }
        return this.absRoot;
    }

    public boolean quickLookExists() {
        return this.quicklook != null && (this.quicklook.hasImage() || this.quicklook.hasCachedImage());
    }

    public Quicklook getQuickLook() {
        return this.quicklook;
    }

    public boolean equals(Object other) {
        boolean bEqual = false;
        if (this == other) {
            bEqual = true;
        } else if (other instanceof ProductEntry) {
            ProductEntry entry = (ProductEntry)other;
            if (this.file == null ? entry.file == null : this.file.equals(entry.file)) {
                bEqual = true;
            }
        }
        return bEqual;
    }

    public static File[] getFileList(ProductEntry[] productEntryList) {
        File[] fileList = new File[productEntryList.length];
        int i = 0;
        for (ProductEntry entry : productEntryList) {
            fileList[i++] = entry.getFile();
        }
        return fileList;
    }

    public GeoPos[] getBox() {
        if (this.useGeoboundaryForBox && this.geoboundary != null && this.geoboundary.length != 0) {
            return this.geoboundary;
        }
        GeoPos[] geoBound = new GeoPos[]{this.getFirstNearGeoPos(), this.getFirstFarGeoPos(), this.getLastFarGeoPos(), this.getLastNearGeoPos(), this.getFirstNearGeoPos()};
        return geoBound;
    }

    public static ProductEntry[] createProductEntryList(File[] fileList) {
        ArrayList<ProductEntry> entryList = new ArrayList<ProductEntry>(fileList.length);
        for (File file : fileList) {
            try {
                Product prod = CommonReaders.readProduct((File)file);
                entryList.add(new ProductEntry(prod));
                prod.dispose();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return entryList.toArray(new ProductEntry[entryList.size()]);
    }

    public static ProductEntry[] createProductEntryList(Product[] productList) {
        ArrayList<ProductEntry> entryList = new ArrayList<ProductEntry>(productList.length);
        for (Product prod : productList) {
            entryList.add(new ProductEntry(prod));
        }
        return entryList.toArray(new ProductEntry[entryList.size()]);
    }
}

