/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.esa.snap.core.datamodel.MetadataAttribute;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.productlibrary.db.ProductEntry;
import org.esa.snap.productlibrary.db.TableInterface;

public class MetadataTable
implements TableInterface {
    public static final String TABLE = "APP.METADATA";
    private final Connection dbConnection;
    private static final List<String> metadataNamesList = new ArrayList<String>();
    private PreparedStatement stmtSaveNewRecord;
    private PreparedStatement stmtDeleteProduct;
    private PreparedStatement stmtGetMetadata;
    private static final MetadataElement emptyMetadata = AbstractMetadata.addAbstractedMetadataHeader(null);
    private static String createTableStr;
    private static String saveProductStr;
    private static final String strCreateProductTable = "create table APP.METADATA (    ID          INTEGER NOT NULL PRIMARY KEY GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1)";
    private static final String strSaveProduct = "INSERT INTO APP.METADATA ";
    private static final String strDeleteProduct = "DELETE FROM APP.METADATA WHERE ID = ?";
    private static final String strGetMetadata = "SELECT * FROM APP.METADATA WHERE ID = ?";

    public MetadataTable(Connection dbConnection) throws SQLException {
        this.dbConnection = dbConnection;
    }

    @Override
    public void createTable() throws SQLException {
        try (Statement statement = this.dbConnection.createStatement();){
            statement.execute(createTableStr);
        }
    }

    @Override
    public void validateTable() throws SQLException {
        try (Statement alterStatement = this.dbConnection.createStatement();){
            MetadataAttribute[] attribList;
            alterStatement.setMaxRows(2);
            String selectStr = "SELECT * FROM APP.METADATA";
            ResultSet results = alterStatement.executeQuery("SELECT * FROM APP.METADATA");
            ResultSetMetaData meta = results.getMetaData();
            int colCnt = meta.getColumnCount();
            String[] colNames = new String[colCnt + 1];
            for (int i = 1; i <= colCnt; ++i) {
                colNames[i] = meta.getColumnName(i);
            }
            for (MetadataAttribute attrib : attribList = emptyMetadata.getAttributes()) {
                String name = attrib.getName();
                boolean found = false;
                for (String col : colNames) {
                    if (!name.equalsIgnoreCase(col)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                int dataType = attrib.getDataType();
                String alterStr = "ALTER TABLE APP.METADATA ADD COLUMN " + name + ' ' + MetadataTable.getDataType(dataType) + " DEFAULT " + MetadataTable.getDefault(dataType) + " NOT NULL";
                alterStatement.execute(alterStr);
            }
        }
    }

    private static void createTableStrings() {
        MetadataAttribute[] attribList;
        createTableStr = strCreateProductTable;
        String namesStr = "";
        String valueStr = "";
        for (MetadataAttribute attrib : attribList = emptyMetadata.getAttributes()) {
            String name = attrib.getName();
            metadataNamesList.add(name);
            createTableStr = createTableStr + ", " + name + ' ' + MetadataTable.getDataType(attrib.getDataType());
            namesStr = namesStr + name + ',';
            valueStr = valueStr + "?,";
        }
        createTableStr = createTableStr + ")";
        namesStr = namesStr.substring(0, namesStr.length() - 1);
        valueStr = valueStr.substring(0, valueStr.length() - 1);
        saveProductStr = "INSERT INTO APP.METADATA (" + namesStr + ')' + "VALUES (" + valueStr + ')';
    }

    private static String getDataType(int dataType) {
        if (dataType == 30) {
            return "FLOAT";
        }
        if (dataType == 31) {
            return "DOUBLE";
        }
        if (dataType == 51) {
            return "VARCHAR(255)";
        }
        if (dataType < 30) {
            return "INTEGER";
        }
        return "VARCHAR(555)";
    }

    private static String getDefault(int dataType) {
        if (dataType == 30) {
            return "99999";
        }
        if (dataType == 31) {
            return "99999";
        }
        if (dataType == 51) {
            return " ";
        }
        if (dataType < 30) {
            return "99999";
        }
        return "' '";
    }

    @Override
    public void prepareStatements() throws SQLException {
        this.stmtSaveNewRecord = this.dbConnection.prepareStatement(saveProductStr, 1);
        this.stmtDeleteProduct = this.dbConnection.prepareStatement(strDeleteProduct);
        this.stmtGetMetadata = this.dbConnection.prepareStatement(strGetMetadata);
    }

    public ResultSet addRecord(ProductEntry record) throws SQLException {
        this.stmtSaveNewRecord.clearParameters();
        MetadataElement absRoot = record.getMetadata();
        if (absRoot == null) {
            throw new SQLException("Metadata is null");
        }
        MetadataAttribute[] attribList = emptyMetadata.getAttributes();
        int i = 1;
        for (MetadataAttribute attrib : attribList) {
            String name = attrib.getName();
            int dataType = attrib.getDataType();
            if (dataType == 30) {
                this.stmtSaveNewRecord.setFloat(i, (float)absRoot.getAttributeDouble(name));
            } else if (dataType == 31) {
                this.stmtSaveNewRecord.setDouble(i, absRoot.getAttributeDouble(name));
            } else if (dataType == 51) {
                this.stmtSaveNewRecord.setString(i, absRoot.getAttributeUTC(name).getElemString());
            } else if (dataType < 30) {
                this.stmtSaveNewRecord.setInt(i, absRoot.getAttributeInt(name));
            } else {
                this.stmtSaveNewRecord.setString(i, absRoot.getAttributeString(name));
            }
            ++i;
        }
        int rowCount = this.stmtSaveNewRecord.executeUpdate();
        return this.stmtSaveNewRecord.getGeneratedKeys();
    }

    public void deleteRecord(int id) throws SQLException {
        this.stmtDeleteProduct.clearParameters();
        this.stmtDeleteProduct.setInt(1, id);
        this.stmtDeleteProduct.executeUpdate();
    }

    public MetadataElement getProductMetadata(int id) throws SQLException {
        this.stmtGetMetadata.clearParameters();
        this.stmtGetMetadata.setString(1, String.valueOf(id));
        ResultSet results = this.stmtGetMetadata.executeQuery();
        if (results.next()) {
            return MetadataTable.createMetadataRoot(results);
        }
        return null;
    }

    private static MetadataElement createMetadataRoot(ResultSet results) {
        MetadataAttribute[] attribList;
        MetadataElement absRoot = AbstractMetadata.addAbstractedMetadataHeader(null);
        for (MetadataAttribute attrib : attribList = emptyMetadata.getAttributes()) {
            try {
                int dataType = attrib.getDataType();
                String name = attrib.getName();
                if (dataType == 30) {
                    AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)name, (double)results.getFloat(name));
                    continue;
                }
                if (dataType == 31) {
                    AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)name, (double)results.getDouble(name));
                    continue;
                }
                if (dataType == 51) {
                    AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)name, (ProductData.UTC)AbstractMetadata.parseUTC((String)results.getString(name)));
                    continue;
                }
                if (dataType < 30) {
                    AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)name, (int)results.getInt(name));
                    continue;
                }
                AbstractMetadata.setAttribute((MetadataElement)absRoot, (String)name, (String)results.getString(name));
            }
            catch (Exception e) {
                SystemUtils.LOG.severe(e.getMessage());
            }
        }
        return absRoot;
    }

    public static String[] getAllMetadataNames() {
        return metadataNamesList.toArray(new String[metadataNamesList.size()]);
    }

    static {
        MetadataTable.createTableStrings();
    }
}

