/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.rcp.toolviews.listviews;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.esa.snap.engine_utilities.db.ProductEntry;
import org.esa.snap.productlibrary.rcp.toolviews.support.SortingDecorator;

public interface ListView {
    public static final List<ListViewListener> listenerList = new ArrayList<ListViewListener>();

    public File[] getSelectedFiles();

    public ProductEntry[] getSelectedProductEntries();

    public ProductEntry getEntryOverMouse();

    public void sort(SortingDecorator.SORT_BY var1);

    public void selectAll();

    public void clearSelection();

    public int getTotalCount();

    public int getSelectionCount();

    public void updateUI();

    public void setProductEntryList(ProductEntry[] var1);

    default public void addListener(ListViewListener listener) {
        if (!listenerList.contains(listener)) {
            listenerList.add(listener);
        }
    }

    default public void notifySelectionChanged() {
        for (ListViewListener listener : listenerList) {
            listener.notifySelectionChanged();
        }
    }

    default public void notifyOpenAction() {
        for (ListViewListener listener : listenerList) {
            listener.notifyOpenAction();
        }
    }

    public static interface ListViewListener {
        public void notifySelectionChanged();

        public void notifyOpenAction();
    }
}

