/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.rcp.toolviews;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.filechooser.FileFilter;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.engine_utilities.db.DBProductQuery;
import org.esa.snap.engine_utilities.db.ProductEntry;
import org.esa.snap.engine_utilities.download.opensearch.CopernicusProductQuery;
import org.esa.snap.graphbuilder.gpf.ui.worldmap.WorldMapUI;
import org.esa.snap.graphbuilder.rcp.progress.LabelBarProgressMonitor;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.productlibrary.rcp.dialogs.CheckListDialog;
import org.esa.snap.productlibrary.rcp.toolviews.DBScanner;
import org.esa.snap.productlibrary.rcp.toolviews.DBWorker;
import org.esa.snap.productlibrary.rcp.toolviews.DatabasePane;
import org.esa.snap.productlibrary.rcp.toolviews.ProductFileHandler;
import org.esa.snap.productlibrary.rcp.toolviews.ProductLibraryActions;
import org.esa.snap.productlibrary.rcp.toolviews.extensions.ProductLibraryActionExt;
import org.esa.snap.productlibrary.rcp.toolviews.listviews.ListView;
import org.esa.snap.productlibrary.rcp.toolviews.listviews.ProductEntryList;
import org.esa.snap.productlibrary.rcp.toolviews.listviews.ProductEntryTable;
import org.esa.snap.productlibrary.rcp.toolviews.listviews.ThumbnailView;
import org.esa.snap.productlibrary.rcp.toolviews.model.DatabaseStatistics;
import org.esa.snap.productlibrary.rcp.toolviews.model.ProductLibraryConfig;
import org.esa.snap.productlibrary.rcp.toolviews.model.repositories.FolderRepository;
import org.esa.snap.productlibrary.rcp.toolviews.model.repositories.RepositoryInterface;
import org.esa.snap.productlibrary.rcp.toolviews.model.repositories.ScihubRepository;
import org.esa.snap.productlibrary.rcp.toolviews.support.ComboCellRenderer;
import org.esa.snap.productlibrary.rcp.toolviews.support.SortingDecorator;
import org.esa.snap.productlibrary.rcp.toolviews.timeline.TimelinePanel;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.rcp.windows.ToolTopComponent;
import org.esa.snap.ui.UIUtils;
import org.openide.util.HelpCtx;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="ProductLibraryTopComponent", iconBase="org/esa/snap/productlibrary/icons/search.png", persistenceType=0)
public class ProductLibraryToolView
extends ToolTopComponent
implements LabelBarProgressMonitor.ProgressBarListener,
DatabasePane.DatabaseQueryListener,
WorldMapUI.WorldMapUIListener,
ListView.ListViewListener {
    private static ImageIcon updateIcon;
    private static ImageIcon searchIcon;
    private static ImageIcon stopIcon;
    private static ImageIcon helpIcon;
    private static ImageIcon addButtonIcon;
    private static ImageIcon removeButtonIcon;
    private static final String LAST_ERROR_OUTPUT_DIR_KEY = "snap.lastErrorOutputDir";
    private JPanel mainPanel;
    private JComboBox<RepositoryInterface> repositoryListCombo;
    private ProductEntryTable productEntryTable;
    private ProductEntryList productEntryList;
    private ThumbnailView thumbnailView;
    private ListView currentListView;
    private JLabel statusLabel;
    private JPanel progressPanel;
    private JScrollPane listViewPane;
    private JScrollPane tableViewPane;
    private JScrollPane thumbnailPane;
    private JSplitPane splitPaneV;
    private JButton addButton;
    private JButton removeButton;
    private JButton updateButton;
    private JButton searchButton;
    private static final String RESCAN = "Rescan folder";
    private LabelBarProgressMonitor progMon;
    private JProgressBar progressBar;
    private JButton stopButton;
    private ProductLibraryConfig libConfig;
    private static final String helpId = "productLibrary";
    private WorldMapUI worldMapUI = null;
    private DatabasePane dbPane;
    private ProductLibraryActions productLibraryActions;
    private boolean initialized = false;
    private int repositoryFolderStartIndex;

    public ProductLibraryToolView() {
        this.setDisplayName("Product Library");
    }

    protected void componentShowing() {
        if (!this.initialized) {
            this.initialize();
        }
    }

    private synchronized void initialize() {
        this.initDatabase();
        this.initUI();
        this.initialized = true;
    }

    private void initDatabase() {
        this.libConfig = new ProductLibraryConfig(SnapApp.getDefault().getPreferences());
        this.dbPane = new DatabasePane();
        this.dbPane.addListener(this);
    }

    private static void loadIcons() {
        updateIcon = UIUtils.loadImageIcon((String)"/org/esa/snap/productlibrary/icons/refresh24.png", ProductLibraryToolView.class);
        searchIcon = UIUtils.loadImageIcon((String)"/org/esa/snap/productlibrary/icons/search24.png", ProductLibraryToolView.class);
        stopIcon = UIUtils.loadImageIcon((String)"icons/Stop24.gif");
        addButtonIcon = UIUtils.loadImageIcon((String)"icons/Plus24.gif");
        removeButtonIcon = UIUtils.loadImageIcon((String)"icons/Minus24.gif");
        helpIcon = UIUtils.loadImageIcon((String)"icons/Help24.gif");
    }

    private void initUI() {
        ProductLibraryToolView.loadIcons();
        JPanel northPanel = this.createHeaderPanel();
        JPanel centrePanel = this.createCentrePanel();
        JPanel southPanel = this.createStatusPanel();
        ProductLibraryActionExt.listenerList.add(new ProductLibraryActionExtListener());
        DatabaseStatistics stats = new DatabaseStatistics(this.dbPane);
        TimelinePanel timeLinePanel = new TimelinePanel(stats);
        this.dbPane.addListener(timeLinePanel);
        JSplitPane splitPane = new JSplitPane(0, centrePanel, timeLinePanel);
        splitPane.setOneTouchExpandable(true);
        splitPane.setResizeWeight(0.99);
        this.mainPanel = new JPanel(new BorderLayout(4, 4));
        this.mainPanel.add((Component)northPanel, "North");
        this.mainPanel.add((Component)splitPane, "Center");
        this.mainPanel.add((Component)southPanel, "South");
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.mainPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                if (ProductLibraryToolView.this.progMon != null) {
                    ProductLibraryToolView.this.progMon.setCanceled(true);
                }
            }
        });
        this.populateRepositoryListCombo(this.libConfig);
        this.mainPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentMoved(ComponentEvent e) {
                ProductLibraryToolView.this.libConfig.setWindowBounds(e.getComponent().getBounds());
            }

            @Override
            public void componentResized(ComponentEvent e) {
                ProductLibraryToolView.this.libConfig.setWindowBounds(e.getComponent().getBounds());
            }
        });
        this.setUIComponentsEnabled();
        this.setLayout(new BorderLayout());
        this.add(this.mainPanel, "Center");
    }

    private JPanel createHeaderPanel() {
        JPanel headerBar = new JPanel();
        headerBar.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 18;
        this.updateButton = DialogUtils.createButton((String)"updateButton", (String)RESCAN, (ImageIcon)updateIcon, (JPanel)headerBar, (DialogUtils.ButtonStyle)DialogUtils.ButtonStyle.Icon);
        this.updateButton.setActionCommand("update");
        this.updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("stop")) {
                    ProductLibraryToolView.this.updateButton.setEnabled(false);
                    ProductLibraryToolView.this.mainPanel.setCursor(Cursor.getPredefinedCursor(3));
                    if (ProductLibraryToolView.this.progMon != null) {
                        ProductLibraryToolView.this.progMon.setCanceled(true);
                    }
                } else {
                    RescanOptions dlg = new RescanOptions();
                    dlg.show();
                    if (dlg.IsOK()) {
                        DBScanner.Options options = new DBScanner.Options(dlg.shouldDoRecusive(), dlg.shouldValidateZips(), dlg.shouldDoQuicklooks());
                        ProductLibraryToolView.this.rescanFolder(options);
                    }
                }
            }
        });
        headerBar.add((Component)this.updateButton, gbc);
        headerBar.add(new JLabel("Folder:"));
        gbc.weightx = 99.0;
        this.repositoryListCombo = new JComboBox();
        this.repositoryListCombo.setRenderer(new ComboCellRenderer());
        this.repositoryListCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (event.getStateChange() == 1) {
                    RepositoryInterface repo = (RepositoryInterface)ProductLibraryToolView.this.repositoryListCombo.getSelectedItem();
                    ProductLibraryToolView.this.dbPane.setRepository(repo);
                    SystemUtils.LOG.info("ProductLibraryToolView: selected " + repo.getName());
                    ProductLibraryToolView.this.setUIComponentsEnabled();
                }
            }
        });
        headerBar.add(this.repositoryListCombo, gbc);
        gbc.weightx = 0.0;
        this.searchButton = DialogUtils.createButton((String)"searchButton", (String)"Apply Search Query", (ImageIcon)searchIcon, (JPanel)headerBar, (DialogUtils.ButtonStyle)DialogUtils.ButtonStyle.Icon);
        this.searchButton.setActionCommand("update");
        this.searchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductLibraryToolView.this.search();
            }
        });
        headerBar.add((Component)this.searchButton, gbc);
        this.addButton = DialogUtils.createButton((String)"addButton", (String)"Add folder", (ImageIcon)addButtonIcon, (JPanel)headerBar, (DialogUtils.ButtonStyle)DialogUtils.ButtonStyle.Icon);
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductLibraryToolView.this.addRepository();
            }
        });
        headerBar.add((Component)this.addButton, gbc);
        this.removeButton = DialogUtils.createButton((String)"removeButton", (String)"Remove folder", (ImageIcon)removeButtonIcon, (JPanel)headerBar, (DialogUtils.ButtonStyle)DialogUtils.ButtonStyle.Icon);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductLibraryToolView.this.removeRepository();
            }
        });
        headerBar.add((Component)this.removeButton, gbc);
        JButton helpButton = DialogUtils.createButton((String)"helpButton", (String)"Help", (ImageIcon)helpIcon, (JPanel)headerBar, (DialogUtils.ButtonStyle)DialogUtils.ButtonStyle.Icon);
        HelpCtx.setHelpIDString((JComponent)helpButton, (String)helpId);
        helpButton.addActionListener(e -> new HelpCtx(helpId).display());
        headerBar.add((Component)helpButton, gbc);
        return headerBar;
    }

    private JPanel createStatusPanel() {
        JPanel southPanel = new JPanel(new BorderLayout(4, 4));
        this.statusLabel = new JLabel("");
        this.statusLabel.setMinimumSize(new Dimension(100, 10));
        southPanel.add((Component)this.statusLabel, "Center");
        this.progressBar = new JProgressBar();
        this.progressBar.setName(this.getClass().getName() + "progressBar");
        this.progressBar.setStringPainted(true);
        this.progressPanel = new JPanel();
        this.progressPanel.setLayout(new BorderLayout());
        this.progressPanel.add((Component)this.progressBar, "Center");
        this.stopButton = DialogUtils.createButton((String)"stopButton", (String)"Stop", (ImageIcon)stopIcon, (JPanel)this.progressPanel, (DialogUtils.ButtonStyle)DialogUtils.ButtonStyle.Icon);
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProductLibraryToolView.this.mainPanel.setCursor(Cursor.getPredefinedCursor(3));
                if (ProductLibraryToolView.this.progMon != null) {
                    ProductLibraryToolView.this.progMon.setCanceled(true);
                }
            }
        });
        this.progressPanel.add((Component)this.stopButton, "East");
        this.progressPanel.setVisible(false);
        southPanel.add((Component)this.progressPanel, "East");
        return southPanel;
    }

    private JPanel createCentrePanel() {
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.setMinimumSize(new Dimension(200, 577));
        leftPanel.add((Component)this.dbPane, "North");
        this.productLibraryActions = new ProductLibraryActions(this);
        this.productEntryTable = new ProductEntryTable(this.productLibraryActions);
        this.productEntryTable.addListener(this);
        this.productEntryList = new ProductEntryList(this.productLibraryActions);
        this.productEntryList.addListener(this);
        this.thumbnailView = new ThumbnailView(this.productLibraryActions);
        this.thumbnailView.addListener(this);
        this.currentListView = this.productEntryTable;
        JPanel commandPanel = this.productLibraryActions.createCommandPanel();
        this.listViewPane = new JScrollPane(this.productEntryList);
        this.listViewPane.setMinimumSize(new Dimension(400, 400));
        this.tableViewPane = new JScrollPane(this.productEntryTable);
        this.tableViewPane.setMinimumSize(new Dimension(400, 400));
        this.thumbnailPane = new JScrollPane((Component)((Object)this.thumbnailView));
        this.thumbnailPane.setMinimumSize(new Dimension(400, 400));
        this.thumbnailPane.getViewport().setScrollMode(0);
        this.worldMapUI = new WorldMapUI();
        this.worldMapUI.addListener((WorldMapUI.WorldMapUIListener)this);
        this.splitPaneV = new JSplitPane(0, this.tableViewPane, (Component)this.worldMapUI.getWorlMapPane());
        this.splitPaneV.setOneTouchExpandable(true);
        this.splitPaneV.setResizeWeight(0.8);
        JPanel centrePanel = new JPanel(new BorderLayout());
        centrePanel.add((Component)leftPanel, "West");
        centrePanel.add((Component)this.splitPaneV, "Center");
        centrePanel.add((Component)commandPanel, "East");
        return centrePanel;
    }

    private void populateRepositoryListCombo(ProductLibraryConfig config) {
        File[] baseDirList;
        this.repositoryFolderStartIndex = 0;
        this.repositoryListCombo.insertItemAt(new FolderRepository("All_Folders", null), this.repositoryFolderStartIndex++);
        this.repositoryListCombo.insertItemAt(new ScihubRepository(), this.repositoryFolderStartIndex++);
        for (File f : baseDirList = config.getBaseDirs()) {
            this.repositoryListCombo.insertItemAt(new FolderRepository(f.getAbsolutePath(), f), this.repositoryListCombo.getItemCount());
        }
        this.repositoryListCombo.setSelectedIndex(0);
    }

    private RepositoryInterface getRepositoryFromListCombo(File file) {
        int total = this.repositoryListCombo.getItemCount();
        for (int i = 0; i < total; ++i) {
            RepositoryInterface repo = this.repositoryListCombo.getItemAt(i);
            if (!file.getAbsolutePath().equals(repo.getName())) continue;
            return repo;
        }
        return null;
    }

    private RepositoryInterface addToRepositoryListCombo(File baseDir) {
        RepositoryInterface repo = this.getRepositoryFromListCombo(baseDir);
        if (repo == null) {
            repo = new FolderRepository(baseDir.getAbsolutePath(), baseDir);
            this.repositoryListCombo.insertItemAt(repo, this.repositoryListCombo.getItemCount());
        }
        return repo;
    }

    private void addRepository(File baseDir, DBScanner.Options options) {
        this.libConfig.addBaseDir(baseDir);
        RepositoryInterface repo = this.addToRepositoryListCombo(baseDir);
        this.setUIComponentsEnabled();
        this.updateRepostitory(repo, options);
    }

    private void addRepository() {
        File baseDir = this.productLibraryActions.promptForRepositoryBaseDir();
        if (baseDir == null) {
            return;
        }
        RescanOptions dlg = new RescanOptions();
        dlg.show();
        if (dlg.IsOK()) {
            DBScanner.Options options = new DBScanner.Options(dlg.shouldDoRecusive(), dlg.shouldValidateZips(), dlg.shouldDoQuicklooks());
            this.addRepository(baseDir, options);
        }
    }

    private void removeRepository() {
        Object selectedItem = this.repositoryListCombo.getSelectedItem();
        int index = this.repositoryListCombo.getSelectedIndex();
        if (index == 0) {
            Dialogs.Answer status = Dialogs.requestDecision((String)"Remove folders", (String)"This will remove all folders and products from the database.\nAre you sure you wish to continue?", (boolean)true, null);
            if (status == Dialogs.Answer.YES) {
                while (this.repositoryListCombo.getItemCount() > this.repositoryFolderStartIndex) {
                    FolderRepository repo = (FolderRepository)this.repositoryListCombo.getItemAt(this.repositoryFolderStartIndex);
                    this.libConfig.removeBaseDir(repo.getBaseDir());
                    this.repositoryListCombo.removeItemAt(this.repositoryFolderStartIndex);
                }
                this.removeProducts(null);
                this.UpdateUI();
            }
        } else if (selectedItem instanceof FolderRepository) {
            FolderRepository repo = (FolderRepository)selectedItem;
            Dialogs.Answer status = Dialogs.requestDecision((String)"Remove products", (String)("This will remove all products within " + repo.getBaseDir().getAbsolutePath() + " from the database\nAre you sure you wish to continue?"), (boolean)true, null);
            if (status == Dialogs.Answer.YES) {
                this.libConfig.removeBaseDir(repo.getBaseDir());
                this.repositoryListCombo.removeItemAt(index);
                this.removeProducts(repo);
                this.UpdateUI();
            }
        }
    }

    private boolean doRepositoriesExist() {
        return this.repositoryListCombo.getItemCount() > this.repositoryFolderStartIndex;
    }

    LabelBarProgressMonitor getLabelBarProgressMonitor() {
        if (this.progMon == null) {
            this.progMon = new LabelBarProgressMonitor(this.progressBar, this.statusLabel);
            this.progMon.addListener((LabelBarProgressMonitor.ProgressBarListener)this);
        }
        return this.progMon;
    }

    public File[] getSelectedFiles() {
        return this.currentListView.getSelectedFiles();
    }

    public ProductEntry[] getSelectedProductEntries() {
        return this.currentListView.getSelectedProductEntries();
    }

    ProductEntry getEntryOverMouse() {
        return this.currentListView.getEntryOverMouse();
    }

    public void sort(SortingDecorator.SORT_BY sortBy) {
        this.currentListView.sort(sortBy);
    }

    public void selectAll() {
        this.currentListView.selectAll();
        this.notifySelectionChanged();
    }

    void selectNone() {
        this.currentListView.clearSelection();
        this.notifySelectionChanged();
    }

    public void setSelectedRepositoryToSciHub() {
        for (int i = 0; i < this.repositoryListCombo.getItemCount(); ++i) {
            RepositoryInterface repository = this.repositoryListCombo.getItemAt(i);
            if (!(repository instanceof ScihubRepository)) continue;
            this.repositoryListCombo.setSelectedItem(repository);
        }
    }

    private synchronized void search() {
        this.progMon = this.getLabelBarProgressMonitor();
        DBWorker dbWorker = new DBWorker(DBWorker.TYPE.QUERY, this.dbPane, (ProgressMonitor)this.progMon);
        dbWorker.addListener(new DBWorkerListener());
        dbWorker.execute();
    }

    private synchronized void updateRepostitory(RepositoryInterface repo, DBScanner.Options options) {
        if (repo instanceof FolderRepository) {
            FolderRepository folderRepo = (FolderRepository)repo;
            if (folderRepo.getBaseDir() == null) {
                return;
            }
            this.progMon = this.getLabelBarProgressMonitor();
            DBScanner scanner = new DBScanner(((DBProductQuery)folderRepo.getProductQueryInterface()).getDB(), folderRepo.getBaseDir(), options, (ProgressMonitor)this.progMon);
            scanner.addListener(new MyDatabaseScannerListener(repo));
            scanner.execute();
        }
    }

    private synchronized void removeProducts(RepositoryInterface repo) {
        this.progMon = this.getLabelBarProgressMonitor();
        if (repo == null) {
            DBWorker remover = new DBWorker(DBWorker.TYPE.REMOVE, ((DBProductQuery)this.repositoryListCombo.getItemAt(0).getProductQueryInterface()).getDB(), null, (ProgressMonitor)this.progMon);
            remover.addListener(new DBWorkerListener());
            remover.execute();
        } else if (repo instanceof FolderRepository) {
            FolderRepository folderRepo = (FolderRepository)repo;
            DBWorker remover = new DBWorker(DBWorker.TYPE.REMOVE, ((DBProductQuery)folderRepo.getProductQueryInterface()).getDB(), folderRepo.getBaseDir(), (ProgressMonitor)this.progMon);
            remover.addListener(new DBWorkerListener());
            remover.execute();
        }
    }

    private void setUIComponentsEnabled() {
        RepositoryInterface repo = (RepositoryInterface)this.repositoryListCombo.getSelectedItem();
        boolean isSciHub = repo.getProductQueryInterface() instanceof CopernicusProductQuery;
        boolean enable = !isSciHub && this.doRepositoriesExist();
        this.updateButton.setEnabled(enable);
        this.removeButton.setEnabled(enable);
        this.searchButton.setEnabled(isSciHub || this.doRepositoriesExist());
    }

    private void UpdateUI() {
        this.dbPane.refresh();
        RepositoryInterface repo = (RepositoryInterface)this.repositoryListCombo.getSelectedItem();
        boolean isSciHub = repo.getProductQueryInterface() instanceof CopernicusProductQuery;
        if (!this.doRepositoriesExist() && !isSciHub) {
            this.currentListView.setProductEntryList(new ProductEntry[0]);
            this.dbPane.setSelectionRect(null);
        }
        this.currentListView.updateUI();
    }

    public ListView getCurrentListView() {
        return this.currentListView;
    }

    public synchronized void changeView() {
        this.currentListView.setProductEntryList(new ProductEntry[0]);
        if (this.currentListView instanceof ProductEntryList) {
            this.currentListView = this.productEntryTable;
            this.splitPaneV.setLeftComponent(this.tableViewPane);
        } else if (this.currentListView instanceof ProductEntryTable) {
            this.currentListView = this.thumbnailView;
            this.splitPaneV.setLeftComponent(this.thumbnailPane);
        } else if (this.currentListView instanceof ThumbnailView) {
            this.currentListView = this.productEntryList;
            this.splitPaneV.setLeftComponent(this.listViewPane);
        }
        this.notifyNewEntryListAvailable();
    }

    public void findSlices(int dataTakeId) {
        this.dbPane.findSlices(dataTakeId);
    }

    private void rescanFolder(DBScanner.Options options) {
        if (this.repositoryListCombo.getSelectedIndex() == 0) {
            for (int i = this.repositoryFolderStartIndex; i < this.repositoryListCombo.getItemCount(); ++i) {
                this.updateRepostitory(this.repositoryListCombo.getItemAt(i), options);
            }
        } else {
            this.updateRepostitory((RepositoryInterface)this.repositoryListCombo.getSelectedItem(), options);
        }
    }

    private void updateStatusLabel() {
        String selectedText = "";
        int selectedCount = this.currentListView.getSelectionCount();
        if (selectedCount > 0) {
            selectedText = ", " + selectedCount + " Selected";
        } else {
            this.dbPane.updateProductSelectionText(null);
        }
        this.statusLabel.setText(this.currentListView.getTotalCount() + " Products" + selectedText);
    }

    private void showRepository(ProductEntry[] productEntryList) {
        if (productEntryList == null) {
            return;
        }
        this.currentListView.setProductEntryList(productEntryList);
        this.notifySelectionChanged();
        GeoPos[][] geoBoundaries = new GeoPos[productEntryList.length][4];
        int i = 0;
        for (ProductEntry entry : productEntryList) {
            geoBoundaries[i++] = entry.getGeoBoundary();
        }
        this.worldMapUI.setAdditionalGeoBoundaries(geoBoundaries);
        this.worldMapUI.setSelectedGeoBoundaries((GeoPos[][])null);
    }

    private static void handleErrorList(List<DBScanner.ErrorFile> errorList) {
        File file;
        StringBuilder str = new StringBuilder();
        int cnt = 1;
        for (DBScanner.ErrorFile err : errorList) {
            str.append(err.message);
            str.append("   ");
            str.append(err.file.getAbsolutePath());
            str.append('\n');
            if (cnt >= 20) {
                str.append("plus " + (errorList.size() - 20) + " other errors...\n");
                break;
            }
            ++cnt;
        }
        String question = "\nWould you like to save the list to a text file?";
        if (Dialogs.requestDecision((String)"Product Errors", (String)("The follow files have errors:\n" + str.toString() + "\nWould you like to save the list to a text file?"), (boolean)false, null) == Dialogs.Answer.YES && (file = Dialogs.requestFileForSave((String)"Save as...", (boolean)false, (FileFilter)new SnapFileFilter("Text File", new String[]{".txt"}, "Text File"), (String)".txt", (String)"ProductErrorList", null, (String)LAST_ERROR_OUTPUT_DIR_KEY)) != null) {
            try {
                ProductLibraryToolView.writeErrors(errorList, file);
            }
            catch (Exception e) {
                Dialogs.showError((String)("Unable to save to " + file.getAbsolutePath()));
            }
            if (Desktop.isDesktopSupported() && file.exists()) {
                try {
                    Desktop.getDesktop().open(file);
                }
                catch (Exception e) {
                    SystemUtils.LOG.warning("Unable to open error file: " + e.getMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeErrors(List<DBScanner.ErrorFile> errorList, File file) throws Exception {
        if (file == null) {
            return;
        }
        try (PrintStream p = null;){
            FileOutputStream out = new FileOutputStream(file.getAbsolutePath());
            p = new PrintStream(out);
            for (DBScanner.ErrorFile err : errorList) {
                p.println(err.message + "   " + err.file.getAbsolutePath());
            }
        }
    }

    public void notifyProgressStart() {
        if (this.progMon.isCanceled()) {
            return;
        }
        this.progressPanel.setVisible(true);
    }

    public void notifyProgressDone() {
        this.progressPanel.setVisible(false);
        this.updateButton.setEnabled(true);
        this.mainPanel.setCursor(Cursor.getDefaultCursor());
    }

    @Override
    public void notifyNewEntryListAvailable() {
        this.showRepository(this.dbPane.getProductEntryList());
    }

    public void notifyNewMapSelectionAvailable() {
        this.dbPane.setSelectionRect(this.worldMapUI.getSelectionBox());
    }

    @Override
    public void notifySelectionChanged() {
        this.updateStatusLabel();
        ProductEntry[] selections = this.getSelectedProductEntries();
        this.productLibraryActions.selectionChanged(selections);
        this.productLibraryActions.updateContextMenu(selections);
        this.dbPane.updateProductSelectionText(selections);
        if (selections != null) {
            GeoPos[][] geoBoundaries = new GeoPos[selections.length][4];
            int i = 0;
            for (ProductEntry entry : selections) {
                geoBoundaries[i++] = entry.getGeoBoundary();
            }
            this.worldMapUI.setSelectedGeoBoundaries(geoBoundaries);
        } else {
            this.worldMapUI.setSelectedGeoBoundaries((GeoPos[][])null);
        }
    }

    @Override
    public void notifyOpenAction() {
        this.productLibraryActions.performOpenAction();
    }

    DBWorker.DBWorkerListener createDBListener() {
        return new DBWorkerListener();
    }

    ProductFileHandler.ProductFileHandlerListener createProductFileHandlerListener() {
        return new FileHandlerListener();
    }

    private static class RescanOptions
    extends CheckListDialog {
        private static final String TITLE = "Scan Folder Options";
        private static final String SEARCH_RECURSIVELY = "Search folder recursively?";
        private static final String VERIFY_ZIP_FILES = "Test zip files for errors?";
        private static final String GENERATE_QUICKLOOKS = "Generate quicklooks?";

        RescanOptions() {
            super(TITLE);
        }

        @Override
        protected void initContent() {
            this.items.put(SEARCH_RECURSIVELY, true);
            this.items.put(VERIFY_ZIP_FILES, false);
            this.items.put(GENERATE_QUICKLOOKS, false);
            super.initContent();
        }

        boolean shouldDoRecusive() {
            return (Boolean)this.items.get(SEARCH_RECURSIVELY);
        }

        boolean shouldValidateZips() {
            return (Boolean)this.items.get(VERIFY_ZIP_FILES);
        }

        boolean shouldDoQuicklooks() {
            return (Boolean)this.items.get(GENERATE_QUICKLOOKS);
        }
    }

    private class FileHandlerListener
    implements ProductFileHandler.ProductFileHandlerListener {
        private FileHandlerListener() {
        }

        @Override
        public void notifyMSG(ProductFileHandler fileHandler, ProductFileHandler.ProductFileHandlerListener.MSG msg) {
            if (msg.equals((Object)ProductFileHandler.ProductFileHandlerListener.MSG.DONE)) {
                List<DBScanner.ErrorFile> errorList = fileHandler.getErrorList();
                if (!errorList.isEmpty()) {
                    ProductLibraryToolView.handleErrorList(errorList);
                }
                if (fileHandler.getOperationType().equals((Object)ProductFileHandler.TYPE.MOVE_TO) || fileHandler.getOperationType().equals((Object)ProductFileHandler.TYPE.DELETE)) {
                    ProductLibraryToolView.this.rescanFolder(new DBScanner.Options(true, false, false));
                    ProductLibraryToolView.this.UpdateUI();
                }
            }
            ProductLibraryToolView.this.UpdateUI();
        }
    }

    private class DBWorkerListener
    implements DBWorker.DBWorkerListener {
        private DBWorkerListener() {
        }

        @Override
        public void notifyMSG(DBWorker.DBWorkerListener.MSG msg) {
            if (msg.equals((Object)DBWorker.DBWorkerListener.MSG.DONE)) {
                ProductLibraryToolView.this.setUIComponentsEnabled();
                ProductLibraryToolView.this.UpdateUI();
            }
        }
    }

    private class MyDatabaseScannerListener
    implements DBScanner.DBScannerListener {
        RepositoryInterface repo;

        MyDatabaseScannerListener(RepositoryInterface repo) {
            this.repo = repo;
        }

        @Override
        public void notifyMSG(DBScanner dbScanner, DBScanner.DBScannerListener.MSG msg) {
            if (msg.equals((Object)DBScanner.DBScannerListener.MSG.DONE)) {
                List<DBScanner.ErrorFile> errorList = dbScanner.getErrorList();
                if (!errorList.isEmpty()) {
                    ProductLibraryToolView.handleErrorList(errorList);
                }
                ProductLibraryToolView.this.repositoryListCombo.setSelectedItem(this.repo);
            }
            ProductLibraryToolView.this.UpdateUI();
            ProductLibraryToolView.this.notifyNewMapSelectionAvailable();
        }
    }

    public class ProductLibraryActionExtListener
    implements ProductLibraryActionExt.ActionExtListener {
        @Override
        public void notifyMSG(ProductLibraryActionExt action, ProductLibraryActionExt.ActionExtListener.MSG msg) {
            SystemUtils.LOG.info("ProductLibraryTool: got notification MSG " + msg.name() + " " + action.getNewRepoFolder().getName());
            switch (msg) {
                case NEW_REPO: {
                    DBScanner.Options options = new DBScanner.Options(false, false, false);
                    ProductLibraryToolView.this.addRepository(action.getNewRepoFolder(), options);
                    break;
                }
            }
        }
    }
}

