/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.rcp.toolviews;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.MetadataElement;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.datamodel.AbstractMetadata;
import org.esa.snap.engine_utilities.db.DBQuery;
import org.esa.snap.engine_utilities.db.MetadataTable;
import org.esa.snap.engine_utilities.db.ProductEntry;
import org.esa.snap.engine_utilities.db.ProductQueryInterface;
import org.esa.snap.engine_utilities.db.SQLUtils;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.productlibrary.rcp.toolviews.model.repositories.FolderRepository;
import org.esa.snap.productlibrary.rcp.toolviews.model.repositories.RepositoryInterface;
import org.esa.snap.rcp.util.Dialogs;
import org.jdesktop.swingx.JXDatePicker;

public final class DatabasePane
extends JPanel {
    private final JTextField nameField = new JTextField();
    private final JList<String> missionJList = new JList();
    private final JList<String> productTypeJList = new JList();
    private final JComboBox<String> acquisitionModeCombo = new JComboBox<String>(new String[]{"All_Modes"});
    private final JComboBox<String> passCombo = new JComboBox<String>(new String[]{"All_Passes", "ASCENDING", "DESCENDING"});
    private final JTextField trackField = new JTextField();
    private final JXDatePicker startDateBox = new JXDatePicker();
    private final JXDatePicker endDateBox = new JXDatePicker();
    private final JComboBox<String> polarizationCombo = new JComboBox<String>(new String[]{"Any", "Quad-Pol", "Dual-Pol", "HH+VV", "HH+HV", "VV+VH", "HH", "VV", "HV", "VH"});
    private final JComboBox<String> calibrationCombo = new JComboBox<String>(new String[]{"Any", "Calibrated", "Not_Calibrated"});
    private final JComboBox<String> orbitCorrectionCombo = new JComboBox<String>(new String[]{"Any", "Preliminary", "Precise", "Verified"});
    private final JTextField cloudCoverField = new JTextField();
    private final JComboBox<String> metadataNameCombo = new JComboBox();
    private final JTextField metdataValueField = new JTextField();
    private final JTextArea metadataArea = new JTextArea();
    private final JButton addMetadataButton = new JButton("+");
    private final JTextArea productText = new JTextArea();
    private final JRadioButton bboxInsideButton = new JRadioButton("Inside", true);
    private final JRadioButton bboxIntersectButton = new JRadioButton("Intersect", false);
    private RepositoryInterface repository;
    private ProductQueryInterface productQueryInterface;
    private DBQuery dbQuery = new DBQuery();
    private boolean modifyingCombos = false;
    private static final double MB = 1048576.0;
    private static final double GB = 1024.0;
    private static final double TB = 1048576.0;
    private final DecimalFormat df = new DecimalFormat("#.00");
    private final List<DatabaseQueryListener> listenerList = new ArrayList<DatabaseQueryListener>(1);

    public DatabasePane() {
        try {
            this.missionJList.setFixedCellWidth(100);
            this.createPanel();
            this.missionJList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent event) {
                    if (DatabasePane.this.modifyingCombos || event.getValueIsAdjusting()) {
                        return;
                    }
                    DatabasePane.this.updateMissionFields();
                    DatabasePane.this.partialQuery();
                }
            });
            this.productTypeJList.setFixedCellWidth(100);
            this.productTypeJList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent event) {
                    if (DatabasePane.this.modifyingCombos || event.getValueIsAdjusting()) {
                        return;
                    }
                    DatabasePane.this.partialQuery();
                }
            });
            this.addComboListener(this.acquisitionModeCombo);
            this.addComboListener(this.passCombo);
            this.addComboListener(this.polarizationCombo);
            this.addComboListener(this.calibrationCombo);
            this.addComboListener(this.orbitCorrectionCombo);
            this.addMetadataButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DatabasePane.this.addMetadataText();
                }
            });
            this.bboxInsideButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DatabasePane.this.dbQuery.insideSelectionRectangle(DatabasePane.this.bboxInsideButton.isSelected());
                    DatabasePane.this.partialQuery();
                }
            });
            this.bboxIntersectButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DatabasePane.this.dbQuery.insideSelectionRectangle(DatabasePane.this.bboxInsideButton.isSelected());
                    DatabasePane.this.partialQuery();
                }
            });
        }
        catch (Throwable t) {
            DatabasePane.handleException(t);
        }
    }

    private void addComboListener(JComboBox<String> combo) {
        combo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                if (DatabasePane.this.modifyingCombos || event.getStateChange() == 2) {
                    return;
                }
                DatabasePane.this.partialQuery();
            }
        });
    }

    public void addListener(DatabaseQueryListener listener) {
        if (!this.listenerList.contains(listener)) {
            this.listenerList.add(listener);
        }
    }

    public void removeListener(DatabaseQueryListener listener) {
        this.listenerList.remove(listener);
    }

    private void notifyQuery() {
        for (DatabaseQueryListener listener : this.listenerList) {
            listener.notifyNewEntryListAvailable();
        }
    }

    private static void handleException(Throwable t) {
        SystemUtils.LOG.severe(t.getMessage());
        Dialogs.showError((String)t.getMessage());
    }

    private void createPanel() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.add((Component)new JLabel("Mission:"), gbc);
        gbc.gridx = 1;
        this.add((Component)new JLabel("Product Type:"), gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        this.add((Component)new JScrollPane(this.missionJList), gbc);
        gbc.gridx = 1;
        this.add((Component)new JScrollPane(this.productTypeJList), gbc);
        ++gbc.gridy;
        JLabel label = DialogUtils.addComponent((JPanel)this, (GridBagConstraints)gbc, (String)"Product Name:", (JComponent)this.nameField);
        label.setHorizontalAlignment(4);
        ++gbc.gridy;
        label = DialogUtils.addComponent((JPanel)this, (GridBagConstraints)gbc, (String)"Acquisition Mode:", this.acquisitionModeCombo);
        label.setHorizontalAlignment(4);
        ++gbc.gridy;
        label = DialogUtils.addComponent((JPanel)this, (GridBagConstraints)gbc, (String)"Pass:", this.passCombo);
        label.setHorizontalAlignment(4);
        ++gbc.gridy;
        label = DialogUtils.addComponent((JPanel)this, (GridBagConstraints)gbc, (String)"Track:", (JComponent)this.trackField);
        label.setHorizontalAlignment(4);
        ++gbc.gridy;
        label = DialogUtils.addComponent((JPanel)this, (GridBagConstraints)gbc, (String)"Start Date:", (JComponent)this.startDateBox);
        label.setHorizontalAlignment(4);
        ++gbc.gridy;
        label = DialogUtils.addComponent((JPanel)this, (GridBagConstraints)gbc, (String)"End Date:", (JComponent)this.endDateBox);
        label.setHorizontalAlignment(4);
        ++gbc.gridy;
        label = DialogUtils.addComponent((JPanel)this, (GridBagConstraints)gbc, (String)"Polarization:", this.polarizationCombo);
        label.setHorizontalAlignment(4);
        ++gbc.gridy;
        label = DialogUtils.addComponent((JPanel)this, (GridBagConstraints)gbc, (String)"Calibration:", this.calibrationCombo);
        label.setHorizontalAlignment(4);
        ++gbc.gridy;
        label = DialogUtils.addComponent((JPanel)this, (GridBagConstraints)gbc, (String)"Orbit Correction:", this.orbitCorrectionCombo);
        label.setHorizontalAlignment(4);
        ++gbc.gridy;
        label = DialogUtils.addComponent((JPanel)this, (GridBagConstraints)gbc, (String)"Cloud Cover %:", (JComponent)this.cloudCoverField);
        label.setHorizontalAlignment(4);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        this.add((Component)this.createFreeSearchPanel(), gbc);
        ++gbc.gridy;
        ButtonGroup group = new ButtonGroup();
        group.add(this.bboxInsideButton);
        group.add(this.bboxIntersectButton);
        JPanel radioPanel = new JPanel(new FlowLayout());
        radioPanel.add(this.bboxInsideButton);
        radioPanel.add(this.bboxIntersectButton);
        radioPanel.add(new JLabel(" selection rectangle"));
        this.add((Component)radioPanel, gbc);
        ++gbc.gridy;
        JPanel productDetailsPanel = new JPanel(new BorderLayout());
        productDetailsPanel.setBorder(BorderFactory.createTitledBorder("Product Details"));
        this.productText.setLineWrap(true);
        this.productText.setRows(4);
        this.productText.setBackground(this.getBackground());
        productDetailsPanel.add((Component)this.productText, "Center");
        this.add((Component)productDetailsPanel, gbc);
    }

    private JPanel createFreeSearchPanel() {
        String[] metadataNames;
        JPanel freeSearchPanel = new JPanel(new GridBagLayout());
        freeSearchPanel.setBorder(BorderFactory.createTitledBorder("Metadata SQL Query"));
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        freeSearchPanel.add(this.metadataNameCombo, gbc);
        this.metadataNameCombo.setPrototypeDisplayValue("123456789012");
        for (String name : metadataNames = MetadataTable.getAllMetadataNames()) {
            this.metadataNameCombo.insertItemAt(name, this.metadataNameCombo.getItemCount());
        }
        gbc.gridx = 1;
        freeSearchPanel.add((Component)this.metdataValueField, gbc);
        this.metdataValueField.setColumns(10);
        gbc.gridx = 2;
        freeSearchPanel.add((Component)this.addMetadataButton, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        freeSearchPanel.add((Component)this.metadataArea, gbc);
        this.metadataArea.setBorder(new LineBorder(Color.BLACK));
        this.metadataArea.setLineWrap(true);
        this.metadataArea.setRows(4);
        this.metadataArea.setToolTipText("Use AND,OR,NOT and =,<,>,<=,>-");
        gbc.gridx = 2;
        gbc.gridwidth = 1;
        gbc.fill = 2;
        DialogUtils.fillPanel((JPanel)freeSearchPanel, (GridBagConstraints)gbc);
        return freeSearchPanel;
    }

    public void partialQuery() {
        this.setData();
        try {
            if (this.productQueryInterface.partialQuery(this.dbQuery)) {
                this.notifyQuery();
            }
        }
        catch (Exception e) {
            DatabasePane.handleException(e);
        }
    }

    private boolean isClientError401(Exception e) {
        return e.getMessage().contains("CLIENT_ERROR") && e.getMessage().contains("401");
    }

    void fullQuery(ProgressMonitor pm) {
        this.setData();
        boolean numRetries = true;
        for (int i = 0; i < 2; ++i) {
            try {
                if (!this.productQueryInterface.fullQuery(this.dbQuery, pm)) break;
                this.notifyQuery();
                break;
            }
            catch (Exception e) {
                if (i >= 1 || !this.isClientError401(e)) {
                    if (this.isClientError401(e)) {
                        DatabasePane.handleException(new IOException(e.getMessage() + " (invalid credentials)"));
                        break;
                    }
                    DatabasePane.handleException(e);
                    break;
                }
                this.repository.resetCredentials();
                continue;
            }
        }
    }

    public ProductEntry[] getProductEntryList() {
        return this.productQueryInterface.getProductEntryList();
    }

    void refresh() {
        boolean origState = this.lockCombos(true);
        try {
            this.updateMissionCombo();
            this.updateMissionFields();
        }
        catch (Throwable t) {
            DatabasePane.handleException(t);
        }
        finally {
            this.lockCombos(origState);
        }
    }

    private boolean lockCombos(boolean flag) {
        boolean origState = this.modifyingCombos;
        this.modifyingCombos = flag;
        return origState;
    }

    private void updateMissionCombo() throws SQLException {
        this.missionJList.removeAll();
        this.missionJList.setListData((String[])SQLUtils.prependString((String)"All_Missions", (String[])this.productQueryInterface.getAllMissions()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMissionFields() {
        boolean origState = this.lockCombos(true);
        try {
            String[] selectedMissions = DatabasePane.toStringArray(this.missionJList.getSelectedValuesList());
            String[] missions = StringUtils.contains((String[])selectedMissions, (String)"All_Missions") ? null : selectedMissions;
            this.productTypeJList.removeAll();
            this.productTypeJList.setListData((String[])SQLUtils.prependString((String)"All_Types", (String[])this.productQueryInterface.getAllProductTypes(missions)));
            String[] modeItems = SQLUtils.prependString((String)"All_Modes", (String[])this.productQueryInterface.getAllAcquisitionModes(missions));
            this.acquisitionModeCombo.removeAllItems();
            for (String item : modeItems) {
                this.acquisitionModeCombo.addItem(item);
            }
            if (!this.isFolderRepository() && missions != null) {
                boolean isSAR = this.containsSARMission(missions);
                boolean isOptical = this.containsOpticalMission(missions);
                this.polarizationCombo.setEnabled(isSAR);
                if (!isSAR) {
                    this.polarizationCombo.setSelectedIndex(0);
                }
                this.cloudCoverField.setEnabled(isOptical);
                if (!isOptical) {
                    this.cloudCoverField.setText("");
                }
            } else {
                this.polarizationCombo.setEnabled(true);
                this.cloudCoverField.setEnabled(false);
                this.cloudCoverField.setText("");
            }
        }
        catch (Throwable t) {
            DatabasePane.handleException(t);
        }
        finally {
            this.lockCombos(origState);
        }
    }

    private boolean containsOpticalMission(String[] missions) {
        for (String mission : missions) {
            if (!mission.equalsIgnoreCase("Sentinel-2") && !mission.equalsIgnoreCase("Sentinel-3")) continue;
            return true;
        }
        return false;
    }

    private boolean containsSARMission(String[] missions) {
        for (String mission : missions) {
            if (!mission.equalsIgnoreCase("Sentinel-1")) continue;
            return true;
        }
        return false;
    }

    private static String[] toStringArray(List<String> list) {
        return list.toArray(new String[list.size()]);
    }

    private boolean isFolderRepository() {
        return this.repository == null || this.repository instanceof FolderRepository;
    }

    public void setRepository(RepositoryInterface repo) {
        this.repository = repo;
        this.productQueryInterface = this.repository.getProductQueryInterface();
        boolean isFolderRepo = this.isFolderRepository();
        this.enableComponents(isFolderRepo);
        if (isFolderRepo) {
            this.setBaseDir(((FolderRepository)repo).getBaseDir());
        } else {
            this.setBaseDir(null);
        }
        this.missionJList.setSelectedIndex(0);
        this.refresh();
    }

    private void enableComponents(boolean isFolderRepo) {
        this.calibrationCombo.setEnabled(isFolderRepo);
        this.orbitCorrectionCombo.setEnabled(isFolderRepo);
        this.cloudCoverField.setEnabled(!isFolderRepo);
        this.metadataNameCombo.setEnabled(isFolderRepo);
        this.metdataValueField.setEnabled(isFolderRepo);
        this.metadataArea.setEnabled(isFolderRepo);
        this.addMetadataButton.setEnabled(isFolderRepo);
    }

    private void setBaseDir(File dir) {
        this.dbQuery.setBaseDir(dir);
        this.partialQuery();
    }

    private void addMetadataText() {
        String name = (String)this.metadataNameCombo.getSelectedItem();
        String value = this.metdataValueField.getText();
        if (!name.isEmpty() && !value.isEmpty()) {
            if (!this.metadataArea.getText().isEmpty()) {
                this.metadataArea.append(" AND ");
            }
            if (value.matches("-?\\d+(\\.\\d+)?")) {
                this.metadataArea.append(name + '=' + value + ' ');
            } else {
                this.metadataArea.append(name + "='" + value + "' ");
            }
        }
    }

    private static Calendar getDate(JXDatePicker dateField) {
        Date date = dateField.getDate();
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    private void setData() {
        this.dbQuery.setSelectedMissions(DatabasePane.toStringArray(this.missionJList.getSelectedValuesList()));
        this.dbQuery.setSelectedProductTypes(DatabasePane.toStringArray(this.productTypeJList.getSelectedValuesList()));
        this.dbQuery.setSelectedName(this.nameField.getText());
        this.dbQuery.setSelectedAcquisitionMode((String)this.acquisitionModeCombo.getSelectedItem());
        this.dbQuery.setSelectedPass((String)this.passCombo.getSelectedItem());
        this.dbQuery.setSelectedTrack(this.trackField.getText());
        this.dbQuery.setSelectedCloudCover(this.cloudCoverField.getText());
        this.dbQuery.setStartEndDate(DatabasePane.getDate(this.startDateBox), DatabasePane.getDate(this.endDateBox));
        this.dbQuery.setSelectedPolarization((String)this.polarizationCombo.getSelectedItem());
        this.dbQuery.setSelectedCalibration((String)this.calibrationCombo.getSelectedItem());
        this.dbQuery.setSelectedOrbitCorrection((String)this.orbitCorrectionCombo.getSelectedItem());
        this.dbQuery.clearMetadataQuery();
        this.dbQuery.setFreeQuery(this.metadataArea.getText());
    }

    void setSelectionRect(GeoPos[] selectionBox) {
        this.dbQuery.setSelectionRect(selectionBox);
        this.dbQuery.setReturnAllIfNoIntersection(true);
        this.dbQuery.insideSelectionRectangle(this.bboxInsideButton.isSelected());
        this.partialQuery();
    }

    public DBQuery getDBQuery() {
        this.setData();
        return this.dbQuery;
    }

    void findSlices(int dataTakeId) {
        this.metadataArea.setText("data_take_id=" + dataTakeId);
        this.dbQuery.setSelectionRect(null);
        this.partialQuery();
        this.metadataArea.setText("");
    }

    public void setDBQuery(DBQuery query) throws Exception {
        if (query == null) {
            return;
        }
        this.dbQuery = query;
        boolean origState = this.lockCombos(true);
        try {
            this.missionJList.setSelectedIndices(DatabasePane.findIndices(this.missionJList, this.dbQuery.getSelectedMissions()));
            this.updateMissionFields();
            this.productTypeJList.setSelectedIndices(DatabasePane.findIndices(this.productTypeJList, this.dbQuery.getSelectedProductTypes()));
            this.acquisitionModeCombo.setSelectedItem(this.dbQuery.getSelectedAcquisitionMode());
            this.passCombo.setSelectedItem(this.dbQuery.getSelectedPass());
            if (this.dbQuery.getStartDate() != null) {
                this.startDateBox.setDate(this.dbQuery.getStartDate().getTime());
            }
            if (this.dbQuery.getEndDate() != null) {
                this.endDateBox.setDate(this.dbQuery.getEndDate().getTime());
            }
            this.polarizationCombo.setSelectedItem(this.dbQuery.getSelectedPolarization());
            this.calibrationCombo.setSelectedItem(this.dbQuery.getSelectedCalibration());
            this.orbitCorrectionCombo.setSelectedItem(this.dbQuery.getSelectedOrbitCorrection());
            this.metadataArea.setText(this.dbQuery.getFreeQuery());
        }
        finally {
            this.lockCombos(origState);
        }
    }

    private static int[] findIndices(JList<String> list, String[] values) {
        int size = list.getModel().getSize();
        ArrayList<Integer> indices = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            String str = list.getModel().getElementAt(i);
            if (!StringUtils.contains((String[])values, (String)str)) continue;
            indices.add(i);
        }
        int[] intIndices = new int[indices.size()];
        for (int i = 0; i < indices.size(); ++i) {
            intIndices[i] = (Integer)indices.get(i);
        }
        return intIndices;
    }

    void updateProductSelectionText(ProductEntry[] selections) {
        if (selections != null && selections.length == 1) {
            ProductEntry entry = selections[0];
            StringBuilder text = new StringBuilder(255);
            File file = entry.getFile();
            if (file != null) {
                text.append("File: " + file.getName() + '\n');
            }
            text.append("Product: " + entry.getName() + '\n');
            text.append('\n');
            text.append("Mission: " + entry.getMission() + '\n');
            text.append("Mode: " + entry.getAcquisitionMode() + '\n');
            text.append("Type: " + entry.getProductType() + '\n');
            MetadataElement absRoot = entry.getMetadata();
            if (absRoot != null) {
                String sampleType = absRoot.getAttributeString("SAMPLE_TYPE", "-");
                ProductData.UTC acqTime = absRoot.getAttributeUTC("first_line_time", AbstractMetadata.NO_METADATA_UTC);
                String pass = absRoot.getAttributeString("PASS", "-");
                int absOrbit = absRoot.getAttributeInt("ABS_ORBIT", 99999);
                int relOrbit = absRoot.getAttributeInt("REL_ORBIT", 99999);
                String map = absRoot.getAttributeString("map_projection", "-").trim();
                int cal = absRoot.getAttributeInt("abs_calibration_flag", 99999);
                int tc = absRoot.getAttributeInt("is_terrain_corrected", 99999);
                int ml = absRoot.getAttributeInt("multilook_flag", 99999);
                int coreg = absRoot.getAttributeInt("coregistered_stack", 99999);
                text.append("Date: " + acqTime.format() + '\n');
                text.append("Sample: " + sampleType + '\n');
                text.append("Pass: " + pass + '\n');
                text.append("Orbit: " + absOrbit);
                if (relOrbit != 99999) {
                    text.append("  Track: " + relOrbit);
                }
                text.append('\n');
                text.append("Size: " + this.getSizeString(entry.getFileSize()) + '\n');
                if (!map.isEmpty()) {
                    text.append(map + '\n');
                }
                if (cal == 1) {
                    text.append("Calibrated ");
                }
                if (ml == 1) {
                    text.append("Multilooked ");
                }
                if (coreg == 1) {
                    text.append("Coregistered ");
                }
                if (tc == 1) {
                    text.append("Terrain Corrected ");
                }
            } else {
                text.append("Date: " + entry.getFirstLineTime() + '\n');
                text.append("Size: " + entry.getFileSizeString() + '\n');
            }
            this.productText.setText(text.toString());
        } else if (selections != null && selections.length > 1) {
            long totalSize = 0L;
            for (ProductEntry entry : selections) {
                totalSize += entry.getFileSize();
            }
            String text = selections.length + " products\n" + "Total: " + this.getSizeString(totalSize);
            this.productText.setText(text);
        } else {
            this.productText.setText("");
        }
    }

    private String getSizeString(long bytes) {
        String unit;
        double value;
        double mb = (double)bytes / 1048576.0;
        if (mb > 1048576.0) {
            value = mb / 1048576.0;
            unit = "TB";
        } else if (mb > 1024.0) {
            value = mb / 1024.0;
            unit = "GB";
        } else {
            value = mb;
            unit = "MB";
        }
        return this.df.format(value) + ' ' + unit;
    }

    public static interface DatabaseQueryListener {
        public void notifyNewEntryListAvailable();
    }
}

