/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.rcp.toolviews.AOIMonitoring.model;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.esa.snap.productlibrary.rcp.toolviews.AOIMonitoring.model.AOITableModel;
import org.esa.snap.productlibrary.rcp.toolviews.AOIMonitoring.model.dataprovider.DataProvider;

public class AOISortingDecorator
extends AbstractTableModel {
    private static final int DESCENDING = -1;
    private static final int NOT_SORTED = 0;
    private static final Directive EMPTY_DIRECTIVE = new Directive(-1, 0);
    private final AOITableModel _tableModel;
    private final JTableHeader _tableHeader;
    private final List<Directive> sortingColumns = new ArrayList<Directive>();
    private final Map columnComparators = new HashMap();
    private Row[] viewToModel = null;
    private static final Comparator COMPARABLE_COMAPRATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return ((Comparable)o1).compareTo(o2);
        }
    };
    private static final Comparator LEXICAL_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return o1.toString().compareTo(o2.toString());
        }
    };

    public AOISortingDecorator(AOITableModel tableModel, JTableHeader tableHeader) {
        this._tableModel = tableModel;
        this._tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                AOISortingDecorator.this.initViewToModel();
                AOISortingDecorator.this.fireTableChanged(e);
            }
        });
        this._tableHeader = tableHeader;
        this._tableHeader.addMouseListener(new MouseHandler());
        this._tableHeader.setDefaultRenderer(new SortableHeaderRenderer(this._tableHeader.getDefaultRenderer()));
    }

    @Override
    public int getRowCount() {
        return this._tableModel.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this._tableModel.getColumnCount();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this._tableModel.getValueAt(this.getSortedIndex(rowIndex), columnIndex);
    }

    @Override
    public String getColumnName(int column) {
        return this._tableModel.getColumnName(column);
    }

    public Class getColumnClass(int column) {
        return this._tableModel.getColumnClass(column);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this._tableModel.isCellEditable(this.getSortedIndex(row), column);
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        this._tableModel.setValueAt(aValue, this.getSortedIndex(row), column);
    }

    public int getSortedIndex(int rowIndex) {
        Row[] view = this.getViewToModel();
        if (rowIndex < view.length) {
            return view[rowIndex].modelIndex;
        }
        if (view.length > 0) {
            return view[0].modelIndex;
        }
        return 0;
    }

    private Row[] getViewToModel() {
        if (this.viewToModel == null) {
            this.initViewToModel();
        }
        return this.viewToModel;
    }

    private void initViewToModel() {
        int tableModelRowCount = this._tableModel.getRowCount();
        this.viewToModel = new Row[tableModelRowCount];
        for (int row = 0; row < tableModelRowCount; ++row) {
            this.viewToModel[row] = new Row(row);
        }
        if (this.isSorting()) {
            Arrays.sort(this.getViewToModel());
        }
    }

    private boolean isSorting() {
        return !this.sortingColumns.isEmpty();
    }

    private void setDirectionForColumn(int column, int direction) {
        Directive directive = this.getDirective(column);
        if (directive != EMPTY_DIRECTIVE) {
            this.sortingColumns.remove(directive);
        }
        if (direction != 0) {
            this.sortingColumns.add(new Directive(column, direction));
        }
    }

    private Icon getHeaderRendererIcon(int column, int size) {
        Directive directive = this.getDirective(column);
        if (directive == EMPTY_DIRECTIVE) {
            return null;
        }
        return new Arrow(directive.direction == -1, size, this.sortingColumns.indexOf(directive));
    }

    private int getSortingDirection(int column) {
        return this.getDirective(column).direction;
    }

    private void clearSortingDirections() {
        this.sortingColumns.clear();
    }

    private Directive getDirective(int column) {
        for (Directive sortingColumn : this.sortingColumns) {
            Directive directive = sortingColumn;
            if (directive.column != column) continue;
            return directive;
        }
        return EMPTY_DIRECTIVE;
    }

    private Comparator getComparator(int column) {
        DataProvider dataProvider = this._tableModel.getDataProvider(column);
        Class<?> columnType = this._tableModel.getColumnClass(column);
        Comparator comparator = dataProvider.getComparator();
        if (comparator == null) {
            comparator = Comparable.class.isAssignableFrom(columnType) ? COMPARABLE_COMAPRATOR : LEXICAL_COMPARATOR;
            this.columnComparators.put(columnType, comparator);
        }
        return comparator;
    }

    private class Row
    implements Comparable {
        private final int modelIndex;

        public Row(int index) {
            this.modelIndex = index;
        }

        public int compareTo(Object o) {
            int idxRow1 = this.modelIndex;
            int idxRow2 = ((Row)o).modelIndex;
            for (Object sortingColumn : AOISortingDecorator.this.sortingColumns) {
                Directive directive = (Directive)sortingColumn;
                int column = directive.column;
                Object o1 = AOISortingDecorator.this._tableModel.getValueAt(idxRow1, column);
                Object o2 = AOISortingDecorator.this._tableModel.getValueAt(idxRow2, column);
                int comparison = AOISortingDecorator.this.getComparator(column).compare(o1, o2);
                if (comparison == 0) continue;
                return directive.direction == -1 ? -comparison : comparison;
            }
            return 0;
        }
    }

    private static class Arrow
    implements Icon {
        private final boolean descending;
        private final int size;
        private final int priority;

        public Arrow(boolean descending, int size, int priority) {
            this.descending = descending;
            this.size = size;
            this.priority = priority;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color color = c == null ? Color.GRAY : c.getBackground();
            int dx = (int)((double)(this.size / 2) * Math.pow(0.8, this.priority));
            int dy = this.descending ? dx : -dx;
            y = y + 5 * this.size / 6 + (this.descending ? -dy : 0);
            int shift = this.descending ? 1 : -1;
            g.translate(x, y);
            g.setColor(color.darker());
            g.drawLine(dx / 2, dy, 0, 0);
            g.drawLine(dx / 2, dy + shift, 0, shift);
            g.setColor(color.brighter());
            g.drawLine(dx / 2, dy, dx, 0);
            g.drawLine(dx / 2, dy + shift, dx, shift);
            if (this.descending) {
                g.setColor(color.darker().darker());
            } else {
                g.setColor(color.brighter().brighter());
            }
            g.drawLine(dx, 0, 0, 0);
            g.setColor(color);
            g.translate(-x, -y);
        }

        @Override
        public int getIconWidth() {
            return this.size;
        }

        @Override
        public int getIconHeight() {
            return this.size;
        }
    }

    private static class Directive {
        private final int column;
        private final int direction;

        public Directive(int column, int direction) {
            this.column = column;
            this.direction = direction;
        }
    }

    private class SortableHeaderRenderer
    implements TableCellRenderer {
        private final TableCellRenderer tableCellRenderer;

        public SortableHeaderRenderer(TableCellRenderer tableCellRenderer) {
            this.tableCellRenderer = tableCellRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = this.tableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (c instanceof JLabel) {
                JLabel l = (JLabel)c;
                l.setHorizontalTextPosition(2);
                int modelColumn = table.convertColumnIndexToModel(column);
                l.setIcon(AOISortingDecorator.this.getHeaderRendererIcon(modelColumn, (int)((double)l.getFont().getSize() * 1.6)));
            }
            return c;
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        private MouseHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int viewColumnIndex;
            JTableHeader h = (JTableHeader)e.getSource();
            TableColumnModel columnModel = h.getColumnModel();
            int columnIndex = columnModel.getColumn(viewColumnIndex = columnModel.getColumnIndexAtX(e.getX())).getModelIndex();
            if (columnIndex != -1) {
                int direction = AOISortingDecorator.this.getSortingDirection(columnIndex);
                if (!e.isControlDown()) {
                    AOISortingDecorator.this.clearSortingDirections();
                    AOISortingDecorator.this._tableHeader.repaint();
                }
                direction += e.isShiftDown() ? -1 : 1;
                direction = (direction + 4) % 3 - 1;
                AOISortingDecorator.this.setDirectionForColumn(columnIndex, direction);
                AOISortingDecorator.this.initViewToModel();
                AOISortingDecorator.this.fireTableDataChanged();
            }
        }
    }
}

