/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.rcp.toolviews.AOIMonitoring.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.dataop.downloadable.XMLSupport;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.engine_utilities.db.DBQuery;
import org.esa.snap.engine_utilities.db.GeoPosList;
import org.esa.snap.productlibrary.rcp.toolviews.AOIMonitoring.model.AOIManager;
import org.esa.snap.rcp.SnapApp;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;

public class AOI
implements GeoPosList {
    public static final String EXT = ".xml";
    private final File aoiFile;
    private String name = "aoi";
    private String inputFolder = "";
    private String outputFolder = "";
    private String processingGraph = "";
    private String lastProcessed = "";
    private boolean findSlaves = false;
    private int maxSlaves = 1;
    private GeoPos[] aoiPoints = new GeoPos[0];
    private DBQuery slaveDBQuery = null;

    public AOI(File file) {
        this.aoiFile = file;
        if (!this.aoiFile.exists() || !this.load(this.aoiFile)) {
            this.name = FileUtils.getFilenameWithoutExtension((File)file);
            this.inputFolder = AOIManager.getLastInputPath();
            this.outputFolder = AOIManager.getLastOutputPath();
            this.processingGraph = null;
        }
    }

    public File getFile() {
        return this.aoiFile;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.name = n;
    }

    public String getInputFolder() {
        return this.inputFolder;
    }

    public void setInputFolder(String file) {
        this.inputFolder = file;
    }

    public String getOutputFolder() {
        return this.outputFolder;
    }

    public void setOutputFolder(String file) {
        this.outputFolder = file;
    }

    public String getProcessingGraph() {
        return this.processingGraph;
    }

    public void setProcessingGraph(String file) {
        this.processingGraph = file;
    }

    public boolean getFindSlaves() {
        return this.findSlaves;
    }

    public void setFindSlaves(boolean flag) {
        this.findSlaves = flag;
    }

    public void setMaxSlaves(int max) {
        this.maxSlaves = max;
    }

    public int getMaxSlaves() {
        return this.maxSlaves;
    }

    public void setPoints(GeoPos[] selectionBox) {
        this.aoiPoints = selectionBox;
    }

    public GeoPos[] getPoints() {
        return this.aoiPoints;
    }

    public void setSlaveDBQuery(DBQuery query) {
        this.slaveDBQuery = query;
    }

    public DBQuery getSlaveDBQuery() {
        return this.slaveDBQuery;
    }

    public String getLastProcessed() {
        return this.lastProcessed;
    }

    public void setLastProcessed(String date) {
        this.lastProcessed = date;
    }

    public void save() {
        Element root = new Element("AOI");
        root.setAttribute("name", this.name);
        Document doc = new Document(root);
        Element elem = new Element("param");
        elem.setAttribute("inputFolder", this.inputFolder);
        elem.setAttribute("outputFolder", this.outputFolder);
        elem.setAttribute("graph", this.processingGraph);
        elem.setAttribute("lastProcessed", this.lastProcessed);
        elem.setAttribute("findSlaves", String.valueOf(this.findSlaves));
        elem.setAttribute("maxSlaves", String.valueOf(this.maxSlaves));
        root.addContent((Content)elem);
        Element pntsElem = new Element("points");
        for (GeoPos pnt : this.aoiPoints) {
            Element pntElem = new Element("point");
            pntElem.setAttribute("lat", String.valueOf(pnt.getLat()));
            pntElem.setAttribute("lon", String.valueOf(pnt.getLon()));
            pntsElem.addContent((Content)pntElem);
        }
        root.addContent((Content)pntsElem);
        if (this.slaveDBQuery != null) {
            // empty if block
        }
        try {
            XMLSupport.SaveXML((Document)doc, (String)this.aoiFile.getAbsolutePath());
        }
        catch (IOException e) {
            SystemUtils.LOG.severe("Unable to save AOI " + e.getMessage());
        }
    }

    private boolean load(File file) {
        try {
            Document doc = XMLSupport.LoadXML((String)file.getAbsolutePath());
            Element root = doc.getRootElement();
            Attribute nameAttrib = root.getAttribute("name");
            if (nameAttrib != null) {
                this.name = nameAttrib.getValue();
            }
            ArrayList<GeoPos> geoPosList = new ArrayList<GeoPos>();
            List children = root.getContent();
            for (Object aChild : children) {
                if (!(aChild instanceof Element)) continue;
                Element child = (Element)aChild;
                if (child.getName().equals("param")) {
                    Attribute maxSlavesAttrib;
                    this.inputFolder = XMLSupport.getAttrib((Element)child, (String)"inputFolder");
                    this.outputFolder = XMLSupport.getAttrib((Element)child, (String)"outputFolder");
                    this.processingGraph = XMLSupport.getAttrib((Element)child, (String)"graph");
                    this.lastProcessed = XMLSupport.getAttrib((Element)child, (String)"lastProcessed");
                    Attribute findSlavesAttrib = child.getAttribute("findSlaves");
                    if (findSlavesAttrib != null) {
                        this.findSlaves = Boolean.parseBoolean(findSlavesAttrib.getValue());
                    }
                    if ((maxSlavesAttrib = child.getAttribute("maxSlaves")) == null) continue;
                    this.maxSlaves = Integer.parseInt(maxSlavesAttrib.getValue());
                    continue;
                }
                if (child.getName().equals("points")) {
                    List pntsList = child.getContent();
                    for (Object o : pntsList) {
                        if (!(o instanceof Element)) continue;
                        Element pntElem = (Element)o;
                        String latStr = XMLSupport.getAttrib((Element)pntElem, (String)"lat");
                        String lonStr = XMLSupport.getAttrib((Element)pntElem, (String)"lon");
                        if (latStr.isEmpty() || lonStr.isEmpty()) continue;
                        float lat = Float.parseFloat(latStr);
                        float lon = Float.parseFloat(lonStr);
                        geoPosList.add(new GeoPos((double)lat, (double)lon));
                    }
                    continue;
                }
                if (!child.getName().equals("dbQuery")) continue;
                this.slaveDBQuery = new DBQuery();
            }
            this.aoiPoints = geoPosList.toArray(new GeoPos[geoPosList.size()]);
        }
        catch (IOException e) {
            SnapApp.getDefault().handleError("Unable to load AOI", (Throwable)e);
            return false;
        }
        return true;
    }
}

