/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.rcp.toolviews.AOIMonitoring;

import com.bc.ceres.core.ProgressMonitor;
import com.jidesoft.swing.JideSplitPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.filechooser.FileFilter;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.engine_utilities.db.ProductDB;
import org.esa.snap.graphbuilder.gpf.ui.worldmap.WorldMapUI;
import org.esa.snap.graphbuilder.rcp.dialogs.BatchGraphDialog;
import org.esa.snap.graphbuilder.rcp.progress.LabelBarProgressMonitor;
import org.esa.snap.productlibrary.rcp.toolviews.AOIMonitoring.AOIDialog;
import org.esa.snap.productlibrary.rcp.toolviews.AOIMonitoring.AOIMonitor;
import org.esa.snap.productlibrary.rcp.toolviews.AOIMonitoring.DatabaseScannerListener;
import org.esa.snap.productlibrary.rcp.toolviews.AOIMonitoring.model.AOI;
import org.esa.snap.productlibrary.rcp.toolviews.AOIMonitoring.model.AOIManager;
import org.esa.snap.productlibrary.rcp.toolviews.AOIMonitoring.model.AOISortingDecorator;
import org.esa.snap.productlibrary.rcp.toolviews.AOIMonitoring.model.AOITableModel;
import org.esa.snap.productlibrary.rcp.toolviews.DBScanner;
import org.esa.snap.productlibrary.rcp.toolviews.model.ProductLibraryConfig;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.rcp.windows.ToolTopComponent;
import org.esa.snap.tango.TangoIcons;
import org.esa.snap.ui.UIUtils;
import org.esa.snap.ui.tool.ToolButtonFactory;
import org.openide.util.HelpCtx;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="AOIMonitoringTopComponent", iconBase="org/esa/snap/productlibrary/icons/aoi.png", persistenceType=0)
public class AOIMonitoringToolView
extends ToolTopComponent {
    private static ImageIcon processIcon;
    private static ImageIcon processRolloverIcon;
    private static ImageIcon stopIcon;
    private static ImageIcon stopRolloverIcon;
    private static ImageIcon monitorStartIcon;
    private static ImageIcon monitorStartRolloverIcon;
    private static ImageIcon monitorStopIcon;
    private static ImageIcon monitorStopRolloverIcon;
    private static ImageIcon clearIcon;
    private static ImageIcon helpIcon;
    private static final SnapFileFilter aoiFileFilter;
    private JTable aoiTable;
    private JLabel statusLabel;
    private JPanel mainPanel;
    private JPanel progressPanel;
    private JButton newButton;
    private JButton addButton;
    private JButton removeButton;
    private JButton processButton;
    private JButton monitorButton;
    private JButton clearButton;
    private JButton helpButton;
    private LabelBarProgressMonitor progMon;
    private JProgressBar progressBar;
    private final ProductLibraryConfig libConfig = new ProductLibraryConfig(SnapApp.getDefault().getPreferences());
    private static final String helpId = "AOIMonitoring";
    private WorldMapUI worldMapUI;
    private final AOIManager aoiManager = new AOIManager();
    private ProductDB db;
    private AOI processingAOI;
    private final AOIMonitor aoiMonitor = new AOIMonitor(this);

    public AOIMonitoringToolView() {
        this.setLayout(new BorderLayout(4, 4));
        this.setBorder(new EmptyBorder(4, 4, 4, 4));
        this.setDisplayName("AOI Monitoring");
        this.add(this.createControls(), "Center");
    }

    private JComponent createControls() {
        AOIMonitoringToolView.loadIcons();
        this.initUI();
        this.mainPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                if (AOIMonitoringToolView.this.progMon != null) {
                    AOIMonitoringToolView.this.progMon.setCanceled(true);
                }
            }
        });
        this.applyConfig();
        return this.mainPanel;
    }

    private static void loadIcons() {
        processIcon = UIUtils.loadImageIcon((String)"icons/Play24.png");
        processRolloverIcon = ToolButtonFactory.createRolloverIcon((ImageIcon)processIcon);
        stopIcon = UIUtils.loadImageIcon((String)"icons/Stop24.gif");
        stopRolloverIcon = ToolButtonFactory.createRolloverIcon((ImageIcon)stopIcon);
        monitorStartIcon = UIUtils.loadImageIcon((String)"/org/esa/snap/productlibrary/icons/run24.png", AOIMonitoringToolView.class);
        monitorStartRolloverIcon = ToolButtonFactory.createRolloverIcon((ImageIcon)monitorStartIcon);
        monitorStopIcon = UIUtils.loadImageIcon((String)"/org/esa/snap/productlibrary/icons/run-red24.png", AOIMonitoringToolView.class);
        monitorStopRolloverIcon = ToolButtonFactory.createRolloverIcon((ImageIcon)monitorStopIcon);
        clearIcon = TangoIcons.actions_edit_clear((TangoIcons.Res)TangoIcons.Res.R22);
        helpIcon = TangoIcons.apps_help_browser((TangoIcons.Res)TangoIcons.Res.R22);
    }

    private void initUI() {
        JPanel eastPanel = new JPanel(new BorderLayout(4, 4));
        eastPanel.add((Component)this.createHeaderPanel(), "North");
        JPanel southPanel = new JPanel(new BorderLayout(4, 4));
        JPanel openPanel = new JPanel(new BorderLayout(4, 4));
        southPanel.add((Component)openPanel, "West");
        this.statusLabel = new JLabel("");
        southPanel.add((Component)this.statusLabel, "Center");
        this.progressBar = new JProgressBar();
        this.progressBar.setStringPainted(true);
        this.progressPanel = new JPanel();
        this.progressPanel.setLayout(new BorderLayout());
        this.progressPanel.add(this.progressBar);
        this.progressPanel.setVisible(false);
        southPanel.add((Component)this.progressPanel, "East");
        this.mainPanel = new JPanel(new BorderLayout(4, 4));
        this.mainPanel.add((Component)eastPanel, "East");
        this.mainPanel.add((Component)this.createCentrePanel(), "Center");
        this.mainPanel.add((Component)southPanel, "South");
        this.mainPanel.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
    }

    private JPanel createCentrePanel() {
        JideSplitPane splitPane1V = new JideSplitPane(0);
        this.aoiTable = new JTable();
        this.aoiTable.setAutoResizeMode(4);
        this.aoiTable.setSelectionMode(0);
        this.aoiTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int clickCount = e.getClickCount();
                if (clickCount == 2) {
                    AOIMonitoringToolView.this.performOpenAction();
                } else if (clickCount == 1) {
                    AOIMonitoringToolView.this.performSelectAction();
                }
            }
        });
        splitPane1V.add((Component)new JScrollPane(this.aoiTable));
        this.worldMapUI = new WorldMapUI();
        splitPane1V.add((Component)this.worldMapUI.getWorlMapPane());
        return splitPane1V;
    }

    private JPanel createHeaderPanel() {
        JPanel headerBar = new JPanel();
        headerBar.setLayout(new GridLayout(10, 1));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 3;
        gbc.anchor = 18;
        this.newButton = this.createToolButton("newButton", UIUtils.loadImageIcon((String)"icons/New24.gif"));
        this.newButton.setToolTipText("Create New AOI");
        this.newButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AOIMonitoringToolView.this.performNewAction();
            }
        });
        headerBar.add((Component)this.newButton, gbc);
        this.addButton = this.createToolButton("addButton", UIUtils.loadImageIcon((String)"icons/Plus24.gif"));
        this.addButton.setToolTipText("Add existing AOI");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AOIMonitoringToolView.this.addAOI();
            }
        });
        headerBar.add((Component)this.addButton, gbc);
        this.removeButton = this.createToolButton("removeButton", UIUtils.loadImageIcon((String)"icons/Minus24.gif"));
        this.removeButton.setToolTipText("Remove AOI");
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AOIMonitoringToolView.this.removeAOI();
            }
        });
        headerBar.add((Component)this.removeButton, gbc);
        this.clearButton = this.createToolButton("clearButton", clearIcon);
        this.clearButton.setToolTipText("Clear all AOIs");
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AOIMonitoringToolView.this.clearAll();
            }
        });
        headerBar.add((Component)this.clearButton, gbc);
        this.helpButton = this.createToolButton("helpButton", helpIcon);
        this.helpButton.setToolTipText("Show help");
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new HelpCtx(AOIMonitoringToolView.helpId).display();
            }
        });
        headerBar.add((Component)this.helpButton, gbc);
        this.processButton = this.createToolButton("processButton", processIcon);
        this.processButton.setToolTipText("Process selected AOI");
        this.processButton.setActionCommand("update");
        this.processButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("stop")) {
                    AOIMonitoringToolView.this.processButton.setEnabled(false);
                    AOIMonitoringToolView.this.mainPanel.setCursor(Cursor.getPredefinedCursor(3));
                    if (AOIMonitoringToolView.this.progMon != null) {
                        AOIMonitoringToolView.this.progMon.setCanceled(true);
                    }
                } else {
                    int row = AOIMonitoringToolView.this.aoiTable.getSelectedRow();
                    if (row >= 0) {
                        AOIMonitoringToolView.this.processingAOI = AOIMonitoringToolView.this.aoiManager.getAOIAt(row);
                        try {
                            AOIMonitoringToolView.this.processAOI(AOIMonitoringToolView.this.processingAOI, true);
                        }
                        catch (Exception ex) {
                            SnapApp.getDefault().handleError("AOI Error", (Throwable)ex);
                        }
                    }
                }
            }
        });
        headerBar.add((Component)this.processButton, gbc);
        this.monitorButton = this.createToolButton("monitorButton", monitorStartIcon);
        this.monitorButton.setToolTipText("Begin monitoring all AOI folders");
        this.monitorButton.setActionCommand("update");
        this.monitorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getActionCommand().equals("stop")) {
                    AOIMonitoringToolView.this.mainPanel.setCursor(Cursor.getDefaultCursor());
                    AOIMonitoringToolView.this.aoiMonitor.stop();
                    if (AOIMonitoringToolView.this.progMon != null) {
                        AOIMonitoringToolView.this.progMon.setCanceled(true);
                    }
                    AOIMonitoringToolView.this.toggleMonitorButton("update");
                } else {
                    AOIMonitoringToolView.this.aoiMonitor.start(AOIMonitoringToolView.this.aoiManager.getAOIList());
                    AOIMonitoringToolView.this.toggleMonitorButton("stop");
                }
            }
        });
        headerBar.add((Component)this.monitorButton, gbc);
        return headerBar;
    }

    private JButton createToolButton(String name, ImageIcon icon) {
        JButton button;
        if (icon == null) {
            button = new JButton(name);
        } else {
            button = (JButton)ToolButtonFactory.createButton((Icon)icon, (boolean)false);
            button.setName(((Object)((Object)this)).getClass().getName() + name);
        }
        return button;
    }

    private void applyConfig() {
        File[] baseDirList;
        AOIMonitoringToolView aOIMonitoringToolView = this;
        for (File file : baseDirList = aOIMonitoringToolView.aoiManager.getBaseDirs()) {
            if (file.exists()) {
                AOI aOI = this.aoiManager.createAOI(file);
                continue;
            }
            AOIManager.removeBaseDir(file);
        }
        this.UpdateUI();
    }

    private void UpdateUI() {
        this.ShowAOIs(this.aoiManager.getAOIList());
        boolean hasAOIs = this.aoiManager.getAOIList().length > 0;
        this.clearButton.setEnabled(hasAOIs);
        this.monitorButton.setEnabled(hasAOIs);
        AOI[] selectedAOIs = this.getSelectedAOIs();
        this.enableOnSelection(selectedAOIs.length > 0);
    }

    AOIManager getAoiManager() {
        return this.aoiManager;
    }

    ProductDB getProductDatabase() throws Exception {
        if (this.db == null) {
            this.db = ProductDB.instance();
        }
        return this.db;
    }

    private void enableOnSelection(boolean flag) {
        this.removeButton.setEnabled(flag);
        this.processButton.setEnabled(flag);
    }

    private void performSelectAction() {
        this.updateStatusLabel();
        AOI[] selectedAOIs = this.getSelectedAOIs();
        this.enableOnSelection(selectedAOIs.length > 0);
        GeoPos[][] geoBoundaries = new GeoPos[selectedAOIs.length][4];
        int i = 0;
        for (AOI aoi : selectedAOIs) {
            geoBoundaries[i++] = aoi.getPoints();
        }
        this.worldMapUI.setSelectedGeoBoundaries(geoBoundaries);
    }

    private void performNewAction() {
        try {
            File aoiFile = Dialogs.requestFileForSave((String)"New Area of Interest", (boolean)false, (FileFilter)aoiFileFilter, (String)".xml", (String)this.aoiManager.getNewAOIFile().getAbsolutePath(), null, (String)"snap.aoi.last_aoi_path");
            if (aoiFile != null) {
                AOI aoi = this.aoiManager.createAOI(aoiFile);
                AOIDialog dlg = new AOIDialog(SnapApp.getDefault().getMainFrame(), aoi);
                dlg.show();
                AOIManager.addBaseDir(aoi.getFile());
                this.UpdateUI();
            }
        }
        catch (Exception e) {
            Dialogs.showError((String)("Unable to create new AOI: " + e.getMessage()));
        }
    }

    private void performOpenAction() {
        try {
            int row = this.aoiTable.getSelectedRow();
            if (row >= 0) {
                AOI aoi = this.aoiManager.getAOIAt(row);
                AOIDialog dlg = new AOIDialog(SnapApp.getDefault().getMainFrame(), aoi);
                dlg.show();
                this.UpdateUI();
                this.performSelectAction();
            }
        }
        catch (Exception e) {
            Dialogs.showError((String)("Unable to open AOI: " + e.getMessage()));
        }
    }

    private AOI[] getSelectedAOIs() {
        int[] selectedRows = this.aoiTable.getSelectedRows();
        AOI[] selectedEntries = new AOI[selectedRows.length];
        for (int i = 0; i < selectedRows.length; ++i) {
            Object entry = this.aoiTable.getValueAt(selectedRows[i], 0);
            if (!(entry instanceof AOI)) continue;
            selectedEntries[i] = (AOI)entry;
        }
        return selectedEntries;
    }

    private void addAOI() {
        AOIMonitoringToolView aOIMonitoringToolView = this;
        File aoiFile = Dialogs.requestFileForSave((String)"Add Area of Interest", (boolean)false, (FileFilter)aoiFileFilter, (String)".xml", (String)aOIMonitoringToolView.aoiManager.getAOIFolder().getAbsolutePath(), null, (String)"snap.aoi.last_aoi_path");
        if (aoiFile != null) {
            this.aoiManager.createAOI(aoiFile);
            AOIManager.addBaseDir(aoiFile);
            this.UpdateUI();
        }
    }

    LabelBarProgressMonitor createNewProgressMonitor() {
        this.progMon = new LabelBarProgressMonitor(this.progressBar, this.statusLabel);
        this.progMon.addListener((LabelBarProgressMonitor.ProgressBarListener)new MyProgressBarListener());
        return this.progMon;
    }

    private void processAOI(AOI aoi, boolean doRecursive) throws Exception {
        this.progMon = this.createNewProgressMonitor();
        this.libConfig.addBaseDir(new File(aoi.getInputFolder()));
        DBScanner.Options options = new DBScanner.Options(doRecursive, false, false);
        DBScanner scanner = new DBScanner(this.getProductDatabase(), new File(aoi.getInputFolder()), options, (ProgressMonitor)this.progMon);
        scanner.addListener(new DatabaseScannerListener(this.getProductDatabase(), aoi, false, false, new MyBatchProcessListener(), this.aoiManager));
        scanner.execute();
    }

    private void removeAOI() {
        int row = this.aoiTable.getSelectedRow();
        if (row >= 0) {
            AOI aoi = this.aoiManager.getAOIAt(row);
            AOIManager.removeBaseDir(aoi.getFile());
            this.aoiManager.removeAOI(aoi);
            this.UpdateUI();
        }
    }

    private void clearAll() {
        AOI[] aoiList;
        for (AOI aoi : aoiList = this.aoiManager.getAOIList()) {
            AOIManager.removeBaseDir(aoi.getFile());
            this.aoiManager.removeAOI(aoi);
        }
        this.UpdateUI();
    }

    private void toggleProcessButton(String command) {
        if (command.equals("stop")) {
            this.processButton.setIcon(stopIcon);
            this.processButton.setRolloverIcon(stopRolloverIcon);
            this.processButton.setActionCommand("stop");
            this.processButton.setToolTipText("Stop processing");
            this.newButton.setEnabled(false);
            this.addButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.clearButton.setEnabled(false);
            this.monitorButton.setEnabled(false);
        } else {
            this.processButton.setIcon(processIcon);
            this.processButton.setRolloverIcon(processRolloverIcon);
            this.processButton.setActionCommand("update");
            this.processButton.setToolTipText("Process selected AOI");
            this.newButton.setEnabled(true);
            this.addButton.setEnabled(true);
            this.UpdateUI();
        }
    }

    private void toggleMonitorButton(String command) {
        if (command.equals("stop")) {
            this.monitorButton.setIcon(monitorStopIcon);
            this.monitorButton.setRolloverIcon(monitorStopRolloverIcon);
            this.monitorButton.setActionCommand("stop");
            this.monitorButton.setToolTipText("Stop monitoring AOIs");
            this.newButton.setEnabled(false);
            this.addButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.clearButton.setEnabled(false);
            this.processButton.setEnabled(false);
        } else {
            this.monitorButton.setIcon(monitorStartIcon);
            this.monitorButton.setRolloverIcon(monitorStartRolloverIcon);
            this.monitorButton.setActionCommand("update");
            this.monitorButton.setToolTipText("Begin monitoring all AOI folders");
            this.newButton.setEnabled(true);
            this.addButton.setEnabled(true);
            this.UpdateUI();
        }
    }

    private void updateStatusLabel() {
    }

    private void ShowAOIs(AOI[] aoiList) {
        AOITableModel tableModel = new AOITableModel(aoiList);
        AOISortingDecorator sortedModel = new AOISortingDecorator(tableModel, this.aoiTable.getTableHeader());
        this.aoiTable.setModel(sortedModel);
        this.aoiTable.setColumnModel(tableModel.getColumnModel());
        this.updateStatusLabel();
        GeoPos[][] geoBoundaries = new GeoPos[aoiList.length][4];
        int i = 0;
        for (AOI aoi : aoiList) {
            geoBoundaries[i++] = aoi.getPoints();
        }
        this.worldMapUI.setAdditionalGeoBoundaries(geoBoundaries);
    }

    static {
        aoiFileFilter = new SnapFileFilter("AOI", new String[]{".xml"}, "SNAP AOI files");
    }

    private class MyBatchProcessListener
    implements BatchGraphDialog.BatchProcessListener {
        private MyBatchProcessListener() {
        }

        public void notifyMSG(BatchGraphDialog.BatchProcessListener.BatchMSG msg, File[] inputFileList, File[] outputFileList) {
            if (msg.equals((Object)BatchGraphDialog.BatchProcessListener.BatchMSG.DONE) && AOIMonitoringToolView.this.processingAOI != null) {
                for (int i = 0; i < outputFileList.length; ++i) {
                    AOIMonitoringToolView.this.aoiManager;
                    AOIManager.setBatchProcessResult(AOIMonitoringToolView.this.processingAOI, inputFileList[i], outputFileList[i]);
                }
                AOIMonitoringToolView.this.processingAOI = null;
            }
        }

        public void notifyMSG(BatchGraphDialog.BatchProcessListener.BatchMSG msg, String text) {
            if (msg.equals((Object)BatchGraphDialog.BatchProcessListener.BatchMSG.UPDATE)) {
                // empty if block
            }
        }
    }

    private class MyProgressBarListener
    implements LabelBarProgressMonitor.ProgressBarListener {
        private MyProgressBarListener() {
        }

        public void notifyProgressStart() {
            AOIMonitoringToolView.this.progressPanel.setVisible(true);
            if (!AOIMonitoringToolView.this.aoiMonitor.isStarted()) {
                AOIMonitoringToolView.this.toggleProcessButton("stop");
            }
        }

        public void notifyProgressDone() {
            AOIMonitoringToolView.this.progressPanel.setVisible(false);
            if (!AOIMonitoringToolView.this.aoiMonitor.isStarted()) {
                AOIMonitoringToolView.this.toggleProcessButton("update");
            }
            AOIMonitoringToolView.this.mainPanel.setCursor(Cursor.getDefaultCursor());
        }
    }
}

