/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.netcdf.metadata.profiles.beam;

import java.io.IOException;
import java.util.Locale;
import org.esa.snap.core.dataio.EncodeQualification;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.dataio.netcdf.AbstractNetCdfWriterPlugIn;
import org.esa.snap.dataio.netcdf.metadata.ProfileInitPartWriter;
import org.esa.snap.dataio.netcdf.metadata.ProfilePartWriter;
import org.esa.snap.dataio.netcdf.metadata.profiles.beam.BeamBandPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.beam.BeamFlagCodingPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.beam.BeamGeocodingPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.beam.BeamImageInfoPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.beam.BeamIndexCodingPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.beam.BeamInitialisationPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.beam.BeamMaskPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.beam.BeamMetadataPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.beam.BeamStxPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.beam.BeamTiePointGridPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.cf.CfDescriptionPart;
import org.esa.snap.dataio.netcdf.metadata.profiles.cf.CfTimePart;
import org.esa.snap.dataio.netcdf.nc.NFileWriteable;
import org.esa.snap.dataio.netcdf.nc.NWritableFactory;

public class BeamNetCdfWriterPlugIn
extends AbstractNetCdfWriterPlugIn {
    public EncodeQualification getEncodeQualification(Product product) {
        if (product.isMultiSize()) {
            return new EncodeQualification(EncodeQualification.Preservation.UNABLE, "Cannot write multisize products. Consider resampling the product first.");
        }
        return EncodeQualification.FULL;
    }

    public String[] getFormatNames() {
        return new String[]{"NetCDF-BEAM"};
    }

    public String[] getDefaultFileExtensions() {
        return new String[]{".nc"};
    }

    public String getDescription(Locale locale) {
        return "BEAM NetCDF products";
    }

    @Override
    public NFileWriteable createWritable(String outputPath) throws IOException {
        return NWritableFactory.create(outputPath, "netcdf3");
    }

    @Override
    public ProfileInitPartWriter createInitialisationPartWriter() {
        return new BeamInitialisationPart();
    }

    @Override
    public ProfilePartWriter createMetadataPartWriter() {
        return new BeamMetadataPart();
    }

    @Override
    public ProfilePartWriter createBandPartWriter() {
        return new BeamBandPart();
    }

    @Override
    public ProfilePartWriter createDescriptionPartWriter() {
        return new CfDescriptionPart();
    }

    @Override
    public ProfilePartWriter createFlagCodingPartWriter() {
        return new BeamFlagCodingPart();
    }

    @Override
    public ProfilePartWriter createGeoCodingPartWriter() {
        return new BeamGeocodingPart();
    }

    @Override
    public ProfilePartWriter createImageInfoPartWriter() {
        return new BeamImageInfoPart();
    }

    @Override
    public ProfilePartWriter createIndexCodingPartWriter() {
        return new BeamIndexCodingPart();
    }

    @Override
    public ProfilePartWriter createMaskPartWriter() {
        return new BeamMaskPart();
    }

    @Override
    public ProfilePartWriter createTimePartWriter() {
        return new CfTimePart();
    }

    @Override
    public ProfilePartWriter createStxPartWriter() {
        return new BeamStxPart();
    }

    @Override
    public ProfilePartWriter createTiePointGridPartWriter() {
        return new BeamTiePointGridPart();
    }
}

