/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.ndvi;

import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.ndvi.NdviOp;
import org.junit.Assert;
import org.junit.Test;

public class NdviOpTest {
    @Test
    public void testFindBand() throws Exception {
        Product product = new Product("dummy", "dummy", 10, 10);
        NdviOpTest.addBand(product, "a", 500);
        NdviOpTest.addBand(product, "b", 600);
        NdviOpTest.addBand(product, "c", 620);
        NdviOpTest.addBand(product, "d", 700);
        NdviOpTest.addBand(product, "e", 712);
        NdviOpTest.addBand(product, "f", 715);
        NdviOpTest.addBand(product, "g", 799);
        NdviOpTest.addBand(product, "h", 800);
        NdviOpTest.addBand(product, "i", 801);
        NdviOpTest.addBand(product, "j", 899);
        NdviOpTest.addBand(product, "k", 900);
        NdviOpTest.addBand(product, "l", 16000);
        Assert.assertEquals((Object)"b", (Object)NdviOp.findBand((float)600.0f, (float)650.0f, (Product)product));
        Assert.assertEquals((Object)"h", (Object)NdviOp.findBand((float)800.0f, (float)900.0f, (Product)product));
    }

    @Test
    public void testFindBand_nothingFound() throws Exception {
        Product product = new Product("dummy", "dummy", 10, 10);
        NdviOpTest.addBand(product, "a", 500);
        NdviOpTest.addBand(product, "b", 600);
        NdviOpTest.addBand(product, "c", 620);
        NdviOpTest.addBand(product, "d", 700);
        NdviOpTest.addBand(product, "e", 712);
        NdviOpTest.addBand(product, "f", 715);
        NdviOpTest.addBand(product, "g", 799);
        NdviOpTest.addBand(product, "h", 800);
        NdviOpTest.addBand(product, "i", 801);
        NdviOpTest.addBand(product, "j", 899);
        NdviOpTest.addBand(product, "k", 900);
        Assert.assertNull((Object)NdviOp.findBand((float)400.0f, (float)499.0f, (Product)product));
        Assert.assertNull((Object)NdviOp.findBand((float)701.0f, (float)711.0f, (Product)product));
        Assert.assertNull((Object)NdviOp.findBand((float)901.0f, (float)12000.0f, (Product)product));
    }

    @Test
    public void testFindBand_nothingFound_2() throws Exception {
        Product product = new Product("dummy", "dummy", 10, 10);
        NdviOpTest.addBand(product, "a");
        NdviOpTest.addBand(product, "b");
        NdviOpTest.addBand(product, "c");
        NdviOpTest.addBand(product, "d");
        NdviOpTest.addBand(product, "e");
        NdviOpTest.addBand(product, "f");
        NdviOpTest.addBand(product, "g");
        NdviOpTest.addBand(product, "h");
        NdviOpTest.addBand(product, "i");
        NdviOpTest.addBand(product, "j");
        NdviOpTest.addBand(product, "k");
        NdviOpTest.addBand(product, "l");
        Assert.assertNull((Object)NdviOp.findBand((float)600.0f, (float)650.0f, (Product)product));
    }

    public static void addBand(Product product, String bandName) {
        Band a = new Band(bandName, 30, 10, 10);
        product.addBand(a);
    }

    public static void addBand(Product product, String bandName, int wavelength) {
        Band a = new Band(bandName, 30, 10, 10);
        a.setSpectralWavelength((float)wavelength);
        product.addBand(a);
    }
}

