/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.jython;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.esa.snap.core.util.ServiceFinder;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.runtime.Activator;
import org.python.core.PyDictionary;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.util.PythonInterpreter;

public class PluginActivator
implements Activator {
    public static final String JYTHON_EXTRA_PATHS_PROPERTY = "snap.jythonExtraPaths";
    public static final String SNAP_JYTHON_DIRNAME = "snap-jython";
    private PythonInterpreter jythonInterpreter;
    private List<PyObject> jythonActivators;

    PythonInterpreter getJythonInterpreter() {
        return this.jythonInterpreter;
    }

    List<PyObject> getJythonActivators() {
        return this.jythonActivators;
    }

    public void start() {
        PySystemState pyState = new PySystemState();
        pyState.setClassLoader(Thread.currentThread().getContextClassLoader());
        this.jythonInterpreter = new PythonInterpreter((PyObject)new PyDictionary(), pyState);
        this.jythonActivators = new ArrayList<PyObject>();
        this.initActivators();
        for (PyObject self : this.jythonActivators) {
            self.invoke("start");
        }
    }

    public void stop() {
        if (this.jythonActivators != null) {
            for (PyObject self : this.jythonActivators) {
                self.invoke("stop");
            }
            this.jythonActivators = null;
        }
        if (this.jythonInterpreter != null) {
            this.jythonInterpreter.close();
            this.jythonInterpreter = null;
        }
    }

    private void initActivators() {
        Path jythonDir = SystemUtils.getApplicationDataDir((boolean)true).toPath().resolve(SNAP_JYTHON_DIRNAME);
        if (!Files.exists(jythonDir, new LinkOption[0])) {
            try {
                Files.createDirectories(jythonDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                SystemUtils.LOG.log(Level.WARNING, "SNAP-Jython configuration error: failed to create " + jythonDir, e);
            }
        }
        ServiceFinder serviceFinder = new ServiceFinder(PluginActivator.class.getName());
        serviceFinder.addSearchPath(jythonDir);
        serviceFinder.addSearchPathsFromPreferences(JYTHON_EXTRA_PATHS_PROPERTY);
        serviceFinder.searchClassPath(true);
        List modules = serviceFinder.findServices();
        for (ServiceFinder.Module module : modules) {
            for (String pythonClassName : module.getServiceNames()) {
                this.loadActivator(module.getPath(), pythonClassName);
            }
        }
    }

    private void loadActivator(Path moduleRoot, String pythonClassName) {
        int lastDotPos = pythonClassName.lastIndexOf(46);
        String modulePath = "";
        String className = "";
        if (lastDotPos > 0) {
            modulePath = pythonClassName.substring(0, lastDotPos);
            className = pythonClassName.substring(lastDotPos + 1);
            this.loadActivator(moduleRoot, modulePath, className);
        }
        if (modulePath.isEmpty() || className.isEmpty()) {
            SystemUtils.LOG.warning(String.format("Invalid Python module entry in %s: %s", moduleRoot, pythonClassName));
        }
    }

    private void loadActivator(Path pythonModuleRoot, String pythonModuleName, String pythonClassName) {
        File pythonModuleRootFile = FileUtils.toFile((Path)pythonModuleRoot);
        try {
            this.jythonInterpreter.exec("import sys\nsys.path += ['" + pythonModuleRootFile.getPath().replace("\\", "\\\\") + "']");
            this.jythonInterpreter.exec("from " + pythonModuleName + " import " + pythonClassName);
            PyObject activator = this.jythonInterpreter.eval(pythonClassName + "()");
            this.jythonActivators.add(activator);
            SystemUtils.LOG.info(String.format("Jython activator %s.%s loaded from %s", pythonModuleName, pythonClassName, pythonModuleRoot));
        }
        catch (Exception e) {
            String msg = String.format("Failed to create Jython activator %s.%s defined in %s", pythonModuleName, pythonClassName, pythonModuleRoot);
            SystemUtils.LOG.log(Level.SEVERE, msg, e);
        }
    }
}

