/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.util;

import java.io.File;
import java.io.IOException;
import org.esa.snap.db.CommonReaders;
import org.esa.snap.framework.datamodel.Product;
import org.esa.snap.framework.datamodel.ProductManager;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.SnapDialogs;

public class ProductOpener {
    public void openProducts(File[] productFiles) {
        for (File productFile : productFiles) {
            if (!productFile.exists()) continue;
            try {
                Product product = CommonReaders.readProduct((File)productFile);
                ProductManager productManager = SnapApp.getDefault().getProductManager();
                productManager.addProduct(product);
            }
            catch (IOException e) {
                SnapDialogs.showError((String)("Not able to open product:\n" + productFile.getPath()));
            }
        }
    }
}

