/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.util;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.esa.snap.util.FileListSelection;
import org.esa.snap.util.SystemUtils;

public class ClipboardUtils {
    public static void copyToClipboard(String text) {
        StringSelection selection = new StringSelection(text == null ? "" : text);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (clipboard != null) {
            clipboard.setContents(selection, selection);
        } else {
            SystemUtils.LOG.severe("failed to obtain clipboard instance");
        }
    }

    public static String getClipboardString() throws IOException, UnsupportedFlavorException {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (clipboard != null) {
            return (String)clipboard.getData(DataFlavor.stringFlavor);
        }
        return null;
    }

    public static void copyToClipboard(File[] fileList) {
        FileListSelection selection = new FileListSelection(fileList);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (clipboard != null) {
            clipboard.setContents(selection, (ClipboardOwner)((Object)selection));
        } else {
            SystemUtils.LOG.severe("failed to obtain clipboard instance");
        }
    }

    public static File[] getClipboardFileList() throws IOException, UnsupportedFlavorException {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        if (clipboard != null) {
            List fileList = (List)clipboard.getData(DataFlavor.javaFileListFlavor);
            return fileList.toArray(new File[fileList.size()]);
        }
        return new File[0];
    }
}

