/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.graphbuilder.gpf.ui;

import java.awt.Window;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import org.esa.snap.GlobalTestConfig;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductManager;
import org.esa.snap.core.util.DefaultPropertyMap;
import org.esa.snap.core.util.PropertyMap;
import org.esa.snap.graphbuilder.gpf.ui.TargetUI;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.product.ProductSceneView;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TargetUITest {
    TargetUI targetUI;
    private Product[] defaultProducts;
    private AppContext appContext;
    private final Map<String, Object> parameterMap = new HashMap<String, Object>();
    private final String FILE_PARAMETER = "file";

    @Before
    public void setUp() throws Exception {
        this.targetUI = new TargetUI();
        this.appContext = new MockAppContext();
        File path = GlobalTestConfig.getBeamTestDataOutputDirectory();
        this.defaultProducts = new Product[2];
        for (int i = 0; i < this.defaultProducts.length; ++i) {
            Product prod = new Product("P" + i, "T" + i, 10, 10);
            prod.setFileLocation(path);
            this.appContext.getProductManager().addProduct(prod);
            this.defaultProducts[i] = prod;
        }
    }

    @Test
    public void testCreateOpTab() {
        JComponent component = this.targetUI.CreateOpTab("testOp", this.parameterMap, this.appContext);
        Assert.assertNotNull((Object)component);
    }

    @Test
    public void testUpdateParameters() {
        this.targetUI.CreateOpTab("testOp", this.parameterMap, this.appContext);
        this.parameterMap.put("file", this.defaultProducts[0]);
    }

    private class MockAppContext
    implements AppContext {
        private PropertyMap preferences = new DefaultPropertyMap();
        private ProductManager prodMan = new ProductManager();

        private MockAppContext() {
        }

        public Product getSelectedProduct() {
            return TargetUITest.this.defaultProducts[0];
        }

        public Window getApplicationWindow() {
            return null;
        }

        public String getApplicationName() {
            return "Killer App";
        }

        public void handleError(Throwable e) {
            JOptionPane.showMessageDialog(this.getApplicationWindow(), e.getMessage());
        }

        public void handleError(String message, Throwable e) {
            JOptionPane.showMessageDialog(this.getApplicationWindow(), message);
        }

        public PropertyMap getPreferences() {
            return this.preferences;
        }

        public ProductManager getProductManager() {
            return this.prodMan;
        }

        public ProductSceneView getSelectedProductSceneView() {
            return null;
        }
    }
}

