/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.monitor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.gpf.internal.OperatorContext;
import org.esa.snap.core.gpf.internal.OperatorImage;
import org.esa.snap.core.gpf.internal.OperatorImageTileStack;
import org.esa.snap.core.gpf.monitor.TileComputationEvent;
import org.esa.snap.core.gpf.monitor.TileComputationObserver;
import org.esa.snap.core.util.StringUtils;

public class OperatorRuntimeReport
extends TileComputationObserver {
    private final List<TileComputationEvent> recordedEventList = Collections.synchronizedList(new LinkedList());
    private final Map<StatKey, StatValue> allStats = new HashMap<StatKey, StatValue>();
    private final Map<OperatorContext, Band> firstImage = new HashMap<OperatorContext, Band>();

    @Override
    public void start() {
    }

    @Override
    public void tileComputed(TileComputationEvent event) {
        this.recordedEventList.add(event);
    }

    @Override
    public void stop() {
        if (this.recordedEventList.size() == 0) {
            return;
        }
        long totalNettoTime = 0L;
        long startNanosMin = Long.MAX_VALUE;
        long endNanosMax = Long.MIN_VALUE;
        for (TileComputationEvent event : this.recordedEventList) {
            StatKey statKey;
            startNanosMin = Math.min(startNanosMin, event.getStartNanos());
            endNanosMax = Math.max(endNanosMax, event.getEndNanos());
            OperatorImage opImage = event.getImage();
            OperatorContext operatorContext = opImage.getOperatorContext();
            Band targetBand = opImage.getTargetBand();
            String bandName = targetBand.getName();
            long bruttoNanos = event.getEndNanos() - event.getStartNanos();
            long nettoNanos = event.getNettoNanos();
            boolean addTime = true;
            if (opImage instanceof OperatorImageTileStack) {
                Band firstBand = this.firstImage.get(operatorContext);
                if (firstBand == null) {
                    this.firstImage.put(operatorContext, targetBand);
                    firstBand = targetBand;
                }
                if (targetBand != firstBand) {
                    addTime = false;
                }
                statKey = new StatKey(operatorContext, "ALL");
            } else {
                statKey = new StatKey(operatorContext, "ALL");
            }
            StatValue imageStat = this.allStats.get(statKey);
            if (imageStat == null) {
                String opType = OperatorRuntimeReport.getOpType(opImage);
                String opAlias = OperatorRuntimeReport.getOpAlias(operatorContext);
                String opClass = OperatorRuntimeReport.getOpClass(operatorContext);
                imageStat = new StatValue(opType, opAlias, opClass);
                this.allStats.put(statKey, imageStat);
            }
            if (addTime) {
                imageStat.add(bruttoNanos, nettoNanos, bandName);
                totalNettoTime += nettoNanos;
                continue;
            }
            imageStat.add(0L, 0L, bandName);
        }
        ArrayList<StatValue> values = new ArrayList<StatValue>(this.allStats.values());
        Collections.sort(values, new Comparator<StatValue>(){

            @Override
            public int compare(StatValue o1, StatValue o2) {
                return Long.compare(o1.nettoNanos, o2.nettoNanos);
            }
        });
        int[] colWidth = new int[7];
        for (StatValue stat : values) {
            String[] strings = stat.toStringArray(totalNettoTime);
            for (int i = 0; i < strings.length; ++i) {
                colWidth[i] = Math.max(colWidth[i], strings[i].length());
            }
        }
        int colWidthSum = 26;
        for (int i = 0; i < colWidth.length - 1; ++i) {
            colWidthSum += colWidth[i];
        }
        String headerFormat = "%-" + colWidth[0] + "s | %-" + colWidth[1] + "s | %-" + colWidth[2] + "s | %-" + colWidth[3] + "s | %-" + colWidth[4] + "s | %-" + colWidth[5] + "s  | %-" + colWidth[6] + "s\n";
        String rowFormat = "%-" + colWidth[0] + "s | %-" + colWidth[1] + "s | %-" + colWidth[2] + "s | %" + colWidth[3] + "s | %" + colWidth[4] + "s | %" + colWidth[5] + "s%% | %-" + colWidth[6] + "s\n";
        System.out.println();
        System.out.format(headerFormat, "op Alias", "op Class", "", "brutto", "netto", "", "bands");
        for (int i = 0; i < colWidthSum; ++i) {
            System.out.print("=");
        }
        System.out.println();
        for (StatValue stat : values) {
            System.out.format(rowFormat, stat.toStringArray(totalNettoTime));
        }
        System.out.println();
        System.out.format("computation time: %,8d ms\n", OperatorRuntimeReport.asMillis(totalNettoTime));
        System.out.format("wall clock time:  %,8d ms\n", OperatorRuntimeReport.asMillis(endNanosMax - startNanosMin));
    }

    private static String getOpAlias(OperatorContext operatorContext) {
        return operatorContext.getOperatorSpi().getOperatorDescriptor().getAlias();
    }

    private static String getOpClass(OperatorContext operatorContext) {
        return operatorContext.getOperator().getClass().getName();
    }

    private static String getOpType(OperatorImage opImage) {
        if (opImage instanceof OperatorImageTileStack) {
            return "STACK";
        }
        return "TILE";
    }

    private static long asMillis(long bruttoNanos) {
        return bruttoNanos / 1000000L;
    }

    private static final class StatKey {
        private final OperatorContext operatorContext;
        private final String bandname;

        public StatKey(OperatorContext operatorContext, String bandname) {
            this.operatorContext = operatorContext;
            this.bandname = bandname;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StatKey statKey = (StatKey)o;
            if (!this.bandname.equals(statKey.bandname)) {
                return false;
            }
            return this.operatorContext.equals(statKey.operatorContext);
        }

        public int hashCode() {
            int result = this.operatorContext.hashCode();
            result = 31 * result + this.bandname.hashCode();
            return result;
        }
    }

    private static final class StatValue {
        private final Set<String> bandNameSet = new HashSet<String>();
        private final String opType;
        private final String opAlias;
        private final String opClass;
        private long bruttoNanos = 0L;
        private long nettoNanos = 0L;

        StatValue(String opType, String opAlias, String opClass) {
            this.opType = opType;
            this.opAlias = opAlias;
            this.opClass = opClass;
        }

        void add(long bruttoNanos, long nettoNanos, String bandName) {
            this.bruttoNanos += bruttoNanos;
            this.nettoNanos += nettoNanos;
            this.bandNameSet.add(bandName);
        }

        String[] toStringArray(long totalNettoTime) {
            String[] strings = new String[7];
            strings[0] = this.opAlias;
            strings[1] = this.opClass;
            strings[2] = this.opType;
            strings[3] = String.format("%d", OperatorRuntimeReport.asMillis(this.bruttoNanos));
            strings[4] = String.format("%d", OperatorRuntimeReport.asMillis(this.nettoNanos));
            strings[5] = String.format("%.2f", Float.valueOf(100.0f * (float)this.nettoNanos / (float)totalNettoTime));
            ArrayList<String> nameList = new ArrayList<String>(this.bandNameSet);
            Collections.sort(nameList);
            strings[6] = StringUtils.join(nameList, (String)",");
            return strings;
        }
    }
}

