/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.internal;

import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.util.math.MathUtils;
import org.esa.snap.core.util.math.Range;

class SampleConverterFactory {
    private SampleConverterFactory() {
    }

    public static SampleConverter createConverter(RasterDataNode rasterDataNode) {
        boolean signedByte;
        boolean scaled = rasterDataNode.isScalingApplied();
        boolean bl = signedByte = rasterDataNode.getDataType() == 10;
        if (!signedByte && !scaled) {
            return new IdentityConverter(rasterDataNode);
        }
        if (signedByte) {
            if (scaled) {
                return new ScaledSignedByteConverter(rasterDataNode);
            }
            return new UnscaledSignedByteConverter(rasterDataNode);
        }
        return new DefaultScaledConverter(rasterDataNode);
    }

    public static abstract class SampleConverter {
        private RasterDataNode rasterDataNode;
        private Range rawValueRange;
        private Range geoPhysicalValueRange;

        protected SampleConverter(RasterDataNode rasterDataNode) {
            this.rasterDataNode = rasterDataNode;
            this.rawValueRange = SampleConverter.getValueRange(rasterDataNode.getDataType());
            this.geoPhysicalValueRange = new Range(rasterDataNode.scale(this.rawValueRange.getMin()), rasterDataNode.scale(this.rawValueRange.getMax()));
        }

        public abstract double toGeoPhysical(double var1);

        public abstract double toRaw(double var1);

        protected double scaleToRaw(double sample) {
            return this.rasterDataNode.scaleInverse(sample);
        }

        protected double scaleToGeoPhysical(double sample) {
            return this.rasterDataNode.scale(sample);
        }

        protected double cropToRawValueRange(double sample) {
            return MathUtils.crop((double)sample, (double)this.rawValueRange.getMin(), (double)this.rawValueRange.getMax());
        }

        protected double cropToGeoPhysicalValueRange(double sample) {
            return MathUtils.crop((double)sample, (double)this.geoPhysicalValueRange.getMin(), (double)this.geoPhysicalValueRange.getMax());
        }

        private static Range getValueRange(int dataType) {
            Range range = new Range();
            switch (dataType) {
                case 10: {
                    range.setMinMax(-128.0, 127.0);
                    break;
                }
                case 11: {
                    range.setMinMax(-32768.0, 32767.0);
                    break;
                }
                case 12: {
                    range.setMinMax(-2.147483648E9, 2.147483647E9);
                    break;
                }
                case 20: {
                    range.setMinMax(0.0, Math.pow(2.0, 8.0) - 1.0);
                    break;
                }
                case 21: {
                    range.setMinMax(0.0, Math.pow(2.0, 16.0) - 1.0);
                    break;
                }
                case 22: {
                    range.setMinMax(0.0, Math.pow(2.0, 32.0) - 1.0);
                    break;
                }
                case 30: {
                    range.setMinMax(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
                    break;
                }
                case 31: {
                    range.setMinMax(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format("Can not retrieve value range for given type or type is unknown: %d", dataType));
                }
            }
            return range;
        }
    }

    private static class IdentityConverter
    extends SampleConverter {
        private IdentityConverter(RasterDataNode rasterDataNode) {
            super(rasterDataNode);
        }

        @Override
        public double toGeoPhysical(double rawSample) {
            return rawSample;
        }

        @Override
        public double toRaw(double geoPhysicalSample) {
            return this.cropToRawValueRange(geoPhysicalSample);
        }
    }

    public static class UnscaledSignedByteConverter
    extends SampleConverter {
        protected UnscaledSignedByteConverter(RasterDataNode rasterDataNode) {
            super(rasterDataNode);
        }

        @Override
        public double toGeoPhysical(double rawSample) {
            double geoSample = rawSample;
            geoSample = (byte)geoSample;
            return geoSample;
        }

        @Override
        public double toRaw(double geoPhysicalSample) {
            double rawSample = geoPhysicalSample;
            rawSample = this.cropToRawValueRange(rawSample);
            return rawSample;
        }
    }

    public static class ScaledSignedByteConverter
    extends SampleConverter {
        protected ScaledSignedByteConverter(RasterDataNode rasterDataNode) {
            super(rasterDataNode);
        }

        @Override
        public double toGeoPhysical(double rawSample) {
            double geoSample = rawSample;
            geoSample = (byte)geoSample;
            geoSample = this.scaleToGeoPhysical(geoSample);
            geoSample = this.cropToGeoPhysicalValueRange(geoSample);
            return geoSample;
        }

        @Override
        public double toRaw(double geoPhysicalSample) {
            double rawSample = geoPhysicalSample;
            rawSample = this.scaleToRaw(rawSample);
            rawSample = this.cropToRawValueRange(rawSample);
            return rawSample;
        }
    }

    public static class DefaultScaledConverter
    extends SampleConverter {
        protected DefaultScaledConverter(RasterDataNode rasterDataNode) {
            super(rasterDataNode);
        }

        @Override
        public double toGeoPhysical(double rawSample) {
            double geoSample = rawSample;
            geoSample = this.scaleToGeoPhysical(geoSample);
            geoSample = this.cropToGeoPhysicalValueRange(geoSample);
            return geoSample;
        }

        @Override
        public double toRaw(double geoPhysicalSample) {
            double rawSample = geoPhysicalSample;
            rawSample = this.scaleToRaw(rawSample);
            rawSample = this.cropToRawValueRange(rawSample);
            return rawSample;
        }
    }
}

