/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.gpf.operators.standard;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.media.jai.JAI;
import javax.media.jai.TileCache;
import org.esa.beam.dataio.dimap.DimapProductWriter;
import org.esa.beam.framework.dataio.ProductIO;
import org.esa.beam.framework.dataio.ProductWriter;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.ProductNode;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.framework.gpf.annotations.TargetProduct;
import org.esa.beam.framework.gpf.internal.OperatorExecutor;
import org.esa.beam.jai.ImageManager;
import org.esa.beam.util.Guardian;
import org.esa.beam.util.math.MathUtils;

@OperatorMetadata(alias="Write", category="Input-Output", version="1.3", authors="Marco Zuehlke, Norman Fomferra", copyright="(c) 2010 by Brockmann Consult", description="Writes a data product to a file.", autoWriteDisabled=true)
public class WriteOp
extends Operator {
    @TargetProduct
    private Product targetProduct;
    @SourceProduct(alias="source", description="The source product to be written.")
    private Product sourceProduct;
    @Parameter(description="The output file to which the data product is written.")
    private File file;
    @Parameter(defaultValue="BEAM-DIMAP", description="The name of the output file format.")
    private String formatName;
    @Parameter(defaultValue="true", description="If true, all output files are deleted after a failed write operation.")
    private boolean deleteOutputOnFailure = true;
    @Parameter(defaultValue="true", description="If true, the write operation waits until an entire tile row is computed.")
    private boolean writeEntireTileRows;
    @Parameter(defaultValue="false", description="If true, the internal tile cache is cleared after a tile row has been written. Ignored if writeEntireTileRows=false.")
    private boolean clearCacheAfterRowWrite;
    private boolean[][][] tilesWritten;
    private final Map<Row, Tile[]> writeCache = new HashMap<Row, Tile[]>();
    private ProductWriter productWriter;
    private List<Band> writableBands;
    private Dimension tileSize;
    private int tileCountX;
    private int tileCountY;
    private boolean outputFileExists = false;
    private boolean incremental = false;

    public WriteOp() {
        this.setParameterDefaultValues();
        this.setRequiresAllBands(true);
    }

    public WriteOp(Product sourceProduct, File file, String formatName) {
        this();
        Guardian.assertNotNull((String)"file", (Object)file);
        this.sourceProduct = sourceProduct;
        this.file = file;
        this.formatName = formatName;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getFormatName() {
        return this.formatName;
    }

    public void setIncremental(boolean incremental) {
        this.incremental = incremental;
    }

    public void setFormatName(String formatName) {
        this.formatName = formatName;
    }

    public boolean isDeleteOutputOnFailure() {
        return this.deleteOutputOnFailure;
    }

    public void setDeleteOutputOnFailure(boolean deleteOutputOnFailure) {
        this.deleteOutputOnFailure = deleteOutputOnFailure;
    }

    public boolean isWriteEntireTileRows() {
        return this.writeEntireTileRows;
    }

    public void setWriteEntireTileRows(boolean writeEntireTileRows) {
        this.writeEntireTileRows = writeEntireTileRows;
    }

    public boolean isClearCacheAfterRowWrite() {
        return this.clearCacheAfterRowWrite;
    }

    public void setClearCacheAfterRowWrite(boolean clearCacheAfterRowWrite) {
        this.clearCacheAfterRowWrite = clearCacheAfterRowWrite;
    }

    public void writeProduct(ProgressMonitor pm) {
        long startNanos = System.nanoTime();
        this.getLogger().info("Start writing product " + this.getTargetProduct().getName() + " to " + this.getFile());
        OperatorExecutor operatorExecutor = OperatorExecutor.create(this);
        try {
            if (this.clearCacheAfterRowWrite && this.writeEntireTileRows) {
                operatorExecutor.setScheduleRowsSeparate(true);
            }
            operatorExecutor.execute(OperatorExecutor.ExecutionOrder.SCHEDULE_ROW_COLUMN_BAND, "Writing...", pm);
            this.getLogger().info("End writing product " + this.getTargetProduct().getName() + " to " + this.getFile());
            double seconds = (double)(System.nanoTime() - startNanos) / 1.0E9;
            int w = this.getTargetProduct().getSceneRasterWidth();
            int h = this.getTargetProduct().getSceneRasterHeight();
            this.getLogger().info(MessageFormat.format("Time: {0} sec. total, {1} sec. per line, {2} sec. per pixel", seconds, seconds / (double)h, seconds / (double)h / (double)w));
            this.stopTileComputationObservation();
        }
        catch (OperatorException e) {
            if (this.deleteOutputOnFailure && !this.outputFileExists) {
                try {
                    this.productWriter.deleteOutput();
                }
                catch (Exception e2) {
                    this.getLogger().warning("Failed to delete output after failure: " + e2.getMessage());
                }
            }
            throw e;
        }
        finally {
            this.dispose();
        }
    }

    @Override
    public void initialize() throws OperatorException {
        this.targetProduct = this.sourceProduct;
        this.outputFileExists = this.targetProduct.getFileLocation() != null && this.targetProduct.getFileLocation().exists();
        this.productWriter = ProductIO.getProductWriter((String)this.formatName);
        if (this.productWriter == null) {
            throw new OperatorException("No data product writer for the '" + this.formatName + "' format available");
        }
        this.productWriter.setIncrementalMode(this.incremental);
        this.targetProduct.setProductWriter(this.productWriter);
        Band[] bands = this.targetProduct.getBands();
        this.writableBands = new ArrayList<Band>(bands.length);
        for (Band band : bands) {
            band.getSourceImage();
            if (!this.productWriter.shouldWrite((ProductNode)band)) continue;
            this.writableBands.add(band);
        }
        this.tileSize = ImageManager.getPreferredTileSize((Product)this.targetProduct);
        this.targetProduct.setPreferredTileSize(this.tileSize);
        this.tileCountX = MathUtils.ceilInt((double)((double)this.targetProduct.getSceneRasterWidth() / (double)this.tileSize.width));
        this.tileCountY = MathUtils.ceilInt((double)((double)this.targetProduct.getSceneRasterHeight() / (double)this.tileSize.height));
        this.tilesWritten = new boolean[this.writableBands.size()][this.tileCountY][this.tileCountX];
        try {
            this.productWriter.writeProductNodes(this.targetProduct, (Object)this.file);
        }
        catch (IOException e) {
            throw new OperatorException("Not able to write product file: '" + this.file.getAbsolutePath() + "'", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        block17: {
            if (!this.writableBands.contains(targetBand)) {
                return;
            }
            try {
                Rectangle rect = targetTile.getRectangle();
                int tileX = MathUtils.floorInt((double)((double)targetTile.getMinX() / (double)this.tileSize.width));
                int tileY = MathUtils.floorInt((double)((double)targetTile.getMinY() / (double)this.tileSize.height));
                if (this.writeEntireTileRows) {
                    TileCache tileCache;
                    Row row = new Row(targetBand, tileY);
                    Tile[] tileRowToWrite = this.updateTileRow(row, tileX, targetTile);
                    if (tileRowToWrite != null) {
                        this.writeTileRow(targetBand, tileRowToWrite);
                    }
                    this.markTileAsHandled(targetBand, tileX, tileY);
                    if (this.clearCacheAfterRowWrite && tileRowToWrite != null && this.isRowWrittenCompletely(tileY) && (tileCache = JAI.getDefaultInstance().getTileCache()) != null) {
                        tileCache.flush();
                    }
                } else {
                    ProductData rawSamples = targetTile.getRawSamples();
                    ProductWriter productWriter = this.productWriter;
                    synchronized (productWriter) {
                        this.productWriter.writeBandRasterData(targetBand, rect.x, rect.y, rect.width, rect.height, rawSamples, pm);
                    }
                    this.markTileAsHandled(targetBand, tileX, tileY);
                }
                if (!(this.productWriter instanceof DimapProductWriter) || !this.isProductWrittenCompletely()) break block17;
                ProductWriter productWriter = this.productWriter;
                synchronized (productWriter) {
                    this.productWriter.writeProductNodes(this.targetProduct, (Object)this.file);
                }
            }
            catch (Exception e) {
                if (this.deleteOutputOnFailure && !this.outputFileExists) {
                    try {
                        this.productWriter.deleteOutput();
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                }
                if (e instanceof OperatorException) {
                    throw (OperatorException)e;
                }
                throw new OperatorException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tile[] updateTileRow(Row key, int tileX, Tile currentTile) {
        Map<Row, Tile[]> map = this.writeCache;
        synchronized (map) {
            Tile[] tileRow;
            if (this.writeCache.containsKey(key)) {
                tileRow = this.writeCache.get(key);
            } else {
                tileRow = new Tile[this.tileCountX];
                this.writeCache.put(key, tileRow);
            }
            tileRow[tileX] = currentTile;
            for (Tile tile : tileRow) {
                if (tile != null) continue;
                return null;
            }
            this.writeCache.remove(key);
            return tileRow;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTileRow(Band band, Tile[] cacheLine) throws IOException {
        Tile firstTile = cacheLine[0];
        int sceneWidth = this.targetProduct.getSceneRasterWidth();
        Rectangle lineBounds = new Rectangle(0, firstTile.getMinY(), sceneWidth, firstTile.getHeight());
        ProductData[] rawSampleOFLine = new ProductData[cacheLine.length];
        int[] tileWidth = new int[cacheLine.length];
        for (int tileX = 0; tileX < cacheLine.length; ++tileX) {
            Tile tile = cacheLine[tileX];
            rawSampleOFLine[tileX] = tile.getRawSamples();
            tileWidth[tileX] = tile.getRectangle().width;
        }
        ProductData sampleLine = ProductData.createInstance((int)rawSampleOFLine[0].getType(), (int)sceneWidth);
        ProductWriter productWriter = this.productWriter;
        synchronized (productWriter) {
            for (int y = lineBounds.y; y < lineBounds.y + lineBounds.height; ++y) {
                int targetPos = 0;
                for (int tileX = 0; tileX < cacheLine.length; ++tileX) {
                    Object rawSamples = rawSampleOFLine[tileX].getElems();
                    int width = tileWidth[tileX];
                    int srcPos = (y - lineBounds.y) * width;
                    System.arraycopy(rawSamples, srcPos, sampleLine.getElems(), targetPos, width);
                    targetPos += width;
                }
                this.productWriter.writeBandRasterData(band, 0, y, sceneWidth, 1, sampleLine, ProgressMonitor.NULL);
            }
        }
    }

    private void markTileAsHandled(Band targetBand, int tileX, int tileY) {
        int bandIndex = this.writableBands.indexOf(targetBand);
        this.tilesWritten[bandIndex][tileY][tileX] = true;
    }

    private boolean isRowWrittenCompletely(int rowNumber) {
        for (int bandIndex = 0; bandIndex < this.writableBands.size(); ++bandIndex) {
            for (boolean aYTileWritten : this.tilesWritten[bandIndex][rowNumber]) {
                if (aYTileWritten) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isProductWrittenCompletely() {
        for (int rowNumber = 0; rowNumber < this.tileCountY; ++rowNumber) {
            if (this.isRowWrittenCompletely(rowNumber)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void dispose() {
        try {
            this.productWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.writableBands.clear();
        this.writeCache.clear();
        super.dispose();
    }

    private static class Row {
        private final Band band;
        private final int tileY;

        private Row(Band band, int tileY) {
            this.band = band;
            this.tileY = tileY;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.band.hashCode();
            result = 31 * result + this.tileY;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            Row other = (Row)obj;
            if (!this.band.equals(other.band)) {
                return false;
            }
            return this.tileY == other.tileY;
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(WriteOp.class);
        }
    }
}

