/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.gpf.operators.standard;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.jexp.ParseException;
import com.bc.jexp.Term;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.simplify.DouglasPeuckerSimplifier;
import java.awt.Rectangle;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import org.esa.beam.framework.dataio.ProductReader;
import org.esa.beam.framework.dataio.ProductSubsetBuilder;
import org.esa.beam.framework.dataio.ProductSubsetDef;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.GeoCoding;
import org.esa.beam.framework.datamodel.GeoPos;
import org.esa.beam.framework.datamodel.PixelPos;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductData;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.datamodel.VirtualBand;
import org.esa.beam.framework.dataop.barithm.BandArithmetic;
import org.esa.beam.framework.dataop.barithm.RasterDataSymbol;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.annotations.Parameter;
import org.esa.beam.framework.gpf.annotations.SourceProduct;
import org.esa.beam.framework.gpf.annotations.TargetProduct;
import org.esa.beam.util.ProductUtils;
import org.esa.beam.util.converters.JtsGeometryConverter;

@OperatorMetadata(alias="Subset", category="Geometric Operations", authors="Marco Zuehlke, Norman Fomferra, Marco Peters", version="1.1", copyright="(c) 2011 by Brockmann Consult", description="Create a spatial and/or spectral subset of a data product.")
public class SubsetOp
extends Operator {
    @SourceProduct(alias="source", description="The source product to create the subset from.")
    private Product sourceProduct;
    @TargetProduct
    private Product targetProduct;
    @Parameter(description="The subset region in pixel coordinates.\nIf not given, the entire scene is used. The 'geoRegion' parameter has precedence over this parameter.")
    private Rectangle region;
    @Parameter(converter=JtsGeometryConverter.class, description="The subset region in geographical coordinates using WKT-format,\ne.g. POLYGON((<lon1> <lat1>, <lon2> <lat2>, ..., <lon1> <lat1>))\n(make sure to quote the option due to spaces in <geometry>).\nIf not given, the entire scene is used.")
    private Geometry geoRegion;
    @Parameter(defaultValue="1", description="The pixel sub-sampling step in X (horizontal image direction)")
    private int subSamplingX = 1;
    @Parameter(defaultValue="1", description="The pixel sub-sampling step in Y (vertical image direction)")
    private int subSamplingY = 1;
    @Parameter(defaultValue="false", description="Forces the operator to extend the subset region to the full swath.")
    private boolean fullSwath;
    @Parameter(description="The comma-separated list of names of tie-point grids to be copied. \nIf not given, all bands are copied.")
    private String[] tiePointGridNames;
    @Parameter(description="The comma-separated list of names of bands to be copied.\nIf not given, all bands are copied.")
    private String[] bandNames;
    @Parameter(defaultValue="false", description="Whether to copy the metadata of the source product.")
    private boolean copyMetadata;
    private transient ProductReader subsetReader;

    public String[] getTiePointGridNames() {
        return this.tiePointGridNames != null ? (String[])this.tiePointGridNames.clone() : null;
    }

    public void setTiePointGridNames(String[] tiePointGridNames) {
        this.tiePointGridNames = tiePointGridNames != null ? (String[])tiePointGridNames.clone() : null;
    }

    public String[] getBandNames() {
        return this.bandNames != null ? (String[])this.bandNames.clone() : null;
    }

    public void setBandNames(String[] bandNames) {
        this.bandNames = bandNames != null ? (String[])bandNames.clone() : null;
    }

    public void setCopyMetadata(boolean copyMetadata) {
        this.copyMetadata = copyMetadata;
    }

    public Rectangle getRegion() {
        return this.region != null ? new Rectangle(this.region) : null;
    }

    public void setRegion(Rectangle region) {
        this.region = region != null ? new Rectangle(region) : null;
    }

    public void setSubSamplingX(int subSamplingX) {
        this.subSamplingX = subSamplingX;
    }

    public void setSubSamplingY(int subSamplingY) {
        this.subSamplingY = subSamplingY;
    }

    public Geometry getGeoRegion() {
        return this.geoRegion;
    }

    public void setGeoRegion(Geometry geoRegion) {
        this.geoRegion = geoRegion;
    }

    @Override
    public void initialize() throws OperatorException {
        this.subsetReader = new ProductSubsetBuilder();
        ProductSubsetDef subsetDef = new ProductSubsetDef();
        if (this.tiePointGridNames != null) {
            subsetDef.addNodeNames(this.tiePointGridNames);
        } else {
            subsetDef.addNodeNames(this.sourceProduct.getTiePointGridNames());
        }
        if (this.bandNames != null) {
            subsetDef.addNodeNames(this.bandNames);
        } else {
            subsetDef.addNodeNames(this.sourceProduct.getBandNames());
        }
        String[] nodeNames = subsetDef.getNodeNames();
        if (nodeNames != null) {
            ArrayList<String> referencedNodeNames = new ArrayList<String>();
            for (String nodeName : nodeNames) {
                this.collectReferencedRasters(nodeName, referencedNodeNames);
            }
            subsetDef.addNodeNames(referencedNodeNames.toArray(new String[referencedNodeNames.size()]));
        }
        if (this.geoRegion != null) {
            this.region = SubsetOp.computePixelRegion(this.sourceProduct, this.geoRegion, 0);
        }
        if (this.fullSwath) {
            this.region = new Rectangle(0, this.region.y, this.sourceProduct.getSceneRasterWidth(), this.region.height);
        }
        if (this.region != null) {
            if (this.region.isEmpty()) {
                throw new OperatorException("No intersection with source product boundary.");
            }
            subsetDef.setRegion(this.region);
        }
        subsetDef.setSubSampling(this.subSamplingX, this.subSamplingY);
        subsetDef.setIgnoreMetadata(!this.copyMetadata);
        try {
            this.targetProduct = this.subsetReader.readProductNodes((Object)this.sourceProduct, subsetDef);
        }
        catch (Throwable t) {
            throw new OperatorException(t);
        }
    }

    private void collectReferencedRasters(String nodeName, ArrayList<String> referencedNodeNames) {
        RasterDataNode rasterDataNode = this.sourceProduct.getRasterDataNode(nodeName);
        if (rasterDataNode == null) {
            throw new OperatorException(String.format("Source product does not contain a raster named '%s'.", nodeName));
        }
        String validPixelExpression = rasterDataNode.getValidPixelExpression();
        this.collectReferencedRastersInExpression(validPixelExpression, referencedNodeNames);
        if (rasterDataNode instanceof VirtualBand) {
            VirtualBand vBand = (VirtualBand)rasterDataNode;
            this.collectReferencedRastersInExpression(vBand.getExpression(), referencedNodeNames);
        }
    }

    private void collectReferencedRastersInExpression(String expression, ArrayList<String> referencedNodeNames) {
        if (expression == null || expression.trim().isEmpty()) {
            return;
        }
        try {
            Term term = this.sourceProduct.parseExpression(expression);
            RasterDataSymbol[] refRasterDataSymbols = BandArithmetic.getRefRasterDataSymbols((Term)term);
            RasterDataNode[] refRasters = BandArithmetic.getRefRasters((RasterDataSymbol[])refRasterDataSymbols);
            if (refRasters.length > 0) {
                for (RasterDataNode refRaster : refRasters) {
                    String refNodeName = refRaster.getName();
                    if (referencedNodeNames.contains(refNodeName)) continue;
                    referencedNodeNames.add(refNodeName);
                    this.collectReferencedRastersInExpression(refNodeName, referencedNodeNames);
                }
            }
        }
        catch (ParseException e) {
            this.getLogger().log(Level.WARNING, e.getMessage(), e);
        }
    }

    @Override
    public void computeTile(Band band, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        ProductData destBuffer = targetTile.getRawSamples();
        Rectangle rectangle = targetTile.getRectangle();
        try {
            this.subsetReader.readBandRasterData(band, rectangle.x, rectangle.y, rectangle.width, rectangle.height, destBuffer, pm);
            targetTile.setRawSamples(destBuffer);
        }
        catch (IOException e) {
            throw new OperatorException(e);
        }
    }

    public static Rectangle computePixelRegion(Product product, Geometry geoRegion, int numBorderPixels) {
        Geometry productGeometry = SubsetOp.computeProductGeometry(product);
        Geometry regionIntersection = geoRegion.intersection(productGeometry);
        if (regionIntersection.isEmpty()) {
            return new Rectangle();
        }
        PixelRegionFinder pixelRegionFinder = new PixelRegionFinder(product.getGeoCoding());
        regionIntersection.apply((CoordinateFilter)pixelRegionFinder);
        Rectangle pixelRegion = pixelRegionFinder.getPixelRegion();
        pixelRegion.grow(numBorderPixels, numBorderPixels);
        return pixelRegion.intersection(new Rectangle(product.getSceneRasterWidth(), product.getSceneRasterHeight()));
    }

    static Geometry computeProductGeometry(Product product) {
        GeneralPath[] paths = ProductUtils.createGeoBoundaryPaths((Product)product);
        Polygon[] polygons = new Polygon[paths.length];
        GeometryFactory factory = new GeometryFactory();
        for (int i = 0; i < paths.length; ++i) {
            polygons[i] = SubsetOp.convertAwtPathToJtsPolygon(paths[i], factory);
        }
        DouglasPeuckerSimplifier peuckerSimplifier = new DouglasPeuckerSimplifier((Geometry)(polygons.length == 1 ? polygons[0] : factory.createMultiPolygon(polygons)));
        return peuckerSimplifier.getResultGeometry();
    }

    private static Polygon convertAwtPathToJtsPolygon(Path2D path, GeometryFactory factory) {
        PathIterator pathIterator = path.getPathIterator(null);
        ArrayList<Object> coordList = new ArrayList<Object>();
        int lastOpenIndex = 0;
        while (!pathIterator.isDone()) {
            double[] coords = new double[6];
            int segType = pathIterator.currentSegment(coords);
            if (segType == 4) {
                coordList.add(coordList.get(lastOpenIndex));
                lastOpenIndex = coordList.size();
            } else {
                coordList.add(coords);
            }
            pathIterator.next();
        }
        Coordinate[] coordinates = new Coordinate[coordList.size()];
        for (int i1 = 0; i1 < coordinates.length; ++i1) {
            double[] coord = (double[])coordList.get(i1);
            coordinates[i1] = new Coordinate(coord[0], coord[1]);
        }
        return factory.createPolygon(factory.createLinearRing(coordinates), null);
    }

    private static class PixelRegionFinder
    implements CoordinateFilter {
        private final GeoCoding geoCoding;
        private int x1;
        private int y1;
        private int x2;
        private int y2;

        private PixelRegionFinder(GeoCoding geoCoding) {
            this.geoCoding = geoCoding;
            this.x1 = Integer.MAX_VALUE;
            this.x2 = Integer.MIN_VALUE;
            this.y1 = Integer.MAX_VALUE;
            this.y2 = Integer.MIN_VALUE;
        }

        public void filter(Coordinate coordinate) {
            GeoPos geoPos = new GeoPos((float)coordinate.y, (float)coordinate.x);
            PixelPos pixelPos = this.geoCoding.getPixelPos(geoPos, null);
            if (pixelPos.isValid()) {
                this.x1 = Math.min(this.x1, (int)Math.floor(pixelPos.x));
                this.x2 = Math.max(this.x2, (int)Math.ceil(pixelPos.x));
                this.y1 = Math.min(this.y1, (int)Math.floor(pixelPos.y));
                this.y2 = Math.max(this.y2, (int)Math.ceil(pixelPos.y));
            }
        }

        public Rectangle getPixelRegion() {
            return new Rectangle(this.x1, this.y1, this.x2 - this.x1, this.y2 - this.y1);
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(SubsetOp.class);
        }
    }
}

