/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.gpf.ui;

import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.selection.SelectionChangeListener;
import com.bc.ceres.swing.selection.support.ComboBoxSelectionContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import javax.accessibility.Accessible;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileFilter;
import org.esa.beam.framework.dataio.ProductIO;
import org.esa.beam.framework.dataio.ProductIOPlugInManager;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductFilter;
import org.esa.beam.framework.datamodel.ProductManager;
import org.esa.beam.framework.ui.AppContext;
import org.esa.beam.util.SystemUtils;
import org.esa.beam.util.io.BeamFileChooser;
import org.esa.beam.util.io.BeamFileFilter;

public class SourceProductSelector {
    private AppContext appContext;
    private ProductFilter productFilter;
    private Product extraProduct;
    private File currentDirectory;
    private DefaultComboBoxModel<Object> productListModel;
    private JLabel productNameLabel;
    private JButton productFileChooserButton;
    private JComboBox<Object> productNameComboBox;
    private final ProductManager.Listener productManagerListener;
    private ComboBoxSelectionContext selectionContext;

    public SourceProductSelector(AppContext appContext) {
        this(appContext, "Name:");
    }

    public SourceProductSelector(AppContext appContext, String labelText) {
        this.appContext = appContext;
        this.productListModel = new DefaultComboBoxModel();
        this.productNameLabel = new JLabel(labelText);
        this.productFileChooserButton = new JButton(new ProductFileChooserAction());
        Dimension size = new Dimension(26, 16);
        this.productFileChooserButton.setPreferredSize(size);
        this.productFileChooserButton.setMinimumSize(size);
        this.productNameComboBox = new JComboBox<Object>(this.productListModel);
        this.productNameComboBox.setPrototypeDisplayValue("[1] 123456789 123456789 12345");
        this.productNameComboBox.setRenderer(new ProductListCellRenderer());
        this.productNameComboBox.addPopupMenuListener(new ProductPopupMenuListener());
        this.productNameComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Product product = (Product)SourceProductSelector.this.productNameComboBox.getSelectedItem();
                if (product != null) {
                    if (product.getFileLocation() != null) {
                        SourceProductSelector.this.productNameComboBox.setToolTipText(product.getFileLocation().getPath());
                    } else {
                        SourceProductSelector.this.productNameComboBox.setToolTipText(product.getDisplayName());
                    }
                } else {
                    SourceProductSelector.this.productNameComboBox.setToolTipText("Select a source product.");
                }
            }
        });
        this.productFilter = ProductFilter.ALL;
        this.selectionContext = new ComboBoxSelectionContext(this.productNameComboBox);
        this.productManagerListener = new ProductManager.Listener(){

            public void productAdded(ProductManager.Event event) {
                SourceProductSelector.this.addProduct(event.getProduct());
            }

            public void productRemoved(ProductManager.Event event) {
                Product product = event.getProduct();
                if (SourceProductSelector.this.productListModel.getSelectedItem() == product) {
                    SourceProductSelector.this.productListModel.setSelectedItem(null);
                }
                SourceProductSelector.this.productListModel.removeElement(product);
            }
        };
    }

    public ProductFilter getProductFilter() {
        return this.productFilter;
    }

    public void setProductFilter(ProductFilter productFilter) {
        this.productFilter = productFilter;
    }

    public synchronized void initProducts() {
        this.productListModel.removeAllElements();
        for (Product product : this.appContext.getProductManager().getProducts()) {
            this.addProduct(product);
        }
        Product selectedProduct = this.appContext.getSelectedProduct();
        if (selectedProduct != null && this.productFilter.accept(selectedProduct)) {
            this.productListModel.setSelectedItem(selectedProduct);
        }
        this.appContext.getProductManager().addListener(this.productManagerListener);
    }

    public int getProductCount() {
        return this.productListModel.getSize();
    }

    public void setSelectedIndex(int index) {
        this.productListModel.setSelectedItem(this.productListModel.getElementAt(index));
    }

    public Product getSelectedProduct() {
        return (Product)this.productListModel.getSelectedItem();
    }

    public void setCurrentDirectory(File directory) {
        if (directory != null && directory.isDirectory()) {
            this.currentDirectory = directory;
        }
    }

    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setSelectedProduct(Product product) {
        if (product == null) {
            this.productListModel.setSelectedItem(null);
            return;
        }
        if (this.productListModelContains(product)) {
            this.productListModel.setSelectedItem(product);
        } else if (this.productFilter.accept(product)) {
            if (this.extraProduct != null) {
                this.productListModel.removeElement(this.extraProduct);
                this.extraProduct.dispose();
            }
            this.productListModel.addElement(product);
            this.productListModel.setSelectedItem(product);
            this.extraProduct = product;
        }
    }

    public synchronized void releaseProducts() {
        this.appContext.getProductManager().removeListener(this.productManagerListener);
        if (this.extraProduct != null && this.getSelectedProduct() != this.extraProduct) {
            this.extraProduct.dispose();
        }
        this.extraProduct = null;
        this.productListModel.removeAllElements();
    }

    public void addSelectionChangeListener(SelectionChangeListener listener) {
        this.selectionContext.addSelectionChangeListener(listener);
    }

    public void removeSelectionChangeListener(SelectionChangeListener listener) {
        this.selectionContext.removeSelectionChangeListener(listener);
    }

    private void addProduct(Product product) {
        if (this.productFilter.accept(product)) {
            this.productListModel.addElement(product);
        }
    }

    public JComboBox<Object> getProductNameComboBox() {
        return this.productNameComboBox;
    }

    public JLabel getProductNameLabel() {
        return this.productNameLabel;
    }

    public JButton getProductFileChooserButton() {
        return this.productFileChooserButton;
    }

    private boolean productListModelContains(Product product) {
        for (int i = 0; i < this.productListModel.getSize(); ++i) {
            if (!this.productListModel.getElementAt(i).equals(product)) continue;
            return true;
        }
        return false;
    }

    public JPanel createDefaultPanel() {
        JPanel subPanel = new JPanel(new BorderLayout(3, 3));
        subPanel.add(this.getProductNameComboBox(), "Center");
        subPanel.add((Component)this.getProductFileChooserButton(), "East");
        TableLayout tableLayout = new TableLayout(1);
        tableLayout.setTableAnchor(TableLayout.Anchor.WEST);
        tableLayout.setTableWeightX(Double.valueOf(1.0));
        tableLayout.setRowFill(0, TableLayout.Fill.HORIZONTAL);
        tableLayout.setRowFill(1, TableLayout.Fill.HORIZONTAL);
        tableLayout.setTablePadding(3, 3);
        JPanel panel = new JPanel((LayoutManager)tableLayout);
        panel.setBorder(BorderFactory.createTitledBorder("Source Product"));
        panel.add(this.getProductNameLabel());
        panel.add(subPanel);
        panel.add(tableLayout.createVerticalSpacer());
        return panel;
    }

    private static class ProductPopupMenuListener
    implements PopupMenuListener {
        private ProductPopupMenuListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            JComboBox box = (JComboBox)e.getSource();
            Accessible comp = box.getUI().getAccessibleChild(box, 0);
            if (!(comp instanceof JPopupMenu)) {
                return;
            }
            JComponent scrollPane = (JComponent)((JPopupMenu)comp).getComponent(0);
            Dimension size = new Dimension();
            size.width = scrollPane.getPreferredSize().width;
            int boxItemCount = box.getModel().getSize();
            for (int i = 0; i < boxItemCount; ++i) {
                Product product = (Product)box.getModel().getElementAt(i);
                JLabel label = new JLabel();
                label.setText(product.getDisplayName());
                size.width = Math.max(label.getPreferredSize().width, size.width);
            }
            size.height = scrollPane.getPreferredSize().height;
            scrollPane.setPreferredSize(size);
            scrollPane.setMaximumSize(size);
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }
    }

    private static class ProductListCellRenderer
    extends DefaultListCellRenderer {
        private ProductListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component cellRendererComponent = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (cellRendererComponent instanceof JLabel && value instanceof Product) {
                JLabel label = (JLabel)cellRendererComponent;
                Product product = (Product)value;
                label.setText(product.getDisplayName());
            }
            return cellRendererComponent;
        }
    }

    private class ProductFileChooserAction
    extends AbstractAction {
        private String APPROVE_BUTTON_TEXT;
        private JFileChooser chooser;

        private ProductFileChooserAction() {
            super("...");
            this.APPROVE_BUTTON_TEXT = "Select";
            this.chooser = new BeamFileChooser();
            this.chooser.setDialogTitle("Select Source Product");
            Iterator iterator = ProductIOPlugInManager.getInstance().getAllReaderPlugIns();
            List sortedFileFilters = BeamFileFilter.getSortedFileFilters((Iterator)iterator);
            for (BeamFileFilter fileFilter : sortedFileFilters) {
                this.chooser.addChoosableFileFilter((FileFilter)fileFilter);
            }
            this.chooser.setAcceptAllFileFilterUsed(true);
            this.chooser.setFileFilter(this.chooser.getAcceptAllFileFilter());
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Window window = SwingUtilities.getWindowAncestor((JComponent)event.getSource());
            String homeDirPath = SystemUtils.getUserHomeDir().getPath();
            String openDir = SourceProductSelector.this.appContext.getPreferences().getPropertyString("app.file.lastOpenDir", homeDirPath);
            SourceProductSelector.this.currentDirectory = new File(openDir);
            this.chooser.setCurrentDirectory(SourceProductSelector.this.currentDirectory);
            if (this.chooser.showDialog(window, this.APPROVE_BUTTON_TEXT) == 0) {
                File file = this.chooser.getSelectedFile();
                Product product = null;
                try {
                    product = ProductIO.readProduct((File)file);
                    if (product == null) {
                        throw new IOException(MessageFormat.format("File ''{0}'' could not be read.", file.getPath()));
                    }
                    if (SourceProductSelector.this.productFilter.accept(product)) {
                        SourceProductSelector.this.setSelectedProduct(product);
                    } else {
                        String message = String.format("Product [%s] is not a valid source.", product.getFileLocation().getCanonicalPath());
                        this.handleError(window, message);
                        product.dispose();
                    }
                }
                catch (IOException e) {
                    this.handleError(window, e.getMessage());
                }
                catch (Exception e) {
                    if (product != null) {
                        product.dispose();
                    }
                    this.handleError(window, e.getMessage());
                    e.printStackTrace();
                }
                SourceProductSelector.this.currentDirectory = this.chooser.getCurrentDirectory();
                SourceProductSelector.this.appContext.getPreferences().setPropertyString("app.file.lastOpenDir", SourceProductSelector.this.currentDirectory.getAbsolutePath());
            }
        }

        private void handleError(final Component component, final String message) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(component, message, "Error", 0);
                }
            });
        }
    }
}

