/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.gpf.ui;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.PropertyPane;
import com.bc.ceres.swing.selection.AbstractSelectionChangeListener;
import com.bc.ceres.swing.selection.Selection;
import com.bc.ceres.swing.selection.SelectionChangeEvent;
import com.bc.ceres.swing.selection.SelectionChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.ProductNodeEvent;
import org.esa.beam.framework.datamodel.ProductNodeListener;
import org.esa.beam.framework.gpf.GPF;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.descriptor.OperatorDescriptor;
import org.esa.beam.framework.gpf.internal.RasterDataNodeValues;
import org.esa.beam.framework.gpf.ui.DefaultIOParametersPanel;
import org.esa.beam.framework.gpf.ui.OperatorMenu;
import org.esa.beam.framework.gpf.ui.OperatorParameterSupport;
import org.esa.beam.framework.gpf.ui.SingleTargetProductDialog;
import org.esa.beam.framework.gpf.ui.SourceProductSelector;
import org.esa.beam.framework.gpf.ui.TargetProductSelectorModel;
import org.esa.beam.framework.ui.AppContext;

public class DefaultSingleTargetProductDialog
extends SingleTargetProductDialog {
    private final String operatorName;
    private final OperatorDescriptor operatorDescriptor;
    private DefaultIOParametersPanel ioParametersPanel;
    private final OperatorParameterSupport parameterSupport;
    private final BindingContext bindingContext;
    private JTabbedPane form;
    private PropertyDescriptor[] rasterDataNodeTypeProperties;
    private String targetProductNameSuffix;
    private ProductChangedHandler productChangedHandler;

    public static SingleTargetProductDialog createDefaultDialog(String operatorName, AppContext appContext) {
        return new DefaultSingleTargetProductDialog(operatorName, appContext, operatorName, null);
    }

    public DefaultSingleTargetProductDialog(String operatorName, AppContext appContext, String title, String helpID) {
        super(appContext, title, 24, helpID);
        this.operatorName = operatorName;
        this.targetProductNameSuffix = "";
        OperatorSpi operatorSpi = GPF.getDefaultInstance().getOperatorSpiRegistry().getOperatorSpi(operatorName);
        if (operatorSpi == null) {
            throw new IllegalArgumentException("No SPI found for operator name '" + operatorName + "'");
        }
        this.operatorDescriptor = operatorSpi.getOperatorDescriptor();
        this.ioParametersPanel = new DefaultIOParametersPanel(this.getAppContext(), this.operatorDescriptor, this.getTargetProductSelector());
        this.parameterSupport = new OperatorParameterSupport(this.operatorDescriptor);
        ArrayList<SourceProductSelector> sourceProductSelectorList = this.ioParametersPanel.getSourceProductSelectorList();
        PropertySet propertySet = this.parameterSupport.getPropertySet();
        this.bindingContext = new BindingContext(propertySet);
        if (propertySet.getProperties().length > 0 && !sourceProductSelectorList.isEmpty()) {
            Property[] properties = propertySet.getProperties();
            ArrayList<PropertyDescriptor> rdnTypeProperties = new ArrayList<PropertyDescriptor>(properties.length);
            for (Property property : properties) {
                PropertyDescriptor parameterDescriptor = property.getDescriptor();
                if (parameterDescriptor.getAttribute("rasterDataNodeType") == null) continue;
                rdnTypeProperties.add(parameterDescriptor);
            }
            this.rasterDataNodeTypeProperties = rdnTypeProperties.toArray(new PropertyDescriptor[rdnTypeProperties.size()]);
        }
        this.productChangedHandler = new ProductChangedHandler();
        if (!sourceProductSelectorList.isEmpty()) {
            sourceProductSelectorList.get(0).addSelectionChangeListener((SelectionChangeListener)this.productChangedHandler);
        }
    }

    public int show() {
        this.ioParametersPanel.initSourceProductSelectors();
        if (this.form == null) {
            this.initForm();
            if (this.getJDialog().getJMenuBar() == null) {
                OperatorMenu operatorMenu = this.createDefaultMenuBar();
                this.getJDialog().setJMenuBar(operatorMenu.createDefaultMenu());
            }
        }
        this.setContent(this.form);
        return super.show();
    }

    public void hide() {
        this.productChangedHandler.releaseProduct();
        this.ioParametersPanel.releaseSourceProductSelectors();
        super.hide();
    }

    @Override
    protected Product createTargetProduct() throws Exception {
        HashMap<String, Product> sourceProducts = this.ioParametersPanel.createSourceProductsMap();
        return GPF.createProduct(this.operatorName, this.parameterSupport.getParameterMap(), sourceProducts);
    }

    public String getTargetProductNameSuffix() {
        return this.targetProductNameSuffix;
    }

    public void setTargetProductNameSuffix(String suffix) {
        this.targetProductNameSuffix = suffix;
    }

    public BindingContext getBindingContext() {
        return this.bindingContext;
    }

    private void initForm() {
        this.form = new JTabbedPane();
        this.form.add("I/O Parameters", this.ioParametersPanel);
        if (this.bindingContext.getPropertySet().getProperties().length > 0) {
            PropertyPane parametersPane = new PropertyPane(this.bindingContext);
            JPanel parametersPanel = parametersPane.createPanel();
            parametersPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
            this.form.add("Processing Parameters", new JScrollPane(parametersPanel));
            this.updateSourceProduct();
        }
    }

    private OperatorMenu createDefaultMenuBar() {
        return new OperatorMenu(this.getJDialog(), this.operatorDescriptor, this.parameterSupport, this.getAppContext(), this.getHelpID());
    }

    private void updateSourceProduct() {
        try {
            Property property = this.bindingContext.getPropertySet().getProperty("SOURCE_PRODUCT");
            if (property != null) {
                property.setValue((Object)this.productChangedHandler.currentProduct);
            }
        }
        catch (ValidationException e) {
            throw new IllegalStateException("Property 'SOURCE_PRODUCT' must be of type " + Product.class + ".", e);
        }
    }

    private static void updateValueSet(PropertyDescriptor propertyDescriptor, Product product) {
        Object object;
        Object[] values = new String[]{};
        if (product != null && (object = propertyDescriptor.getAttribute("rasterDataNodeType")) != null) {
            Class rasterDataNodeType = (Class)object;
            boolean includeEmptyValue = !propertyDescriptor.isNotNull() && !propertyDescriptor.isNotEmpty() && !propertyDescriptor.getType().isArray();
            values = RasterDataNodeValues.getNames(product, rasterDataNodeType, includeEmptyValue);
        }
        propertyDescriptor.setValueSet(new ValueSet(values));
    }

    private class ProductChangedHandler
    extends AbstractSelectionChangeListener
    implements ProductNodeListener {
        private Product currentProduct;

        private ProductChangedHandler() {
        }

        public void releaseProduct() {
            if (this.currentProduct != null) {
                this.currentProduct.removeProductNodeListener((ProductNodeListener)this);
                this.currentProduct = null;
                DefaultSingleTargetProductDialog.this.updateSourceProduct();
            }
        }

        public void selectionChanged(SelectionChangeEvent event) {
            Product selectedProduct;
            Selection selection = event.getSelection();
            if (selection != null && (selectedProduct = (Product)selection.getSelectedValue()) != this.currentProduct) {
                if (this.currentProduct != null) {
                    this.currentProduct.removeProductNodeListener((ProductNodeListener)this);
                }
                this.currentProduct = selectedProduct;
                if (this.currentProduct != null) {
                    this.currentProduct.addProductNodeListener((ProductNodeListener)this);
                }
                this.updateTargetProductName();
                this.updateValueSets(this.currentProduct);
                DefaultSingleTargetProductDialog.this.updateSourceProduct();
            }
        }

        public void nodeAdded(ProductNodeEvent event) {
            this.handleProductNodeEvent();
        }

        public void nodeChanged(ProductNodeEvent event) {
            this.handleProductNodeEvent();
        }

        public void nodeDataChanged(ProductNodeEvent event) {
            this.handleProductNodeEvent();
        }

        public void nodeRemoved(ProductNodeEvent event) {
            this.handleProductNodeEvent();
        }

        private void updateTargetProductName() {
            String productName = "";
            if (this.currentProduct != null) {
                productName = this.currentProduct.getName();
            }
            TargetProductSelectorModel targetProductSelectorModel = DefaultSingleTargetProductDialog.this.getTargetProductSelector().getModel();
            targetProductSelectorModel.setProductName(productName + DefaultSingleTargetProductDialog.this.getTargetProductNameSuffix());
        }

        private void handleProductNodeEvent() {
            this.updateValueSets(this.currentProduct);
        }

        private void updateValueSets(Product product) {
            if (DefaultSingleTargetProductDialog.this.rasterDataNodeTypeProperties != null) {
                for (PropertyDescriptor propertyDescriptor : DefaultSingleTargetProductDialog.this.rasterDataNodeTypeProperties) {
                    DefaultSingleTargetProductDialog.updateValueSet(propertyDescriptor, product);
                }
            }
        }
    }
}

