/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.gpf.pointop;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Point;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.pointop.PointOperator;
import org.esa.beam.framework.gpf.pointop.Sample;
import org.esa.beam.framework.gpf.pointop.WritableSample;

public abstract class SampleOperator
extends PointOperator {
    protected abstract void computeSample(int var1, int var2, Sample[] var3, WritableSample var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        Point location = new Point();
        Sample[] sourceSamples = this.createSourceSamples(targetTile.getRectangle(), location);
        WritableSample targetSample = this.createTargetSample(targetTile, location);
        int x1 = targetTile.getMinX();
        int y1 = targetTile.getMinY();
        int x2 = targetTile.getMaxX();
        int y2 = targetTile.getMaxY();
        try {
            pm.beginTask(this.getId(), targetTile.getHeight());
            location.y = y1;
            while (location.y <= y2) {
                location.x = x1;
                while (location.x <= x2) {
                    this.computeSample(location.x, location.y, sourceSamples, targetSample);
                    ++location.x;
                }
                pm.worked(1);
                ++location.y;
            }
        }
        finally {
            pm.done();
        }
    }
}

