/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.gpf;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.CoreException;
import com.bc.ceres.core.runtime.Module;
import com.bc.ceres.core.runtime.internal.ModuleReader;
import java.awt.RenderingHints;
import java.net.URL;
import java.util.Map;
import java.util.logging.Logger;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.gpf.Operator;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.annotations.OperatorMetadata;
import org.esa.beam.framework.gpf.descriptor.AnnotationOperatorDescriptor;
import org.esa.beam.framework.gpf.descriptor.AnnotationOperatorDescriptorBody;
import org.esa.beam.framework.gpf.descriptor.DefaultOperatorDescriptor;
import org.esa.beam.framework.gpf.descriptor.OperatorDescriptor;
import org.esa.beam.framework.gpf.descriptor.ParameterDescriptor;
import org.esa.beam.framework.gpf.descriptor.SourceProductDescriptor;
import org.esa.beam.framework.gpf.descriptor.SourceProductsDescriptor;
import org.esa.beam.framework.gpf.descriptor.TargetProductDescriptor;
import org.esa.beam.framework.gpf.descriptor.TargetPropertyDescriptor;

public abstract class OperatorSpi {
    private final OperatorDescriptor operatorDescriptor;
    private final String operatorAlias;
    private Module module;

    protected OperatorSpi(OperatorDescriptor operatorDescriptor) {
        Assert.notNull((Object)operatorDescriptor, (String)"operatorDescriptor");
        this.operatorDescriptor = operatorDescriptor;
        this.operatorAlias = operatorDescriptor.getAlias();
        Assert.notNull((Object)this.operatorAlias, (String)"operatorAlias");
    }

    protected OperatorSpi(URL operatorDescriptorUrl) {
        this(DefaultOperatorDescriptor.fromXml(operatorDescriptorUrl, DefaultOperatorDescriptor.class.getClassLoader()));
    }

    protected OperatorSpi(Class<? extends Operator> operatorClass) {
        this(operatorClass, OperatorSpi.getOperatorAlias(operatorClass));
    }

    @Deprecated
    protected OperatorSpi(Class<? extends Operator> operatorClass, String operatorAlias) {
        Assert.notNull(operatorClass, (String)"operatorClass");
        Assert.notNull((Object)operatorAlias, (String)"operatorAlias");
        OperatorMetadata annotation = operatorClass.getAnnotation(OperatorMetadata.class);
        this.operatorDescriptor = annotation != null ? new AnnotationOperatorDescriptor(operatorClass, annotation) : new NoMetadataOperatorDescriptor(operatorClass, operatorAlias);
        this.operatorAlias = operatorAlias;
    }

    public Operator createOperator() throws OperatorException {
        try {
            Operator operator = this.getOperatorClass().newInstance();
            operator.setSpi(this);
            operator.setParameterDefaultValues();
            return operator;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new OperatorException(e);
        }
    }

    public Operator createOperator(Map<String, Object> parameters, Map<String, Product> sourceProducts) throws OperatorException {
        return this.createOperator(parameters, sourceProducts, null);
    }

    public Operator createOperator(Map<String, Object> parameters, Map<String, Product> sourceProducts, RenderingHints renderingHints) throws OperatorException {
        Operator operator = this.createOperator();
        operator.context.setSourceProducts(sourceProducts);
        operator.context.setParameterMap(parameters);
        if (renderingHints != null) {
            operator.context.addRenderingHints(renderingHints);
        }
        return operator;
    }

    public final Class<? extends Operator> getOperatorClass() {
        return this.operatorDescriptor.getOperatorClass();
    }

    public final String getOperatorAlias() {
        if (this.operatorAlias != null && !this.operatorAlias.isEmpty()) {
            return this.operatorAlias;
        }
        return this.operatorDescriptor.getAlias();
    }

    public Module getModule() {
        if (this.module == null) {
            this.module = this.loadModule();
        }
        return this.module;
    }

    public OperatorDescriptor getOperatorDescriptor() {
        return this.operatorDescriptor;
    }

    public static String getOperatorAlias(Class<? extends Operator> operatorClass) {
        OperatorMetadata annotation = operatorClass.getAnnotation(OperatorMetadata.class);
        if (annotation != null && !annotation.alias().isEmpty()) {
            return annotation.alias();
        }
        return operatorClass.getSimpleName();
    }

    private Module loadModule() {
        ModuleReader moduleReader = new ModuleReader(Logger.getAnonymousLogger());
        URL moduleLocation = this.getOperatorDescriptor().getOperatorClass().getProtectionDomain().getCodeSource().getLocation();
        try {
            return moduleReader.readFromLocation(moduleLocation);
        }
        catch (CoreException e) {
            Logger.getAnonymousLogger().warning("Could not read " + moduleLocation.toString());
            return null;
        }
    }

    private static class NoMetadataOperatorDescriptor
    implements OperatorDescriptor {
        private final AnnotationOperatorDescriptorBody body;
        private final String operatorAlias;

        public NoMetadataOperatorDescriptor(Class<? extends Operator> operatorClass, String operatorAlias) {
            this.body = new AnnotationOperatorDescriptorBody(operatorClass);
            this.operatorAlias = operatorAlias;
        }

        @Override
        public String getName() {
            return this.body.getOperatorClass().getName();
        }

        @Override
        public String getAlias() {
            return this.operatorAlias;
        }

        @Override
        public Class<? extends Operator> getOperatorClass() {
            return this.body.getOperatorClass();
        }

        @Override
        public String getVersion() {
            return null;
        }

        @Override
        public String getAuthors() {
            return null;
        }

        @Override
        public String getCopyright() {
            return null;
        }

        @Override
        public boolean isInternal() {
            return false;
        }

        @Override
        public boolean isAutoWriteDisabled() {
            return false;
        }

        @Override
        public String getLabel() {
            return null;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public SourceProductDescriptor[] getSourceProductDescriptors() {
            return this.body.getSourceProductDescriptors();
        }

        @Override
        public SourceProductsDescriptor getSourceProductsDescriptor() {
            return this.body.getSourceProductsDescriptor();
        }

        @Override
        public TargetProductDescriptor getTargetProductDescriptor() {
            return this.body.getTargetProductDescriptor();
        }

        @Override
        public TargetPropertyDescriptor[] getTargetPropertyDescriptors() {
            return this.body.getTargetPropertyDescriptors();
        }

        @Override
        public ParameterDescriptor[] getParameterDescriptors() {
            return this.body.getParameterDescriptors();
        }
    }
}

