/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.framework.gpf;

import com.bc.ceres.core.Assert;
import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.text.MessageFormat;
import java.util.Map;
import java.util.logging.Logger;
import javax.media.jai.BorderExtender;
import org.esa.beam.framework.datamodel.Band;
import org.esa.beam.framework.datamodel.Product;
import org.esa.beam.framework.datamodel.RasterDataNode;
import org.esa.beam.framework.gpf.OperatorException;
import org.esa.beam.framework.gpf.OperatorSpi;
import org.esa.beam.framework.gpf.Tile;
import org.esa.beam.framework.gpf.internal.OperatorContext;

public abstract class Operator {
    final OperatorContext context = new OperatorContext(this);

    protected Operator() {
    }

    public void setParameterDefaultValues() {
        this.context.getParameterSet().setDefaultValues();
    }

    protected final void finalize() throws Throwable {
        this.context.dispose();
        super.finalize();
    }

    public abstract void initialize() throws OperatorException;

    public void update() {
        this.context.updateOperator();
    }

    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        throw new RuntimeException(MessageFormat.format("{0}: ''computeTile()'' method not implemented", this.getClass().getSimpleName()));
    }

    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        throw new RuntimeException(MessageFormat.format("{0}: ''computeTileStack()'' method not implemented", this.getClass().getSimpleName()));
    }

    public void dispose() {
    }

    protected final void deactivateComputeTileMethod() throws IllegalStateException {
        if (!this.context.isComputeTileStackMethodUsable()) {
            throw new IllegalStateException("!context.isComputeTileStackMethodUsable()");
        }
        this.context.setComputeTileMethodUsable(false);
    }

    protected final void setRequiresAllBands(boolean requiresAllBands) {
        this.context.setRequiresAllBands(requiresAllBands);
    }

    public final String getId() {
        return this.context.getId();
    }

    public final Product[] getSourceProducts() {
        return this.context.getSourceProducts();
    }

    public final void setSourceProducts(Product ... products) {
        Assert.notNull((Object)products, (String)"products");
        this.context.setSourceProducts(products);
    }

    public Product getSourceProduct() {
        Product product = this.getSourceProduct("sourceProduct");
        if (product != null) {
            return product;
        }
        Product[] products = this.getSourceProducts();
        if (products.length > 0) {
            return products[0];
        }
        return null;
    }

    public void setSourceProduct(Product sourceProduct) {
        this.setSourceProduct("sourceProduct", sourceProduct);
    }

    public final Product getSourceProduct(String id) {
        Assert.notNull((Object)id, (String)"id");
        return this.context.getSourceProduct(id);
    }

    public final void setSourceProduct(String id, Product product) {
        Assert.notNull((Object)id, (String)"id");
        Assert.notNull((Object)product, (String)"product");
        this.context.setSourceProduct(id, product);
    }

    public final String getSourceProductId(Product product) {
        Assert.notNull((Object)product, (String)"product");
        return this.context.getSourceProductId(product);
    }

    public final Product getTargetProduct() throws OperatorException {
        return this.context.getTargetProduct();
    }

    public final void setTargetProduct(Product targetProduct) {
        this.context.setTargetProduct(targetProduct);
    }

    public final Object getTargetProperty(String name) throws OperatorException {
        return this.context.getTargetProperty(name);
    }

    public Object getParameter(String name) {
        return this.context.getParameter(name);
    }

    public Object getParameter(String name, Object defaultValue) {
        Object parameter = this.context.getParameter(name);
        return parameter != null ? parameter : defaultValue;
    }

    public void setParameter(String name, Object value) {
        this.context.setParameter(name, value);
    }

    public final Tile getSourceTile(RasterDataNode rasterDataNode, Rectangle region) throws OperatorException {
        return this.context.getSourceTile(rasterDataNode, region);
    }

    public final Tile getSourceTile(RasterDataNode rasterDataNode, Rectangle region, BorderExtender borderExtender) throws OperatorException {
        return this.context.getSourceTile(rasterDataNode, region, borderExtender);
    }

    protected final void checkForCancellation() throws OperatorException {
        this.context.checkForCancellation();
    }

    public final Logger getLogger() {
        return this.context.getLogger();
    }

    public void stopTileComputationObservation() {
        this.context.stopTileComputationObservation();
    }

    public final void setLogger(Logger logger) {
        Assert.notNull((Object)logger, (String)"logger");
        this.context.setLogger(logger);
    }

    public final OperatorSpi getSpi() {
        return this.context.getOperatorSpi();
    }

    public final void setSpi(OperatorSpi operatorSpi) {
        Assert.notNull((Object)operatorSpi, (String)"operatorSpi");
        Assert.argument((boolean)operatorSpi.getOperatorClass().isAssignableFrom(this.getClass()), (String)"operatorSpi");
        this.context.setOperatorSpi(operatorSpi);
    }
}

