/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.ui;

import com.bc.ceres.swing.TableLayout;
import com.bc.ceres.swing.selection.SelectionChangeListener;
import com.bc.ceres.swing.selection.support.ComboBoxSelectionContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.accessibility.Accessible;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileFilter;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.dataio.ProductIOPlugInManager;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductFilter;
import org.esa.snap.core.datamodel.ProductManager;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.ui.AbstractDialog;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.SnapFileChooser;
import org.openide.util.Utilities;

public class SourceProductSelector {
    private AppContext appContext;
    private ProductFilter productFilter;
    private Product extraProduct;
    private File currentDirectory;
    private DefaultComboBoxModel<Object> productListModel;
    private JLabel productNameLabel;
    private JButton productFileChooserButton;
    private JComboBox<Object> productNameComboBox;
    private final ProductManager.Listener productManagerListener;
    private ComboBoxSelectionContext selectionContext;
    private boolean enableEmptySelection;

    public SourceProductSelector(AppContext appContext) {
        this(appContext, false);
    }

    public SourceProductSelector(AppContext appContext, boolean enableEmptySelection) {
        this(appContext, "Name:", enableEmptySelection);
    }

    public SourceProductSelector(AppContext appContext, String labelText) {
        this(appContext, labelText, false);
    }

    public SourceProductSelector(AppContext appContext, String labelText, boolean enableEmptySelection) {
        this.appContext = appContext;
        this.enableEmptySelection = enableEmptySelection;
        this.productListModel = new DefaultComboBoxModel();
        this.productNameLabel = new JLabel(labelText);
        this.productFileChooserButton = new JButton(new ProductFileChooserAction());
        Dimension size = new Dimension(26, 16);
        this.productFileChooserButton.setPreferredSize(size);
        this.productFileChooserButton.setMinimumSize(size);
        this.productNameComboBox = new JComboBox<Object>(this.productListModel);
        this.productNameComboBox.setPrototypeDisplayValue("[1] 123456789 123456789 12345");
        this.productNameComboBox.setRenderer(new ProductListCellRenderer());
        this.productNameComboBox.addPopupMenuListener(new ProductPopupMenuListener());
        this.productNameComboBox.addActionListener(e -> {
            Object selected = this.productNameComboBox.getSelectedItem();
            if (selected != null && selected instanceof Product) {
                Product product = (Product)selected;
                if (product.getFileLocation() != null) {
                    this.productNameComboBox.setToolTipText(product.getFileLocation().getPath());
                } else {
                    this.productNameComboBox.setToolTipText(product.getDisplayName());
                }
            } else {
                this.productNameComboBox.setToolTipText("Select a source product.");
            }
        });
        this.productFilter = ProductFilter.ALL;
        this.selectionContext = new ComboBoxSelectionContext(this.productNameComboBox);
        this.productManagerListener = new ProductManager.Listener(){

            public void productAdded(ProductManager.Event event) {
                SourceProductSelector.this.addProduct(event.getProduct());
            }

            public void productRemoved(ProductManager.Event event) {
                Product product = event.getProduct();
                if (SourceProductSelector.this.productListModel.getSelectedItem() == product) {
                    SourceProductSelector.this.productListModel.setSelectedItem(null);
                }
                SourceProductSelector.this.productListModel.removeElement(product);
            }
        };
    }

    public ProductFilter getProductFilter() {
        return this.productFilter;
    }

    public void setProductFilter(ProductFilter productFilter) {
        this.productFilter = productFilter;
    }

    public synchronized void initProducts() {
        this.productListModel.removeAllElements();
        if (this.enableEmptySelection) {
            this.productListModel.addElement(null);
        }
        for (Product product : this.appContext.getProductManager().getProducts()) {
            this.addProduct(product);
        }
        Product selectedProduct = this.appContext.getSelectedProduct();
        ProductNode productNode = (ProductNode)Utilities.actionsGlobalContext().lookup(ProductNode.class);
        if (productNode != null) {
            selectedProduct = productNode.getProduct();
        }
        if (this.enableEmptySelection) {
            this.productListModel.setSelectedItem(null);
        } else if (selectedProduct != null && this.productFilter.accept(selectedProduct)) {
            this.productListModel.setSelectedItem(selectedProduct);
        }
        this.appContext.getProductManager().addListener(this.productManagerListener);
    }

    public int getProductCount() {
        if (this.enableEmptySelection) {
            return this.productListModel.getSize() - 1;
        }
        return this.productListModel.getSize();
    }

    public void setSelectedIndex(int index) {
        this.productListModel.setSelectedItem(this.productListModel.getElementAt(index));
    }

    public Product getSelectedProduct() {
        return (Product)this.productListModel.getSelectedItem();
    }

    public void setCurrentDirectory(File directory) {
        if (directory != null && directory.isDirectory()) {
            this.currentDirectory = directory;
        }
    }

    public File getCurrentDirectory() {
        return this.currentDirectory;
    }

    public void setSelectedProduct(Product product) {
        if (product == null) {
            this.productListModel.setSelectedItem(null);
            return;
        }
        if (this.productListModelContains(product)) {
            this.productListModel.setSelectedItem(product);
        } else if (this.productFilter.accept(product)) {
            if (this.extraProduct != null) {
                this.productListModel.removeElement(this.extraProduct);
                this.extraProduct.dispose();
            }
            this.productListModel.addElement(product);
            this.productListModel.setSelectedItem(product);
            this.extraProduct = product;
        }
    }

    public synchronized void releaseProducts() {
        this.appContext.getProductManager().removeListener(this.productManagerListener);
        if (this.extraProduct != null && this.getSelectedProduct() != this.extraProduct) {
            this.extraProduct.dispose();
        }
        this.extraProduct = null;
        this.productListModel.removeAllElements();
    }

    public void addSelectionChangeListener(SelectionChangeListener listener) {
        this.selectionContext.addSelectionChangeListener(listener);
    }

    public void removeSelectionChangeListener(SelectionChangeListener listener) {
        this.selectionContext.removeSelectionChangeListener(listener);
    }

    private void addProduct(Product product) {
        if (this.productFilter.accept(product)) {
            this.productListModel.addElement(product);
        }
    }

    public JComboBox<Object> getProductNameComboBox() {
        return this.productNameComboBox;
    }

    public JLabel getProductNameLabel() {
        return this.productNameLabel;
    }

    public JButton getProductFileChooserButton() {
        return this.productFileChooserButton;
    }

    private boolean productListModelContains(Product product) {
        for (int i = 0; i < this.productListModel.getSize(); ++i) {
            Object listProduct = this.productListModel.getElementAt(i);
            if (listProduct == null || !listProduct.equals(product)) continue;
            return true;
        }
        return false;
    }

    public JPanel createDefaultPanel() {
        return this.createDefaultPanel("Source Product");
    }

    public JPanel createDefaultPanel(String borderTitle) {
        JPanel subPanel = new JPanel(new BorderLayout(3, 3));
        subPanel.add(this.getProductNameComboBox(), "Center");
        subPanel.add((Component)this.getProductFileChooserButton(), "East");
        TableLayout tableLayout = new TableLayout(1);
        tableLayout.setTableAnchor(TableLayout.Anchor.WEST);
        tableLayout.setTableWeightX(Double.valueOf(1.0));
        tableLayout.setRowFill(0, TableLayout.Fill.HORIZONTAL);
        tableLayout.setRowFill(1, TableLayout.Fill.HORIZONTAL);
        tableLayout.setTablePadding(3, 3);
        JPanel panel = new JPanel((LayoutManager)tableLayout);
        panel.add(this.getProductNameLabel());
        panel.add(subPanel);
        if (StringUtils.isNotNullAndNotEmpty((String)borderTitle)) {
            panel.setBorder(BorderFactory.createTitledBorder(borderTitle));
            panel.add(tableLayout.createVerticalSpacer());
        }
        return panel;
    }

    private static class ProductPopupMenuListener
    implements PopupMenuListener {
        private ProductPopupMenuListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            JComboBox box = (JComboBox)e.getSource();
            Accessible comp = box.getUI().getAccessibleChild(box, 0);
            if (!(comp instanceof JPopupMenu)) {
                return;
            }
            JComponent scrollPane = (JComponent)((JPopupMenu)comp).getComponent(0);
            Dimension size = new Dimension();
            size.width = scrollPane.getPreferredSize().width;
            int boxItemCount = box.getModel().getSize();
            for (int i = 0; i < boxItemCount; ++i) {
                JLabel label = new JLabel();
                Object elementAt = box.getModel().getElementAt(i);
                if (elementAt != null && elementAt instanceof Product) {
                    label.setText(((Product)elementAt).getDisplayName());
                }
                size.width = Math.max(label.getPreferredSize().width, size.width);
            }
            size.height = scrollPane.getPreferredSize().height;
            scrollPane.setPreferredSize(size);
            scrollPane.setMaximumSize(size);
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }
    }

    private static class ProductListCellRenderer
    extends DefaultListCellRenderer {
        private ProductListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component cellRendererComponent = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (cellRendererComponent instanceof JLabel) {
                JLabel label = (JLabel)cellRendererComponent;
                if (value instanceof Product) {
                    Product product = (Product)value;
                    label.setText(product.getDisplayName());
                } else {
                    label.setText(" ");
                }
            }
            return cellRendererComponent;
        }
    }

    private class CursorWorker
    extends SwingWorker<Product, Void> {
        private final Component window;
        private final JFileChooser chooser;
        private Cursor defaultCursor;
        private File file;

        public CursorWorker(Component window, JFileChooser chooser) {
            this.window = window;
            this.chooser = chooser;
        }

        @Override
        protected Product doInBackground() throws Exception {
            Product product = null;
            try {
                this.defaultCursor = this.window.getCursor();
                this.window.setCursor(Cursor.getPredefinedCursor(3));
                this.file = this.chooser.getSelectedFile();
                product = ProductIO.readProduct((File)this.file);
            }
            catch (IOException e) {
                this.handleError(e.getMessage());
            }
            return product;
        }

        @Override
        protected void done() {
            Product product = null;
            try {
                product = (Product)this.get();
                if (product == null) {
                    throw new IOException(MessageFormat.format("File ''{0}'' could not be read.", this.file.getPath()));
                }
                if (SourceProductSelector.this.productFilter.accept(product)) {
                    SourceProductSelector.this.setSelectedProduct(product);
                } else {
                    String message = String.format("Product [%s] is not a valid source.", product.getFileLocation().getCanonicalPath());
                    this.handleError(message);
                    product.dispose();
                }
            }
            catch (IOException | InterruptedException | ExecutionException e) {
                if (product != null) {
                    product.dispose();
                }
                this.handleError(e.getMessage());
                e.printStackTrace();
            }
            finally {
                this.window.setCursor(this.defaultCursor);
            }
        }

        private void handleError(String message) {
            SwingUtilities.invokeLater(() -> AbstractDialog.showWarningDialog((Component)this.window, (String)message, (String)"Error"));
        }
    }

    private class ProductFileChooserAction
    extends AbstractAction {
        private String APPROVE_BUTTON_TEXT;
        private JFileChooser chooser;

        private ProductFileChooserAction() {
            super("...");
            this.APPROVE_BUTTON_TEXT = "Select";
            this.chooser = new SnapFileChooser();
            this.chooser.setDialogTitle("Select Source Product");
            Iterator iterator = ProductIOPlugInManager.getInstance().getAllReaderPlugIns();
            List sortedFileFilters = SnapFileFilter.getSortedFileFilters((Iterator)iterator);
            for (SnapFileFilter fileFilter : sortedFileFilters) {
                this.chooser.addChoosableFileFilter((FileFilter)fileFilter);
            }
            this.chooser.setAcceptAllFileFilterUsed(true);
            this.chooser.setFileFilter(this.chooser.getAcceptAllFileFilter());
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Window window = SwingUtilities.getWindowAncestor((JComponent)event.getSource());
            String homeDirPath = SystemUtils.getUserHomeDir().getPath();
            String openDir = SourceProductSelector.this.appContext.getPreferences().getPropertyString("last_product_open_dir", homeDirPath);
            SourceProductSelector.this.currentDirectory = new File(openDir);
            this.chooser.setCurrentDirectory(SourceProductSelector.this.currentDirectory);
            if (this.chooser.showDialog(window, this.APPROVE_BUTTON_TEXT) == 0) {
                CursorWorker cursorWorker = new CursorWorker(window, this.chooser);
                cursorWorker.execute();
                SourceProductSelector.this.currentDirectory = this.chooser.getCurrentDirectory();
                SourceProductSelector.this.appContext.getPreferences().setPropertyString("last_product_open_dir", SourceProductSelector.this.currentDirectory.getAbsolutePath());
            }
        }
    }
}

