/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.core.gpf.ui;

import com.bc.ceres.binding.dom.DomElement;
import com.bc.ceres.binding.dom.XppDomElement;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.copy.HierarchicalStreamCopier;
import com.thoughtworks.xstream.io.xml.XppDomWriter;
import com.thoughtworks.xstream.io.xml.XppReader;
import com.thoughtworks.xstream.io.xml.xppdom.XppDom;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.lang.StringEscapeUtils;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.OperatorSpiRegistry;
import org.esa.snap.core.gpf.descriptor.OperatorDescriptor;
import org.esa.snap.core.gpf.ui.OperatorParameterSupport;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.AbstractDialog;
import org.esa.snap.ui.AppContext;
import org.esa.snap.ui.ModalDialog;
import org.esa.snap.ui.UIUtils;
import org.openide.util.HelpCtx;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;

public class OperatorMenu {
    private final Component parentComponent;
    private final OperatorParameterSupport parameterSupport;
    private final OperatorDescriptor opDescriptor;
    private final AppContext appContext;
    private final String helpId;
    private final Action loadParametersAction;
    private final Action saveParametersAction;
    private final Action displayParametersAction;
    private final Action aboutAction;
    private final String lastDirPreferenceKey;

    @Deprecated
    public OperatorMenu(Component parentComponent, Class<? extends Operator> opType, OperatorParameterSupport parameterSupport, String helpId) {
        this(parentComponent, OperatorMenu.getOperatorDescriptor(opType), parameterSupport, null, helpId);
    }

    public OperatorMenu(Component parentComponent, OperatorDescriptor opDescriptor, OperatorParameterSupport parameterSupport, AppContext appContext, String helpId) {
        this.parentComponent = parentComponent;
        this.parameterSupport = parameterSupport;
        this.opDescriptor = opDescriptor;
        this.appContext = appContext;
        this.helpId = helpId;
        this.lastDirPreferenceKey = opDescriptor.getName() + ".lastDir";
        this.loadParametersAction = new LoadParametersAction();
        this.saveParametersAction = new SaveParametersAction();
        this.displayParametersAction = new DisplayParametersAction();
        this.aboutAction = new AboutOperatorAction();
    }

    public JMenuBar createDefaultMenu() {
        JMenu fileMenu = new JMenu("File");
        fileMenu.add(this.loadParametersAction);
        fileMenu.add(this.saveParametersAction);
        fileMenu.addSeparator();
        fileMenu.add(this.displayParametersAction);
        JMenu helpMenu = new JMenu("Help");
        helpMenu.add(this.createHelpMenuItem());
        helpMenu.add(this.aboutAction);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(fileMenu);
        menuBar.add(helpMenu);
        return menuBar;
    }

    private JMenuItem createHelpMenuItem() {
        JMenuItem menuItem = new JMenuItem("Help");
        if (this.helpId != null && !this.helpId.isEmpty()) {
            menuItem.addActionListener(e -> new HelpCtx(this.helpId).display());
        } else {
            menuItem.setEnabled(false);
        }
        return menuItem;
    }

    static XppDom createDom(String xml) {
        XppDomWriter domWriter = new XppDomWriter();
        new HierarchicalStreamCopier().copy((HierarchicalStreamReader)new XppReader((Reader)new StringReader(xml), (XmlPullParser)new MXParser()), (HierarchicalStreamWriter)domWriter);
        return domWriter.getConfiguration();
    }

    static void escapeXmlElements(DomElement domElement) {
        DomElement[] children;
        String[] attributeNames;
        domElement.setValue(StringEscapeUtils.escapeXml((String)domElement.getValue()));
        for (String attributeName : attributeNames = domElement.getAttributeNames()) {
            domElement.setAttribute(attributeName, StringEscapeUtils.escapeXml((String)domElement.getAttribute(attributeName)));
        }
        for (DomElement child : children = (DomElement[])domElement.getChildren()) {
            OperatorMenu.escapeXmlElements(child);
        }
    }

    private FileNameExtensionFilter createParameterFileFilter() {
        return new FileNameExtensionFilter("GPF Parameter Files (XML)", "xml");
    }

    private void showInformationDialog(String title, Component component) {
        ModalDialog modalDialog = new ModalDialog(UIUtils.getRootWindow((Component)this.parentComponent), title, 1, null);
        modalDialog.setContent(component);
        modalDialog.show();
    }

    String getOperatorName() {
        return this.opDescriptor.getAlias() != null ? this.opDescriptor.getAlias() : this.opDescriptor.getName();
    }

    String getOperatorAboutText() {
        return OperatorMenu.makeHtmlConform(String.format("<html><h2>%s Operator</h2><table><tr><td><b>Name:</b></td><td><code>%s</code></td></tr><tr><td><b>Version:</b></td><td>%s</td></tr><tr><td><b>Full name:</b></td><td><code>%s</code></td></tr><tr><td><b>Description:</b></td><td>%s</td></tr><tr><td><b>Authors:</b></td><td>%s</td></tr><tr><td><b>Copyright:</b></td><td>%s</td></tr></table></html>", this.getOperatorName(), this.getOperatorName(), this.opDescriptor.getVersion(), this.opDescriptor.getName(), this.opDescriptor.getDescription(), this.opDescriptor.getAuthors(), this.opDescriptor.getCopyright()));
    }

    private static String makeHtmlConform(String text) {
        return text.replace("\n", "<br/>");
    }

    private static OperatorDescriptor getOperatorDescriptor(Class<? extends Operator> opType) {
        String operatorAlias = OperatorSpi.getOperatorAlias(opType);
        OperatorSpiRegistry spiRegistry = GPF.getDefaultInstance().getOperatorSpiRegistry();
        OperatorDescriptor operatorDescriptor = spiRegistry.getOperatorSpi(operatorAlias).getOperatorDescriptor();
        if (operatorDescriptor == null) {
            Class<?>[] declaredClasses;
            for (Class<?> declaredClass : declaredClasses = opType.getDeclaredClasses()) {
                if (!OperatorSpi.class.isAssignableFrom(declaredClass)) continue;
                operatorDescriptor = spiRegistry.getOperatorSpi(declaredClass.getName()).getOperatorDescriptor();
            }
        }
        if (operatorDescriptor == null) {
            throw new IllegalStateException("Not able to find SPI for operator class '" + opType.getName() + "'");
        }
        return operatorDescriptor;
    }

    private void applyCurrentDirectory(JFileChooser fileChooser) {
        if (this.appContext != null) {
            String homeDirPath = SystemUtils.getUserHomeDir().getPath();
            String lastDir = this.appContext.getPreferences().getPropertyString(this.lastDirPreferenceKey, homeDirPath);
            fileChooser.setCurrentDirectory(new File(lastDir));
        }
    }

    private void preserveCurrentDirectory(JFileChooser fileChooser) {
        if (this.appContext != null) {
            String lastDir = fileChooser.getCurrentDirectory().getAbsolutePath();
            this.appContext.getPreferences().setPropertyString(this.lastDirPreferenceKey, lastDir);
        }
    }

    private class AboutOperatorAction
    extends AbstractAction {
        AboutOperatorAction() {
            super("About...");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            OperatorMenu.this.showInformationDialog("About " + OperatorMenu.this.getOperatorName(), new JLabel(OperatorMenu.this.getOperatorAboutText()));
        }
    }

    private class DisplayParametersAction
    extends AbstractAction {
        private static final String TITLE = "Display Parameters";

        DisplayParametersAction() {
            super("Display Parameters...");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String parameterXml;
            try {
                DomElement domElement = OperatorMenu.this.parameterSupport.toDomElement();
                parameterXml = domElement.toXml();
            }
            catch (Exception e) {
                Debug.trace((Throwable)e);
                Dialogs.showError((String)TITLE, (String)("Failed to convert parameters to XML." + e.getMessage()));
                return;
            }
            JTextArea textArea = new JTextArea(parameterXml);
            textArea.setEditable(false);
            JScrollPane textAreaScrollPane = new JScrollPane(textArea);
            textAreaScrollPane.setPreferredSize(new Dimension(360, 360));
            OperatorMenu.this.showInformationDialog(OperatorMenu.this.getOperatorName() + " Parameters", textAreaScrollPane);
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled() && OperatorMenu.this.parameterSupport != null;
        }
    }

    private class SaveParametersAction
    extends AbstractAction {
        private static final String TITLE = "Save Parameters";

        SaveParametersAction() {
            super("Save Parameters...");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JFileChooser fileChooser = new JFileChooser();
            FileNameExtensionFilter parameterFileFilter = OperatorMenu.this.createParameterFileFilter();
            fileChooser.addChoosableFileFilter(parameterFileFilter);
            fileChooser.setFileFilter(parameterFileFilter);
            fileChooser.setDialogTitle(TITLE);
            fileChooser.setDialogType(1);
            OperatorMenu.this.applyCurrentDirectory(fileChooser);
            int response = fileChooser.showDialog(OperatorMenu.this.parentComponent, "Save");
            if (0 == response) {
                try {
                    OperatorMenu.this.preserveCurrentDirectory(fileChooser);
                    File selectedFile = fileChooser.getSelectedFile();
                    selectedFile = FileUtils.ensureExtension((File)selectedFile, (String)("." + parameterFileFilter.getExtensions()[0]));
                    DomElement domElement = OperatorMenu.this.parameterSupport.toDomElement();
                    OperatorMenu.escapeXmlElements(domElement);
                    String xmlString = domElement.toXml();
                    this.writeToFile(xmlString, selectedFile);
                }
                catch (Exception e) {
                    Debug.trace((Throwable)e);
                    Dialogs.showError((String)TITLE, (String)("Could not load parameters.\n" + e.getMessage()));
                }
            }
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled() && OperatorMenu.this.parameterSupport != null;
        }

        private void writeToFile(String s, File outputFile) throws IOException {
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(outputFile));){
                bw.write(s);
            }
        }
    }

    private class LoadParametersAction
    extends AbstractAction {
        private static final String TITLE = "Load Parameters";

        LoadParametersAction() {
            super("Load Parameters...");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JFileChooser fileChooser = new JFileChooser();
            FileNameExtensionFilter parameterFileFilter = OperatorMenu.this.createParameterFileFilter();
            fileChooser.addChoosableFileFilter(parameterFileFilter);
            fileChooser.setFileFilter(parameterFileFilter);
            fileChooser.setDialogTitle(TITLE);
            fileChooser.setDialogType(0);
            OperatorMenu.this.applyCurrentDirectory(fileChooser);
            int response = fileChooser.showDialog(OperatorMenu.this.parentComponent, "Load");
            if (0 == response) {
                try {
                    OperatorMenu.this.preserveCurrentDirectory(fileChooser);
                    this.readFromFile(fileChooser.getSelectedFile());
                }
                catch (Exception e) {
                    Debug.trace((Throwable)e);
                    AbstractDialog.showErrorDialog((Component)OperatorMenu.this.parentComponent, (String)("Could not load parameters.\n" + e.getMessage()), (String)TITLE);
                }
            }
        }

        @Override
        public boolean isEnabled() {
            return super.isEnabled() && OperatorMenu.this.parameterSupport != null;
        }

        private void readFromFile(File selectedFile) throws Exception {
            try (FileReader reader = new FileReader(selectedFile);){
                DomElement domElement = this.readXml(reader);
                OperatorMenu.this.parameterSupport.fromDomElement(domElement);
            }
        }

        private DomElement readXml(Reader reader) throws IOException {
            try (BufferedReader br = new BufferedReader(reader);){
                StringBuilder sb = new StringBuilder();
                String line = br.readLine();
                while (line != null) {
                    sb.append(line);
                    line = br.readLine();
                }
                XppDomElement xppDomElement = new XppDomElement(OperatorMenu.createDom(sb.toString()));
                return xppDomElement;
            }
        }
    }
}

