/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.grender.support;

import com.bc.ceres.glayer.Assert2D;
import com.bc.ceres.grender.Viewport;
import com.bc.ceres.grender.support.DefaultViewport;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.junit.Assert;
import org.junit.Test;

public class DefaultViewportTest {
    @Test
    public void testDefaultSettings() {
        DefaultViewport viewport = new DefaultViewport(true);
        Assert.assertEquals((Object)new AffineTransform(), (Object)viewport.getModelToViewTransform());
        Assert.assertEquals((Object)new AffineTransform(), (Object)viewport.getViewToModelTransform());
        Assert2D.assertEquals(DefaultViewportTest.p(0.0, 0.0), DefaultViewportTest.getModelOffset((Viewport)viewport));
        Assert.assertEquals((double)1.0, (double)viewport.getZoomFactor(), (double)1.0E-10);
    }

    @Test
    public void testClone() {
        DefaultViewport viewport = new DefaultViewport(new Rectangle(40, 50), true);
        viewport.setOrientation(0.3);
        viewport.setZoomFactor(1.2);
        viewport.setOffset(-4.0, 3.7);
        viewport.setModelYAxisDown(true);
        Assert.assertEquals((double)0.3, (double)viewport.getOrientation(), (double)1.0E-10);
        Assert.assertEquals((double)-4.0, (double)viewport.getOffsetX(), (double)1.0E-10);
        Assert.assertEquals((double)3.7, (double)viewport.getOffsetY(), (double)1.0E-10);
        Assert.assertEquals((double)1.2, (double)viewport.getZoomFactor(), (double)1.0E-10);
        Assert.assertEquals((Object)true, (Object)viewport.isModelYAxisDown());
        Viewport viewportClone = viewport.clone();
        Assert.assertEquals((double)0.3, (double)viewportClone.getOrientation(), (double)1.0E-10);
        Assert.assertEquals((double)-4.0, (double)viewportClone.getOffsetX(), (double)1.0E-10);
        Assert.assertEquals((double)3.7, (double)viewportClone.getOffsetY(), (double)1.0E-10);
        Assert.assertEquals((double)1.2, (double)viewportClone.getZoomFactor(), (double)1.0E-10);
        Assert.assertEquals((Object)true, (Object)viewportClone.isModelYAxisDown());
    }

    @Test
    public void testTransformsAreNotLife() {
        DefaultViewport viewport = new DefaultViewport();
        AffineTransform m2v = viewport.getModelToViewTransform();
        Assert.assertNotSame((Object)m2v, (Object)viewport.getModelToViewTransform());
        AffineTransform v2u = viewport.getViewToModelTransform();
        Assert.assertNotSame((Object)v2u, (Object)viewport.getViewToModelTransform());
        viewport.moveViewDelta(150.0, -10.0);
        Assert.assertNotSame((Object)m2v, (Object)viewport.getModelToViewTransform());
        Assert.assertNotSame((Object)v2u, (Object)viewport.getViewToModelTransform());
    }

    @Test
    public void testInverse() {
        DefaultViewport viewport = new DefaultViewport(true);
        AffineTransform m2v = viewport.getModelToViewTransform();
        Assert.assertNotSame((Object)m2v, (Object)viewport.getModelToViewTransform());
        AffineTransform v2u = viewport.getViewToModelTransform();
        Assert.assertNotSame((Object)v2u, (Object)viewport.getViewToModelTransform());
        viewport.moveViewDelta(150.0, -10.0);
        Assert2D.assertEquals(DefaultViewportTest.p(-150.0, 10.0), DefaultViewportTest.t(viewport.getViewToModelTransform(), DefaultViewportTest.p(0.0, 0.0)));
        Assert2D.assertEquals(DefaultViewportTest.p(0.0, 0.0), DefaultViewportTest.t(viewport.getModelToViewTransform(), DefaultViewportTest.p(-150.0, 10.0)));
        Assert2D.assertEquals(DefaultViewportTest.p(150.0, -10.0), DefaultViewportTest.t(viewport.getModelToViewTransform(), DefaultViewportTest.p(0.0, 0.0)));
        Assert2D.assertEquals(DefaultViewportTest.p(0.0, 0.0), DefaultViewportTest.t(viewport.getViewToModelTransform(), DefaultViewportTest.p(150.0, -10.0)));
    }

    @Test
    public void testMove() {
        DefaultViewport viewport = new DefaultViewport(true);
        viewport.moveViewDelta(15.0, 10.0);
        Assert2D.assertEquals(DefaultViewportTest.p(-15.0, -10.0), DefaultViewportTest.getModelOffset((Viewport)viewport));
        viewport.moveViewDelta(-15.0, -10.0);
        Assert2D.assertEquals(DefaultViewportTest.p(0.0, 0.0), DefaultViewportTest.getModelOffset((Viewport)viewport));
    }

    @Test
    public void testZoomFactor() {
        DefaultViewport viewport = new DefaultViewport(true);
        viewport.moveViewDelta(-10.0, -10.0);
        viewport.setViewBounds(new Rectangle(0, 0, 30, 20));
        Point2D vc = DefaultViewportTest.p(15.0, 10.0);
        Point2D uc = DefaultViewportTest.t(viewport.getViewToModelTransform(), vc);
        viewport.setZoomFactor(0.5);
        Assert.assertEquals((double)0.5, (double)viewport.getZoomFactor(), (double)1.0E-10);
        Assert2D.assertEquals(DefaultViewportTest.p(-5.0, 0.0), DefaultViewportTest.getModelOffset((Viewport)viewport));
        Assert2D.assertEquals(uc, DefaultViewportTest.t(viewport.getViewToModelTransform(), vc));
        viewport.setZoomFactor(2.0);
        Assert.assertEquals((double)2.0, (double)viewport.getZoomFactor(), (double)1.0E-10);
        Assert2D.assertEquals(DefaultViewportTest.p(17.5, 15.0), DefaultViewportTest.getModelOffset((Viewport)viewport));
        Assert2D.assertEquals(uc, DefaultViewportTest.t(viewport.getViewToModelTransform(), vc));
        viewport.setViewBounds(new Rectangle(0, 0, 100, 50));
        vc = DefaultViewportTest.p(50.0, 25.0);
        uc = DefaultViewportTest.t(viewport.getViewToModelTransform(), vc);
        viewport.setZoomFactor(0.8333333333333334);
        Assert.assertEquals((double)0.8333333333333334, (double)viewport.getZoomFactor(), (double)1.0E-10);
        Assert2D.assertEquals(DefaultViewportTest.p(-17.5, -2.5), DefaultViewportTest.getModelOffset((Viewport)viewport));
        Assert2D.assertEquals(uc, DefaultViewportTest.t(viewport.getViewToModelTransform(), vc));
        viewport.setZoomFactor(1.25);
        Assert.assertEquals((double)1.25, (double)viewport.getZoomFactor(), (double)1.0E-10);
        Assert2D.assertEquals(DefaultViewportTest.p(2.5, 7.5), DefaultViewportTest.getModelOffset((Viewport)viewport));
        Assert2D.assertEquals(uc, DefaultViewportTest.t(viewport.getViewToModelTransform(), vc));
    }

    @Test
    public void testRelativeZoomWithAffineTransform() {
        Point2D v0 = DefaultViewportTest.p(0.0, 0.0);
        AffineTransform v2u = new AffineTransform();
        v2u.translate(10.0, 10.0);
        Point2D u0 = DefaultViewportTest.t(v2u, v0);
        Assert.assertEquals((double)1.0, (double)v2u.getScaleX(), (double)1.0E-10);
        Assert.assertEquals((double)1.0, (double)v2u.getScaleY(), (double)1.0E-10);
        Assert2D.assertEquals(DefaultViewportTest.p(10.0, 10.0), u0);
        Point2D vc = DefaultViewportTest.p(15.0, 10.0);
        Assert2D.assertEquals(DefaultViewportTest.p(25.0, 20.0), DefaultViewportTest.t(v2u, vc));
        DefaultViewportTest.zoom(v2u, vc, 2.0);
        Assert2D.assertEquals(DefaultViewportTest.p(25.0, 20.0), DefaultViewportTest.t(v2u, vc));
        Assert.assertEquals((double)2.0, (double)v2u.getScaleX(), (double)1.0E-10);
        Assert.assertEquals((double)2.0, (double)v2u.getScaleY(), (double)1.0E-10);
        Assert2D.assertEquals(DefaultViewportTest.p(-5.0, 0.0), DefaultViewportTest.t(v2u, v0));
        DefaultViewportTest.zoom(v2u, vc, 0.5);
        Assert2D.assertEquals(DefaultViewportTest.p(25.0, 20.0), DefaultViewportTest.t(v2u, vc));
        Assert.assertEquals((double)0.5, (double)v2u.getScaleX(), (double)1.0E-10);
        Assert.assertEquals((double)0.5, (double)v2u.getScaleY(), (double)1.0E-10);
        Assert2D.assertEquals(DefaultViewportTest.p(17.5, 15.0), DefaultViewportTest.t(v2u, v0));
        vc = DefaultViewportTest.p(50.0, 25.0);
        Assert2D.assertEquals(DefaultViewportTest.p(42.5, 27.5), DefaultViewportTest.t(v2u, vc));
        DefaultViewportTest.zoom(v2u, vc, 1.2);
        Assert2D.assertEquals(DefaultViewportTest.p(42.5, 27.5), DefaultViewportTest.t(v2u, vc));
        Assert.assertEquals((double)1.2, (double)v2u.getScaleX(), (double)1.0E-10);
        Assert.assertEquals((double)1.2, (double)v2u.getScaleY(), (double)1.0E-10);
        Assert2D.assertEquals(DefaultViewportTest.p(-17.5, -2.5), DefaultViewportTest.t(v2u, v0));
        DefaultViewportTest.zoom(v2u, vc, 0.8);
        Assert2D.assertEquals(DefaultViewportTest.p(42.5, 27.5), DefaultViewportTest.t(v2u, vc));
        Assert.assertEquals((double)0.8, (double)v2u.getScaleX(), (double)1.0E-10);
        Assert.assertEquals((double)0.8, (double)v2u.getScaleY(), (double)1.0E-10);
        Assert2D.assertEquals(DefaultViewportTest.p(2.5, 7.5), DefaultViewportTest.t(v2u, v0));
    }

    @Test
    public void testRelativeZoomWithViewport() {
        DefaultViewport viewport = new DefaultViewport(new Rectangle(40, 50), true);
        viewport.moveViewDelta(10.0, 10.0);
        Point2D v0 = DefaultViewportTest.p(0.0, 0.0);
        viewport.setOffset(10.0, 10.0);
        AffineTransform v2m = viewport.getViewToModelTransform();
        Point2D u0 = DefaultViewportTest.t(v2m, v0);
        Assert.assertEquals((double)1.0, (double)v2m.getScaleX(), (double)1.0E-10);
        Assert.assertEquals((double)1.0, (double)v2m.getScaleY(), (double)1.0E-10);
        Assert2D.assertEquals(DefaultViewportTest.p(10.0, 10.0), u0);
        Point2D vc = DefaultViewportTest.p(15.0, 10.0);
        Assert2D.assertEquals(DefaultViewportTest.p(25.0, 20.0), DefaultViewportTest.t(v2m, vc));
        viewport.setZoomFactor(0.5, vc);
        v2m = viewport.getViewToModelTransform();
        Assert.assertEquals((double)0.5, (double)viewport.getZoomFactor(), (double)1.0E-10);
        Assert2D.assertEquals(DefaultViewportTest.p(25.0, 20.0), DefaultViewportTest.t(v2m, vc));
        Assert.assertEquals((double)2.0, (double)v2m.getScaleX(), (double)1.0E-10);
        Assert.assertEquals((double)2.0, (double)v2m.getScaleY(), (double)1.0E-10);
        Assert2D.assertEquals(DefaultViewportTest.p(-5.0, 0.0), DefaultViewportTest.t(v2m, v0));
        viewport.setZoomFactor(2.0, vc);
        v2m = viewport.getViewToModelTransform();
        Assert.assertEquals((double)2.0, (double)viewport.getZoomFactor(), (double)1.0E-10);
        Assert2D.assertEquals(DefaultViewportTest.p(25.0, 20.0), DefaultViewportTest.t(v2m, vc));
        Assert.assertEquals((double)0.5, (double)v2m.getScaleX(), (double)1.0E-10);
        Assert.assertEquals((double)0.5, (double)v2m.getScaleY(), (double)1.0E-10);
        Assert2D.assertEquals(DefaultViewportTest.p(17.5, 15.0), DefaultViewportTest.t(v2m, v0));
        vc = DefaultViewportTest.p(50.0, 25.0);
        Assert2D.assertEquals(DefaultViewportTest.p(42.5, 27.5), DefaultViewportTest.t(v2m, vc));
        viewport.setZoomFactor(0.8333333333333334, vc);
        v2m = viewport.getViewToModelTransform();
        Assert.assertEquals((double)0.8333333333333334, (double)viewport.getZoomFactor(), (double)1.0E-10);
        Assert2D.assertEquals(DefaultViewportTest.p(42.5, 27.5), DefaultViewportTest.t(v2m, vc));
        Assert.assertEquals((double)1.2, (double)v2m.getScaleX(), (double)1.0E-10);
        Assert.assertEquals((double)1.2, (double)v2m.getScaleY(), (double)1.0E-10);
        Assert2D.assertEquals(DefaultViewportTest.p(-17.5, -2.5), DefaultViewportTest.t(v2m, v0));
        viewport.setZoomFactor(1.25, vc);
        v2m = viewport.getViewToModelTransform();
        Assert.assertEquals((double)1.25, (double)viewport.getZoomFactor(), (double)1.0E-10);
        Assert2D.assertEquals(DefaultViewportTest.p(42.5, 27.5), DefaultViewportTest.t(v2m, vc));
        Assert.assertEquals((double)0.8, (double)v2m.getScaleX(), (double)1.0E-10);
        Assert.assertEquals((double)0.8, (double)v2m.getScaleY(), (double)1.0E-10);
        Assert2D.assertEquals(DefaultViewportTest.p(2.5, 7.5), DefaultViewportTest.t(v2m, v0));
    }

    @Test
    public void testZoomToModelPoint() {
        DefaultViewport viewport = new DefaultViewport(new Rectangle(40, 50), true);
        Point2D m0 = DefaultViewportTest.p(3.0, 3.0);
        Point2D m1 = DefaultViewportTest.p(1.0, 1.0);
        Rectangle viewBounds = viewport.getViewBounds();
        viewport.setZoomFactor(2.0, 3.0, 3.0);
        AffineTransform m2v = viewport.getModelToViewTransform();
        Assert.assertEquals((double)2.0, (double)viewport.getZoomFactor(), (double)1.0E-10);
        Assert.assertEquals((double)2.0, (double)viewport.getZoomFactor(), (double)1.0E-10);
        Assert.assertEquals((double)2.0, (double)m2v.getScaleX(), (double)1.0E-10);
        Assert.assertEquals((double)2.0, (double)m2v.getScaleY(), (double)1.0E-10);
        Assert2D.assertEquals(DefaultViewportTest.p(20.0, 25.0), DefaultViewportTest.t(m2v, m0));
        Assert2D.assertEquals(DefaultViewportTest.p(16.0, 21.0), DefaultViewportTest.t(m2v, m1));
        Rectangle2D modelBounds = viewport.getViewToModelTransform().createTransformedShape(viewBounds).getBounds2D();
        double centerX = modelBounds.getCenterX();
        Assert.assertEquals((double)3.0, (double)centerX, (double)1.0E-10);
        double centerY = modelBounds.getCenterY();
        Assert.assertEquals((double)3.0, (double)centerY, (double)1.0E-10);
        Assert2D.assertEquals(new Rectangle2D.Double(-7.0, -9.5, 20.0, 25.0), modelBounds);
        viewport.setZoomFactor(2.0, 9.0, 9.0);
        m2v = viewport.getModelToViewTransform();
        Assert.assertEquals((double)2.0, (double)viewport.getZoomFactor(), (double)1.0E-10);
        Assert.assertEquals((double)2.0, (double)m2v.getScaleX(), (double)1.0E-10);
        Assert.assertEquals((double)2.0, (double)m2v.getScaleY(), (double)1.0E-10);
        Assert2D.assertEquals(DefaultViewportTest.p(8.0, 13.0), DefaultViewportTest.t(m2v, m0));
        Assert2D.assertEquals(DefaultViewportTest.p(4.0, 9.0), DefaultViewportTest.t(m2v, m1));
        viewport.setZoomFactor(3.0, 3.0, 3.0);
        m2v = viewport.getModelToViewTransform();
        Assert.assertEquals((double)3.0, (double)viewport.getZoomFactor(), (double)1.0E-10);
        Assert.assertEquals((double)3.0, (double)m2v.getScaleX(), (double)1.0E-10);
        Assert.assertEquals((double)3.0, (double)m2v.getScaleY(), (double)1.0E-10);
        Assert2D.assertEquals(DefaultViewportTest.p(20.0, 25.0), DefaultViewportTest.t(m2v, m0));
        Assert2D.assertEquals(DefaultViewportTest.p(14.0, 19.0), DefaultViewportTest.t(m2v, m1));
    }

    @Test
    public void testIllegalZoomFactor() {
        DefaultViewport viewport = new DefaultViewport();
        try {
            viewport.setZoomFactor(0.0);
            Assert.fail((String)"IAE expected");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            viewport.setZoomFactor(-4.0);
            Assert.fail((String)"IAE expected");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            viewport.setZoomFactor(0.0, 3.0, 3.0);
            Assert.fail((String)"IAE expected");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            viewport.setZoomFactor(-0.01, 3.0, 3.0);
            Assert.fail((String)"IAE expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private static void zoom(AffineTransform t, Point2D vc, double s) {
        double m00 = t.getScaleX();
        double m10 = t.getShearY();
        double m01 = t.getShearX();
        double m11 = t.getScaleY();
        double sx = Math.sqrt(m00 * m00 + m10 * m10);
        double sy = Math.sqrt(m01 * m01 + m11 * m11);
        t.translate(vc.getX(), vc.getY());
        t.scale(s / sx, s / sy);
        t.translate(-vc.getX(), -vc.getY());
    }

    private static Point2D t(AffineTransform t, Point2D p) {
        return t.transform(p, null);
    }

    static Point2D p(double x, double y) {
        return new Point2D.Double(x, y);
    }

    public static Point2D getModelOffset(Viewport vp) {
        return vp.getViewToModelTransform().transform(new Point(0, 0), null);
    }
}

