/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.glayer.support;

import com.bc.ceres.glayer.Assert2D;
import com.bc.ceres.glayer.support.ImageLayer;
import com.bc.ceres.glevel.MultiLevelSource;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import javax.media.jai.TiledImage;
import org.junit.Assert;
import org.junit.Test;

public class ImageLayerTest {
    @Test
    public void testThatLayerOperatesWithNullImage() {
        ImageLayer layer = new ImageLayer(MultiLevelSource.NULL);
        Assert.assertNotNull((Object)layer.getMultiLevelSource());
        Assert.assertNotNull((Object)layer.getImage());
        Assert.assertNotNull((Object)layer.getImageToModelTransform());
        Assert.assertTrue((boolean)layer.getImageToModelTransform().isIdentity());
        Assert.assertNotNull((Object)layer.getModelToImageTransform());
        Assert.assertTrue((boolean)layer.getModelToImageTransform().isIdentity());
        Assert.assertNull((Object)layer.getModelBounds());
    }

    @Test
    public void testConstructors() {
        TiledImage image = new TiledImage((RenderedImage)new BufferedImage(320, 200, 10), true);
        ImageLayer layer = new ImageLayer((RenderedImage)image);
        Assert.assertSame((Object)image, (Object)layer.getImage());
        Assert.assertEquals((Object)new AffineTransform(), (Object)layer.getModelToImageTransform());
        Assert.assertEquals((Object)new AffineTransform(), (Object)layer.getImageToModelTransform());
        AffineTransform i2m = AffineTransform.getTranslateInstance(100.0, 200.0);
        layer = new ImageLayer((RenderedImage)image, i2m, 1);
        Assert.assertSame((Object)image, (Object)layer.getImage());
        Assert.assertNotSame((Object)i2m, (Object)layer.getImageToModelTransform());
        Assert.assertNotSame((Object)i2m, (Object)layer.getModelToImageTransform());
        Assert.assertEquals((Object)AffineTransform.getTranslateInstance(100.0, 200.0), (Object)layer.getImageToModelTransform());
        Assert.assertEquals((Object)AffineTransform.getTranslateInstance(-100.0, -200.0), (Object)layer.getModelToImageTransform());
    }

    @Test
    public void testBoundingBox() {
        TiledImage image = new TiledImage((RenderedImage)new BufferedImage(320, 200, 10), true);
        ImageLayer layer = new ImageLayer((RenderedImage)image);
        Assert.assertNotNull((Object)layer.getModelBounds());
        Assert2D.assertEquals(new Rectangle2D.Double(0.0, 0.0, 320.0, 200.0), layer.getModelBounds());
        AffineTransform i2m = new AffineTransform(0.5, 0.0, 0.0, 0.5, -25.5, 50.3);
        layer = new ImageLayer((RenderedImage)image, i2m, 1);
        Assert.assertNotNull((Object)layer.getModelBounds());
        Assert2D.assertEquals(new Rectangle2D.Double(-25.5, 50.3, 160.0, 100.0), layer.getModelBounds());
    }
}

