/*
 * Decompiled with CFR 0.152.
 */
package com.bc.ceres.glayer.jaitests;

import com.bc.ceres.glayer.tools.Tools;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.SourcelessOpImage;
import org.junit.Ignore;

@Ignore
public class TransparencyTest {
    public static void main(String[] args) {
        Tools.configureJAI();
        int width = 3072;
        int height = 3072;
        int featureCount = 2500;
        ArrayList<Feature> features1 = new ArrayList<Feature>(featureCount);
        for (int i = 0; i < featureCount; ++i) {
            double r = 10.0 + Math.random() * (double)width / 40.0;
            Ellipse2D.Double shape = new Ellipse2D.Double(Math.random() * (double)width, Math.random() * (double)height, r, r);
            Feature feature = new Feature(shape, new Color((float)Math.random(), (float)Math.random(), (float)Math.random()), new Color((float)Math.random(), (float)Math.random(), (float)Math.random()));
            features1.add(feature);
        }
        FeatureOpImage image1 = FeatureOpImage.create(width, height, features1.toArray(new Feature[features1.size()]));
        ArrayList<Feature> features2 = new ArrayList<Feature>(featureCount);
        for (int i = 0; i < featureCount; ++i) {
            double r = 10.0 + Math.random() * (double)width / 50.0;
            Rectangle2D.Double shape = new Rectangle2D.Double(Math.random() * (double)width, Math.random() * (double)height, r, r);
            Feature feature = new Feature(shape, new Color((float)Math.random(), (float)Math.random(), (float)Math.random()), new Color((float)Math.random(), (float)Math.random(), (float)Math.random()));
            features2.add(feature);
        }
        FeatureOpImage image2 = FeatureOpImage.create(width, height, features2.toArray(new Feature[features2.size()]));
        Tools.displayImages((String)"UhahaTest", (RenderedImage[])new RenderedImage[]{image1, image2}, (AffineTransform[])new AffineTransform[]{new AffineTransform(), AffineTransform.getTranslateInstance(16.0, 16.0)}, (int)8);
    }

    public static class Feature {
        Shape shape;
        Color lineColor;
        Color fillColor;

        private Feature(Shape shape, Color lineColor, Color fillColor) {
            this.shape = shape;
            this.lineColor = lineColor;
            this.fillColor = fillColor;
        }
    }

    private static class FeatureOpImage
    extends SourcelessOpImage {
        private Feature[] features;

        public static FeatureOpImage create(int width, int height, Feature[] features) {
            BufferedImage proto = new BufferedImage(16, 16, 2);
            ImageLayout imageLayout = new ImageLayout();
            imageLayout.setWidth(width);
            imageLayout.setHeight(height);
            imageLayout.setTileWidth(256);
            imageLayout.setTileHeight(256);
            imageLayout.setSampleModel(proto.getSampleModel().createCompatibleSampleModel(width, height));
            imageLayout.setColorModel(proto.getColorModel());
            return new FeatureOpImage(imageLayout, features);
        }

        private FeatureOpImage(ImageLayout imageLayout, Feature[] features) {
            super(imageLayout, null, imageLayout.getSampleModel(null), 0, 0, imageLayout.getWidth(null), imageLayout.getHeight(null));
            this.setTileCache(JAI.getDefaultInstance().getTileCache());
            this.features = features;
        }

        protected void computeRect(PlanarImage[] sources, WritableRaster destTile, Rectangle destRect) {
            BufferedImage image = new BufferedImage(this.getColorModel(), WritableRaster.createWritableRaster(destTile.getSampleModel(), destTile.getDataBuffer(), new Point(0, 0)), false, null);
            Graphics2D g = image.createGraphics();
            g.translate(-destRect.x, -destRect.y);
            g.setColor(new Color(0, 0, 0, 0));
            g.fillRect(0, 0, image.getWidth(), image.getHeight());
            for (Feature feature : this.features) {
                g.setColor(feature.fillColor);
                g.fill(feature.shape);
                g.setColor(feature.lineColor);
                g.draw(feature.shape);
            }
            g.dispose();
        }
    }
}

