/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.getasse30;

import java.io.File;
import java.util.Locale;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.dataio.getasse30.GETASSE30Reader;

public class GETASSE30ReaderPlugIn
implements ProductReaderPlugIn {
    public static final String FORMAT_NAME = "GETASSE30";
    public static final String[] FILE_EXTENSIONS = new String[]{".getasse30"};
    public static final Class[] INPUT_TYPES = new Class[]{String.class, File.class};
    public static final String DESCRIPTION = "GETASSE30 Data Product Tile";

    public DecodeQualification getDecodeQualification(Object input) {
        File file = GETASSE30ReaderPlugIn.getInputFile(input);
        if (file != null) {
            String[] extensions;
            String fileName = file.getName().toLowerCase();
            for (String extension : extensions = this.getDefaultFileExtensions()) {
                if (!fileName.endsWith(extension) || fileName.equals(extension)) continue;
                return DecodeQualification.INTENDED;
            }
        }
        return DecodeQualification.UNABLE;
    }

    public static File getInputFile(Object input) {
        File file = null;
        if (input instanceof String) {
            file = new File((String)input);
        } else if (input instanceof File) {
            file = (File)input;
        }
        return file;
    }

    public Class[] getInputTypes() {
        return INPUT_TYPES;
    }

    public ProductReader createReaderInstance() {
        return new GETASSE30Reader(this);
    }

    public SnapFileFilter getProductFileFilter() {
        return new SnapFileFilter(FORMAT_NAME, FILE_EXTENSIONS, DESCRIPTION);
    }

    public String[] getFormatNames() {
        return new String[]{FORMAT_NAME};
    }

    public String[] getDefaultFileExtensions() {
        return FILE_EXTENSIONS;
    }

    public String getDescription(Locale locale) {
        return DESCRIPTION;
    }
}

