/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.geotiff;

import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.dataio.geotiff.GeoTiffProductReader;

public class GeoTiffProductReaderPlugIn
implements ProductReaderPlugIn {
    private static final String[] FORMAT_NAMES = new String[]{"GeoTIFF"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DecodeQualification getDecodeQualification(Object input) {
        DecodeQualification decodeQualification;
        Object imageIOInput;
        if (input instanceof String) {
            imageIOInput = new File((String)input);
        } else if (input instanceof File || input instanceof InputStream) {
            imageIOInput = input;
        } else {
            return DecodeQualification.UNABLE;
        }
        if (input instanceof String || input instanceof File) {
            String ext = FileUtils.getExtension((File)((File)imageIOInput));
            if (ext != null && ext.equalsIgnoreCase(".tif") || ext.equalsIgnoreCase(".tiff") || ext.equalsIgnoreCase(".btf")) {
                return DecodeQualification.INTENDED;
            }
            if (ext != null && ext.equalsIgnoreCase(".zip")) {
                return GeoTiffProductReaderPlugIn.checkZip((File)imageIOInput);
            }
            return DecodeQualification.UNABLE;
        }
        ImageInputStream stream = ImageIO.createImageInputStream(imageIOInput);
        try {
            decodeQualification = GeoTiffProductReaderPlugIn.getDecodeQualificationImpl(stream);
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (Exception exception) {
                return DecodeQualification.UNABLE;
            }
        }
        stream.close();
        return decodeQualification;
    }

    private static DecodeQualification checkZip(File file) throws IOException {
        ZipFile productZip = new ZipFile(file, 1);
        Enumeration<? extends ZipEntry> entries = productZip.entries();
        boolean foundTiff = false;
        int entryCnt = 0;
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            if (zipEntry == null || zipEntry.isDirectory()) continue;
            ++entryCnt;
            String name = zipEntry.getName().toLowerCase();
            if (!name.contains("/") && (name.endsWith(".tif") || name.endsWith(".tiff") || name.endsWith(".btf"))) {
                foundTiff = true;
            }
            if (!foundTiff || entryCnt <= 1) continue;
            return DecodeQualification.SUITABLE;
        }
        if (foundTiff && entryCnt == 1) {
            return DecodeQualification.INTENDED;
        }
        return DecodeQualification.UNABLE;
    }

    static DecodeQualification getDecodeQualificationImpl(ImageInputStream stream) {
        try {
            Iterator<ImageReader> imageReaders = ImageIO.getImageReaders(stream);
            TIFFImageReader imageReader = null;
            while (imageReaders.hasNext()) {
                ImageReader reader = imageReaders.next();
                if (!(reader instanceof TIFFImageReader)) continue;
                imageReader = (TIFFImageReader)reader;
                break;
            }
            if (imageReader == null) {
                return DecodeQualification.UNABLE;
            }
        }
        catch (Exception ignore) {
            return DecodeQualification.UNABLE;
        }
        return DecodeQualification.SUITABLE;
    }

    public Class[] getInputTypes() {
        return new Class[]{String.class, File.class, InputStream.class};
    }

    public ProductReader createReaderInstance() {
        return new GeoTiffProductReader(this);
    }

    public String[] getFormatNames() {
        return FORMAT_NAMES;
    }

    public String[] getDefaultFileExtensions() {
        return new String[]{".tif", ".tiff", ".btf", ".zip"};
    }

    public String getDescription(Locale locale) {
        return "GeoTIFF data product.";
    }

    public SnapFileFilter getProductFileFilter() {
        return new SnapFileFilter(FORMAT_NAMES[0], this.getDefaultFileExtensions(), this.getDescription(null));
    }
}

