/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.geotiff.internal;

import java.awt.Dimension;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import junit.framework.TestCase;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.util.jai.JAIUtils;
import org.esa.snap.dataio.geotiff.internal.TiffAscii;
import org.esa.snap.dataio.geotiff.internal.TiffCode;
import org.esa.snap.dataio.geotiff.internal.TiffDirectoryEntry;
import org.esa.snap.dataio.geotiff.internal.TiffIFD;
import org.esa.snap.dataio.geotiff.internal.TiffLong;
import org.esa.snap.dataio.geotiff.internal.TiffRational;
import org.esa.snap.dataio.geotiff.internal.TiffShort;
import org.esa.snap.dataio.geotiff.internal.TiffTag;
import org.esa.snap.dataio.geotiff.internal.TiffType;
import org.esa.snap.dataio.geotiff.internal.TiffValue;
import org.junit.Assert;

public class TiffIFDTest
extends TestCase {
    private Product _product;
    private static final int WIDTH = 10;
    private static final int HEIGHT = 20;

    protected void setUp() throws Exception {
        super.setUp();
        this._product = new Product("name", "type", 10, 20);
    }

    public void testTiffIFDCreation_WithEmptyProduct() {
        try {
            new TiffIFD(this._product);
            TiffIFDTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception e) {
            TiffIFDTest.fail((String)"IllegalArgumentException expected");
        }
    }

    public void testTiffIFDCreationMixedTypes() throws Exception {
        this._product.addBand("b1", 20);
        this._product.addBand("b2", 21);
        this._product.addBand("b3", 22);
        this._product.addBand("b4", 10);
        this._product.addBand("b5", 11);
        this._product.addBand("b6", 12);
        this._product.addBand("b7", 30);
        Dimension tileSize = JAIUtils.computePreferredTileSize((int)10, (int)20, (int)1);
        this._product.setPreferredTileSize(tileSize);
        TiffIFD ifd = new TiffIFD(this._product);
        double[] expWidth = new double[]{10.0};
        double[] expHeight = new double[]{20.0};
        double[] expBitsPerSample = new double[]{32.0, 32.0, 32.0, 32.0, 32.0, 32.0, 32.0};
        double[] expCompression = new double[]{1.0};
        double[] expPhotoInter = new double[]{TiffCode.PHOTOMETRIC_BLACK_IS_ZERO.getValue()};
        TiffAscii expImageDescription = new TiffAscii(new String[]{this._product.getName()});
        double[] expStripOffsets = new double[]{0.0, 800.0, 1600.0, 2400.0, 3200.0, 4000.0, 4800.0};
        double[] expSamplesPerPixel = new double[]{this._product.getNumBands()};
        double[] expRowsPerStrip = new double[]{20.0};
        double[] expStripByteCounts = new double[]{800.0, 800.0, 800.0, 800.0, 800.0, 800.0, 800.0};
        double[] expPlanarConfig = new double[]{TiffCode.PLANAR_CONFIG_PLANAR.getValue()};
        double[] expSampleFormat = new double[]{TiffCode.SAMPLE_FORMAT_FLOAT.getValue(), TiffCode.SAMPLE_FORMAT_FLOAT.getValue(), TiffCode.SAMPLE_FORMAT_FLOAT.getValue(), TiffCode.SAMPLE_FORMAT_FLOAT.getValue(), TiffCode.SAMPLE_FORMAT_FLOAT.getValue(), TiffCode.SAMPLE_FORMAT_FLOAT.getValue(), TiffCode.SAMPLE_FORMAT_FLOAT.getValue()};
        double[] expXResolution = new double[]{1.0};
        double[] expYResolution = new double[]{1.0};
        double[] expResolutionUnit = new double[]{1.0};
        TiffAscii beamMetadata = TiffIFD.getBeamMetadata((Product)this._product);
        this.checkTag(TiffTag.IMAGE_WIDTH, TiffLong.class, expWidth, null, ifd);
        this.checkTag(TiffTag.IMAGE_LENGTH, TiffLong.class, expHeight, null, ifd);
        this.checkTag(TiffTag.BITS_PER_SAMPLE, TiffShort[].class, expBitsPerSample, null, ifd);
        this.checkTag(TiffTag.COMPRESSION, TiffShort.class, expCompression, null, ifd);
        this.checkTag(TiffTag.PHOTOMETRIC_INTERPRETATION, TiffShort.class, expPhotoInter, null, ifd);
        this.checkAsciiTag(TiffTag.IMAGE_DESCRIPTION, expImageDescription, null, ifd);
        this.checkTag(TiffTag.STRIP_OFFSETS, TiffLong[].class, expStripOffsets, null, ifd);
        this.checkTag(TiffTag.SAMPLES_PER_PIXEL, TiffShort.class, expSamplesPerPixel, null, ifd);
        this.checkTag(TiffTag.ROWS_PER_STRIP, TiffLong.class, expRowsPerStrip, null, ifd);
        this.checkTag(TiffTag.STRIP_BYTE_COUNTS, TiffLong[].class, expStripByteCounts, null, ifd);
        this.checkTag(TiffTag.PLANAR_CONFIGURATION, TiffShort.class, expPlanarConfig, null, ifd);
        this.checkTag(TiffTag.SAMPLE_FORMAT, TiffShort[].class, expSampleFormat, null, ifd);
        this.checkTag(TiffTag.X_RESOLUTION, TiffRational.class, expXResolution, null, ifd);
        this.checkTag(TiffTag.Y_RESOLUTION, TiffRational.class, expYResolution, null, ifd);
        this.checkTag(TiffTag.RESOLUTION_UNIT, TiffShort.class, expResolutionUnit, null, ifd);
        this.checkAsciiTag(TiffTag.BEAM_METADATA, beamMetadata, null, ifd);
        long ifdSize = ifd.getRequiredIfdSize();
        long expRequiredReferencedValuesSize = this.computeRequiredValuesSize(expBitsPerSample, expStripOffsets, expStripByteCounts, expSampleFormat, expXResolution, expYResolution, expImageDescription, beamMetadata);
        long referencedValuesSize = ifd.getRequiredReferencedValuesSize();
        long sizeForStrips = ifd.getRequiredSizeForStrips();
        long expEntireSize = ifdSize + referencedValuesSize + sizeForStrips;
        TiffIFDTest.assertEquals((long)198L, (long)ifdSize);
        TiffIFDTest.assertEquals((long)expRequiredReferencedValuesSize, (long)referencedValuesSize);
        TiffIFDTest.assertEquals((long)this.sumOf(expStripByteCounts), (long)sizeForStrips);
        TiffIFDTest.assertEquals((long)expEntireSize, (long)ifd.getRequiredEntireSize());
    }

    public void testTiffIFDCreationUByte() throws Exception {
        this._product.addBand("b1", 20);
        this._product.addBand("b2", 21);
        this._product.addBand("b3", 20);
        Dimension tileSize = JAIUtils.computePreferredTileSize((int)10, (int)20, (int)1);
        this._product.setPreferredTileSize(tileSize);
        TiffIFD ifd = new TiffIFD(this._product);
        double[] expWidth = new double[]{10.0};
        double[] expHeight = new double[]{20.0};
        double[] expBitsPerSample = new double[]{16.0, 16.0, 16.0};
        double[] expCompression = new double[]{1.0};
        double[] expPhotoInter = new double[]{TiffCode.PHOTOMETRIC_BLACK_IS_ZERO.getValue()};
        TiffAscii expImageDescription = new TiffAscii(new String[]{this._product.getName()});
        double[] expStripOffsets = new double[]{0.0, 400.0, 800.0};
        double[] expSamplesPerPixel = new double[]{this._product.getNumBands()};
        double[] expRowsPerStrip = new double[]{20.0};
        double[] expStripByteCounts = new double[]{400.0, 400.0, 400.0};
        double[] expPlanarConfig = new double[]{TiffCode.PLANAR_CONFIG_PLANAR.getValue()};
        double[] expSampleFormat = new double[]{TiffCode.SAMPLE_FORMAT_UINT.getValue(), TiffCode.SAMPLE_FORMAT_UINT.getValue(), TiffCode.SAMPLE_FORMAT_UINT.getValue()};
        double[] expXResolution = new double[]{1.0};
        double[] expYResolution = new double[]{1.0};
        double[] expResolutionUnit = new double[]{1.0};
        TiffAscii beamMetadata = TiffIFD.getBeamMetadata((Product)this._product);
        this.checkTag(TiffTag.IMAGE_WIDTH, TiffLong.class, expWidth, null, ifd);
        this.checkTag(TiffTag.IMAGE_LENGTH, TiffLong.class, expHeight, null, ifd);
        this.checkTag(TiffTag.BITS_PER_SAMPLE, TiffShort[].class, expBitsPerSample, null, ifd);
        this.checkTag(TiffTag.COMPRESSION, TiffShort.class, expCompression, null, ifd);
        this.checkTag(TiffTag.PHOTOMETRIC_INTERPRETATION, TiffShort.class, expPhotoInter, null, ifd);
        this.checkAsciiTag(TiffTag.IMAGE_DESCRIPTION, expImageDescription, null, ifd);
        this.checkTag(TiffTag.STRIP_OFFSETS, TiffLong[].class, expStripOffsets, null, ifd);
        this.checkTag(TiffTag.SAMPLES_PER_PIXEL, TiffShort.class, expSamplesPerPixel, null, ifd);
        this.checkTag(TiffTag.ROWS_PER_STRIP, TiffLong.class, expRowsPerStrip, null, ifd);
        this.checkTag(TiffTag.STRIP_BYTE_COUNTS, TiffLong[].class, expStripByteCounts, null, ifd);
        this.checkTag(TiffTag.PLANAR_CONFIGURATION, TiffShort.class, expPlanarConfig, null, ifd);
        this.checkTag(TiffTag.SAMPLE_FORMAT, TiffShort[].class, expSampleFormat, null, ifd);
        this.checkTag(TiffTag.X_RESOLUTION, TiffRational.class, expXResolution, null, ifd);
        this.checkTag(TiffTag.Y_RESOLUTION, TiffRational.class, expYResolution, null, ifd);
        this.checkTag(TiffTag.RESOLUTION_UNIT, TiffShort.class, expResolutionUnit, null, ifd);
        this.checkAsciiTag(TiffTag.BEAM_METADATA, beamMetadata, null, ifd);
        long ifdSize = ifd.getRequiredIfdSize();
        long expRequiredReferencedValuesSize = this.computeRequiredValuesSize(expBitsPerSample, expStripOffsets, expStripByteCounts, expSampleFormat, expXResolution, expYResolution, expImageDescription, beamMetadata);
        long referencedValuesSize = ifd.getRequiredReferencedValuesSize();
        long sizeForStrips = ifd.getRequiredSizeForStrips();
        long expEntireSize = ifdSize + referencedValuesSize + sizeForStrips;
        TiffIFDTest.assertEquals((long)198L, (long)ifdSize);
        TiffIFDTest.assertEquals((long)expRequiredReferencedValuesSize, (long)referencedValuesSize);
        TiffIFDTest.assertEquals((long)this.sumOf(expStripByteCounts), (long)sizeForStrips);
        TiffIFDTest.assertEquals((long)expEntireSize, (long)ifd.getRequiredEntireSize());
    }

    public void testWriteToStream() throws Exception {
        this._product.addBand("b1", 21);
        this._product.addBand("b2", 30);
        Dimension tileSize = JAIUtils.computePreferredTileSize((int)10, (int)20, (int)1);
        this._product.setPreferredTileSize(tileSize);
        this.fillBandWithData(this._product.getBandAt(0), 20);
        this.fillBandWithData(this._product.getBandAt(1), 1000);
        int startOffset = 50;
        MemoryCacheImageOutputStream stream = new MemoryCacheImageOutputStream(new ByteArrayOutputStream());
        TiffIFD ifd = new TiffIFD(this._product);
        ifd.write((ImageOutputStream)stream, 50L, 0L);
        long expectedStreamLength = ifd.getRequiredIfdSize() + ifd.getRequiredReferencedValuesSize() + 50L;
        double[] expWidth = new double[]{10.0};
        double[] expHeight = new double[]{20.0};
        double[] expBitsPerSample = new double[]{32.0, 32.0};
        double[] expCompression = new double[]{1.0};
        double[] expPhotoInter = new double[]{TiffCode.PHOTOMETRIC_BLACK_IS_ZERO.getValue()};
        TiffAscii expImageDescription = new TiffAscii(new String[]{this._product.getName()});
        double[] expStripOffsets = new double[]{0L + expectedStreamLength, 800L + expectedStreamLength};
        double[] expSamplesPerPixel = new double[]{this._product.getNumBands()};
        double[] expRowsPerStrip = new double[]{20.0};
        double[] expStripByteCounts = new double[]{800.0, 800.0};
        double[] expPlanarConfig = new double[]{TiffCode.PLANAR_CONFIG_PLANAR.getValue()};
        double[] expSampleFormat = new double[]{TiffCode.SAMPLE_FORMAT_FLOAT.getValue(), TiffCode.SAMPLE_FORMAT_FLOAT.getValue()};
        double[] expXResolution = new double[]{1.0};
        double[] expYResolution = new double[]{1.0};
        double[] expResolutionUnit = new double[]{1.0};
        long offset = ifd.getRequiredIfdSize() + 50L;
        TiffLong expOffset1 = null;
        TiffLong expOffset2 = null;
        TiffLong expOffset3 = null;
        TiffLong expOffset4 = null;
        TiffLong expOffset5 = null;
        TiffLong expOffset6 = new TiffLong(offset);
        TiffLong expOffset7 = new TiffLong(offset += (long)expImageDescription.getSizeInBytes());
        TiffLong expOffset8 = null;
        TiffLong expOffset9 = null;
        TiffLong expOffset10 = new TiffLong(offset += 8L);
        TiffLong expOffset11 = null;
        Object expOffset12 = null;
        Object expOffset13 = null;
        TiffLong expOffset14 = null;
        TiffLong expOffset15 = new TiffLong(offset += 8L);
        TiffLong expOffset16 = new TiffLong(offset += 8L);
        TiffLong expOffset17 = null;
        TiffLong expOffset18 = new TiffLong(offset += 8L);
        TiffAscii beamMetadata = TiffIFD.getBeamMetadata((Product)this._product);
        this.checkTag(TiffTag.IMAGE_WIDTH, TiffLong.class, expWidth, expOffset1, ifd);
        this.checkTag(TiffTag.IMAGE_LENGTH, TiffLong.class, expHeight, expOffset2, ifd);
        this.checkTag(TiffTag.BITS_PER_SAMPLE, TiffShort[].class, expBitsPerSample, expOffset3, ifd);
        this.checkTag(TiffTag.COMPRESSION, TiffShort.class, expCompression, expOffset4, ifd);
        this.checkTag(TiffTag.PHOTOMETRIC_INTERPRETATION, TiffShort.class, expPhotoInter, expOffset5, ifd);
        this.checkAsciiTag(TiffTag.IMAGE_DESCRIPTION, expImageDescription, expOffset6, ifd);
        this.checkTag(TiffTag.STRIP_OFFSETS, TiffLong[].class, expStripOffsets, expOffset7, ifd);
        this.checkTag(TiffTag.SAMPLES_PER_PIXEL, TiffShort.class, expSamplesPerPixel, expOffset8, ifd);
        this.checkTag(TiffTag.ROWS_PER_STRIP, TiffLong.class, expRowsPerStrip, expOffset9, ifd);
        this.checkTag(TiffTag.STRIP_BYTE_COUNTS, TiffLong[].class, expStripByteCounts, expOffset10, ifd);
        this.checkTag(TiffTag.PLANAR_CONFIGURATION, TiffShort.class, expPlanarConfig, expOffset11, ifd);
        this.checkTag(TiffTag.SAMPLE_FORMAT, TiffShort[].class, expSampleFormat, expOffset14, ifd);
        this.checkTag(TiffTag.X_RESOLUTION, TiffRational.class, expXResolution, expOffset15, ifd);
        this.checkTag(TiffTag.Y_RESOLUTION, TiffRational.class, expYResolution, expOffset16, ifd);
        this.checkTag(TiffTag.RESOLUTION_UNIT, TiffShort.class, expResolutionUnit, expOffset17, ifd);
        this.checkAsciiTag(TiffTag.BEAM_METADATA, beamMetadata, expOffset18, ifd);
        TiffIFDTest.assertEquals((long)expectedStreamLength, (long)stream.length());
        byte[] expIfdBytes = this.createIFDBytes(ifd, 50);
        byte[] actBytes = new byte[expIfdBytes.length];
        stream.seek(50L);
        stream.read(actBytes);
        Assert.assertArrayEquals((byte[])expIfdBytes, (byte[])actBytes);
    }

    public void testWriteToStream_WithIllegalOffset() throws Exception {
        this._product.addBand("b1", 21);
        this.fillBandWithData(this._product.getBandAt(0), 20);
        MemoryCacheImageOutputStream stream = new MemoryCacheImageOutputStream(new ByteArrayOutputStream());
        TiffIFD ifd = new TiffIFD(this._product);
        int illegalOffset = -1;
        try {
            ifd.write((ImageOutputStream)stream, -1L, 0L);
            TiffIFDTest.fail((String)"IllegalArgumentException expected because the ifd offset is illegal");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception notExpected) {
            TiffIFDTest.fail((String)("IllegalArgumentException expected but was [" + notExpected.getClass().getName() + "]"));
        }
    }

    public void testGetStripOffsets_AfterWrite() throws IOException {
        long firstIFDOffset = 10L;
        this._product.addBand("b1", 21);
        this.fillBandWithData(this._product.getBandAt(0), 20);
        MemoryCacheImageOutputStream stream = new MemoryCacheImageOutputStream(new ByteArrayOutputStream());
        TiffIFD ifd = new TiffIFD(this._product);
        ifd.write((ImageOutputStream)stream, 10L, 0L);
        TiffLong[] stripOffsets = (TiffLong[])ifd.getEntry(TiffTag.STRIP_OFFSETS).getValues();
        TiffIFDTest.assertNotNull((Object)stripOffsets);
        TiffIFDTest.assertEquals((int)1, (int)stripOffsets.length);
        TiffIFDTest.assertEquals((long)(ifd.getRequiredIfdSize() + 10L + ifd.getRequiredReferencedValuesSize()), (long)stripOffsets[0].getValue());
    }

    private long computeRequiredValuesSize(double[] expBitsPerSample, double[] expStripOffsets, double[] expStripByteCounts, double[] expSampleFormat, double[] expXResolution, double[] expYResolution, TiffAscii imageDescription, TiffAscii metadata) {
        long size = TiffType.getBytesForType((TiffShort)TiffType.SHORT) * expBitsPerSample.length;
        size += (long)(TiffType.getBytesForType((TiffShort)TiffType.LONG) * expStripOffsets.length);
        size += (long)(TiffType.getBytesForType((TiffShort)TiffType.LONG) * expStripByteCounts.length);
        size += (long)(TiffType.getBytesForType((TiffShort)TiffType.SHORT) * expSampleFormat.length);
        size += (long)(TiffType.getBytesForType((TiffShort)TiffType.RATIONAL) * expXResolution.length);
        size += (long)(TiffType.getBytesForType((TiffShort)TiffType.RATIONAL) * expYResolution.length);
        size += (long)imageDescription.getSizeInBytes();
        return size += (long)metadata.getSizeInBytes();
    }

    private long sumOf(double[] doubles) {
        double sum = 0.0;
        for (int i = 0; i < doubles.length; ++i) {
            sum += doubles[i];
        }
        return Math.round(sum);
    }

    private byte[] createIFDBytes(TiffIFD ifd, int startOffset) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        MemoryCacheImageOutputStream ios = new MemoryCacheImageOutputStream(bout);
        ios.seek(startOffset);
        boolean nextIFDOffset = false;
        TiffShort[] entryTags = new TiffShort[]{TiffTag.IMAGE_WIDTH, TiffTag.IMAGE_LENGTH, TiffTag.BITS_PER_SAMPLE, TiffTag.COMPRESSION, TiffTag.PHOTOMETRIC_INTERPRETATION, TiffTag.IMAGE_DESCRIPTION, TiffTag.STRIP_OFFSETS, TiffTag.SAMPLES_PER_PIXEL, TiffTag.ROWS_PER_STRIP, TiffTag.STRIP_BYTE_COUNTS, TiffTag.X_RESOLUTION, TiffTag.Y_RESOLUTION, TiffTag.PLANAR_CONFIGURATION, TiffTag.RESOLUTION_UNIT, TiffTag.SAMPLE_FORMAT, TiffTag.BEAM_METADATA};
        ios.writeShort(entryTags.length);
        long nextEntryPos = 2 + startOffset;
        for (int i = 0; i < entryTags.length; ++i) {
            ios.seek(nextEntryPos);
            ifd.getEntry(entryTags[i]).write((ImageOutputStream)ios);
            nextEntryPos += 12L;
        }
        ios.writeInt(0);
        ios.flush();
        byte[] bytes = bout.toByteArray();
        return Arrays.copyOfRange(bytes, startOffset, bytes.length);
    }

    private void checkAsciiTag(TiffShort tag, TiffAscii expectedValue, TiffLong expectedOffset, TiffIFD tiffIFD) throws Exception {
        TiffDirectoryEntry entry = tiffIFD.getEntry(tag);
        TiffIFDTest.assertNotNull((Object)entry);
        TiffLong valuesOffset = entry.getValuesOffset();
        if (expectedOffset != null) {
            TiffIFDTest.assertNotNull((Object)valuesOffset);
            TiffIFDTest.assertEquals((long)expectedOffset.getValue(), (long)valuesOffset.getValue());
        } else {
            TiffIFDTest.assertNull((Object)valuesOffset);
        }
        TiffValue actualValue = entry.getValues()[0];
        TiffAscii value = (TiffAscii)actualValue;
        TiffIFDTest.assertEquals((String)expectedValue.getValue(), (String)value.getValue());
    }

    private void checkTag(TiffShort tag, Class expectedClassType, double[] expectedValues, TiffLong expectedValuesOffset, TiffIFD tiffIFD) throws Exception {
        TiffDirectoryEntry entry = tiffIFD.getEntry(tag);
        TiffIFDTest.assertNotNull((Object)entry);
        TiffLong valuesOffset = entry.getValuesOffset();
        if (expectedValuesOffset == null) {
            TiffIFDTest.assertNull((Object)valuesOffset);
        } else {
            TiffIFDTest.assertNotNull((Object)valuesOffset);
            TiffIFDTest.assertEquals((long)expectedValuesOffset.getValue(), (long)valuesOffset.getValue());
        }
        TiffValue[] values = entry.getValues();
        TiffIFDTest.assertEquals((int)expectedValues.length, (int)values.length);
        if (expectedValues.length > 1) {
            TiffIFDTest.assertTrue((boolean)expectedClassType.isInstance(values));
        } else {
            TiffIFDTest.assertTrue((boolean)expectedClassType.isInstance(values[0]));
        }
        for (int i = 0; i < expectedValues.length; ++i) {
            TiffIFDTest.assertEquals((String)("failure at index " + i), (double)expectedValues[i], (double)this.getValue(values[i]), (double)1.0E-10);
        }
    }

    private double getValue(TiffValue object) throws Exception {
        Method getter = object.getClass().getMethod("getValue", new Class[0]);
        Object result = getter.invoke((Object)object, new Object[0]);
        Number numResult = (Number)result;
        return numResult.doubleValue();
    }

    private void fillBandWithData(Band band, int start) {
        ProductData data = band.createCompatibleRasterData();
        for (int i = 0; i < 200; ++i) {
            data.setElemIntAt(i, start + i);
        }
        band.setData(data);
    }
}

