/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.geotiff.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import junit.framework.TestCase;
import org.esa.snap.dataio.geotiff.internal.TiffLong;

public class TiffLongTest
extends TestCase {
    private final long _TIFFLONG_MAX = 0xFFFFFFFFL;
    private final long _TIFFLONG_MIN = 0L;

    public void testCreation_WithMaxValue() {
        new TiffLong(0xFFFFFFFFL);
    }

    public void testCreation_WithMinValue() {
        new TiffLong(0L);
    }

    public void testCreation_ValueSmallerThanMinValue() {
        try {
            new TiffLong(-1L);
            TiffLongTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception notExpected) {
            TiffLongTest.fail((String)"IllegalArgumentException expected");
        }
    }

    public void testCreation_ValueBiggerThanMaxValue() {
        try {
            new TiffLong(0x100000000L);
            TiffLongTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception notExpected) {
            TiffLongTest.fail((String)"IllegalArgumentException expected");
        }
    }

    public void testGetValue() {
        TiffLong tiffLong = new TiffLong(0xFFFFFFFFL);
        TiffLongTest.assertEquals((long)0xFFFFFFFFL, (long)tiffLong.getValue());
        tiffLong = new TiffLong(0L);
        TiffLongTest.assertEquals((long)0L, (long)tiffLong.getValue());
        int value = 23498756;
        tiffLong = new TiffLong(23498756L);
        TiffLongTest.assertEquals((long)23498756L, (long)tiffLong.getValue());
    }

    public void testWriteToStream() throws IOException {
        TiffLong tiffLong = new TiffLong(0xFFFFFFFFL);
        MemoryCacheImageOutputStream stream = new MemoryCacheImageOutputStream(new ByteArrayOutputStream());
        tiffLong.write((ImageOutputStream)stream);
        TiffLongTest.assertEquals((long)4L, (long)stream.length());
        stream.seek(0L);
        TiffLongTest.assertEquals((int)-1, (int)stream.readInt());
    }

    public void testGetSizeInBytes() {
        TiffLong tiffLong = new TiffLong(234L);
        TiffLongTest.assertEquals((int)4, (int)tiffLong.getSizeInBytes());
    }
}

