/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.geotiff.internal;

import junit.framework.TestCase;
import org.esa.snap.dataio.geotiff.internal.TiffDirectoryEntry;
import org.esa.snap.dataio.geotiff.internal.TiffDirectoryEntrySet;
import org.esa.snap.dataio.geotiff.internal.TiffLong;
import org.esa.snap.dataio.geotiff.internal.TiffShort;
import org.esa.snap.dataio.geotiff.internal.TiffValue;

public class TiffDirectoryEntrySetTest
extends TestCase {
    public void testCreation() {
        TiffDirectoryEntrySet entrySet = new TiffDirectoryEntrySet();
        TiffDirectoryEntry[] entries = entrySet.getEntries();
        TiffDirectoryEntrySetTest.assertNotNull((Object)entries);
        TiffDirectoryEntrySetTest.assertEquals((int)0, (int)entries.length);
    }

    public void testSetEntry() {
        TiffDirectoryEntrySet entrySet = new TiffDirectoryEntrySet();
        TiffDirectoryEntry entry = new TiffDirectoryEntry(new TiffShort(45), (TiffValue)new TiffLong(45678L));
        entrySet.set(entry);
        TiffDirectoryEntry[] entries = entrySet.getEntries();
        TiffDirectoryEntrySetTest.assertEquals((int)1, (int)entries.length);
        TiffDirectoryEntrySetTest.assertSame((Object)entry, (Object)entries[0]);
    }

    public void testSetEntry_ReplaceExistingEntry() {
        TiffDirectoryEntrySet entrySet = new TiffDirectoryEntrySet();
        TiffDirectoryEntry entry = new TiffDirectoryEntry(new TiffShort(45), (TiffValue)new TiffLong(45678L));
        TiffDirectoryEntry entry2 = new TiffDirectoryEntry(new TiffShort(45), (TiffValue)new TiffLong(4234L));
        entrySet.set(entry);
        entrySet.set(entry2);
        TiffDirectoryEntry[] entries = entrySet.getEntries();
        TiffDirectoryEntrySetTest.assertEquals((int)1, (int)entries.length);
        TiffDirectoryEntrySetTest.assertSame((Object)entry2, (Object)entries[0]);
    }

    public void testSetEntry_OrderEntries() {
        TiffDirectoryEntrySet entrySet = new TiffDirectoryEntrySet();
        TiffDirectoryEntry entry = new TiffDirectoryEntry(new TiffShort(45), (TiffValue)new TiffLong(45678L));
        TiffDirectoryEntry entry2 = new TiffDirectoryEntry(new TiffShort(43), (TiffValue)new TiffLong(4234L));
        entrySet.set(entry);
        entrySet.set(entry2);
        TiffDirectoryEntry[] entries = entrySet.getEntries();
        TiffDirectoryEntrySetTest.assertEquals((int)2, (int)entries.length);
        TiffDirectoryEntrySetTest.assertSame((Object)entry2, (Object)entries[0]);
        TiffDirectoryEntrySetTest.assertSame((Object)entry, (Object)entries[1]);
    }

    public void testSetEntry_ReplaceAndOrderEntries() {
        TiffDirectoryEntrySet entrySet = new TiffDirectoryEntrySet();
        TiffDirectoryEntry entry1 = new TiffDirectoryEntry(new TiffShort(45), (TiffValue)new TiffLong(45678L));
        TiffDirectoryEntry entry2 = new TiffDirectoryEntry(new TiffShort(43), (TiffValue)new TiffLong(4234L));
        TiffDirectoryEntry entry3 = new TiffDirectoryEntry(new TiffShort(45), (TiffValue)new TiffLong(42634L));
        entrySet.set(entry1);
        entrySet.set(entry2);
        entrySet.set(entry3);
        TiffDirectoryEntry[] entries = entrySet.getEntries();
        TiffDirectoryEntrySetTest.assertEquals((int)2, (int)entries.length);
        TiffDirectoryEntrySetTest.assertSame((Object)entry2, (Object)entries[0]);
        TiffDirectoryEntrySetTest.assertSame((Object)entry3, (Object)entries[1]);
    }

    public void testGetEntry() {
        TiffDirectoryEntrySet entrySet = new TiffDirectoryEntrySet();
        TiffShort tag1 = new TiffShort(45);
        TiffDirectoryEntry entry1 = new TiffDirectoryEntry(tag1, (TiffValue)new TiffLong(45678L));
        TiffShort tag2 = new TiffShort(60);
        TiffDirectoryEntry entry2 = new TiffDirectoryEntry(tag2, (TiffValue)new TiffLong(4234L));
        TiffShort tag3 = new TiffShort(44);
        TiffDirectoryEntry entry3 = new TiffDirectoryEntry(tag3, (TiffValue)new TiffLong(42634L));
        TiffShort noEntryTag = new TiffShort(66);
        entrySet.set(entry1);
        entrySet.set(entry2);
        entrySet.set(entry3);
        TiffDirectoryEntrySetTest.assertEquals((Object)entry1, (Object)entrySet.getEntry(tag1));
        TiffDirectoryEntrySetTest.assertEquals((Object)entry2, (Object)entrySet.getEntry(tag2));
        TiffDirectoryEntrySetTest.assertEquals((Object)entry3, (Object)entrySet.getEntry(tag3));
        TiffDirectoryEntrySetTest.assertNull((Object)entrySet.getEntry(noEntryTag));
    }
}

