/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.geotiff;

import java.io.File;
import java.net.URL;
import javax.imageio.stream.FileCacheImageInputStream;
import javax.imageio.stream.ImageInputStream;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.dataio.geotiff.GeoTiffProductReader;
import org.esa.snap.dataio.geotiff.GeoTiffProductReaderPlugIn;
import org.junit.Assert;
import org.junit.Test;

public class GeoCodingTest {
    @Test
    public void testSmallImageNearGreenwichMeridian() throws Exception {
        URL resource = this.getClass().getResource("nearGreenwichMeridian.tif");
        String filePath = resource.getFile();
        GeoTiffProductReader reader = new GeoTiffProductReader((ProductReaderPlugIn)new GeoTiffProductReaderPlugIn());
        Product product = reader.readGeoTIFFProduct((ImageInputStream)new FileCacheImageInputStream(resource.openStream(), null), new File(filePath));
        GeoCoding geoCoding = product.getSceneGeoCoding();
        GeoPos ul = geoCoding.getGeoPos(new PixelPos(0.0, 0.0), null);
        Assert.assertEquals((double)1.92584, (double)ul.lon, (double)1.0E-5);
        Assert.assertEquals((double)48.28314, (double)ul.lat, (double)1.0E-5);
        GeoPos lr = geoCoding.getGeoPos(new PixelPos(49.0, 49.0), null);
        Assert.assertEquals((double)2.03596, (double)lr.lon, (double)1.0E-5);
        Assert.assertEquals((double)48.17303, (double)lr.lat, (double)1.0E-5);
    }

    @Test
    public void testReadingZip() throws Exception {
        URL resource = this.getClass().getResource("nearGreenwichMeridian.zip");
        String filePath = resource.getFile();
        GeoTiffProductReader reader = new GeoTiffProductReader((ProductReaderPlugIn)new GeoTiffProductReaderPlugIn());
        Product product = reader.readProductNodes((Object)filePath, null);
        GeoCoding geoCoding = product.getSceneGeoCoding();
        GeoPos ul = geoCoding.getGeoPos(new PixelPos(0.0, 0.0), null);
        Assert.assertEquals((double)1.92584, (double)ul.lon, (double)1.0E-5);
        Assert.assertEquals((double)48.28314, (double)ul.lat, (double)1.0E-5);
        GeoPos lr = geoCoding.getGeoPos(new PixelPos(49.0, 49.0), null);
        Assert.assertEquals((double)2.03596, (double)lr.lon, (double)1.0E-5);
        Assert.assertEquals((double)48.17303, (double)lr.lat, (double)1.0E-5);
    }
}

