/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.envi;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.stream.FileCacheImageInputStream;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import org.esa.snap.core.dataio.AbstractProductReader;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.ColorPaletteDef;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.datamodel.IndexCoding;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.SampleCoding;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.TreeNode;
import org.esa.snap.core.util.io.FileUtils;
import org.esa.snap.dataio.envi.DataTypeUtils;
import org.esa.snap.dataio.envi.EnviConstants;
import org.esa.snap.dataio.envi.EnviCrsFactory;
import org.esa.snap.dataio.envi.EnviMapInfo;
import org.esa.snap.dataio.envi.EnviProductReaderPlugIn;
import org.esa.snap.dataio.envi.EnviProjectionInfo;
import org.esa.snap.dataio.envi.Header;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class EnviProductReader
extends AbstractProductReader {
    private final HashMap<Band, Long> bandStreamPositionMap = new HashMap();
    private final HashMap<Band, ImageInputStream> imageInputStreamMap = new HashMap();
    private final HashMap<Band, Header> headerMap = new HashMap(10);
    private ZipFile productZip = null;

    public EnviProductReader(ProductReaderPlugIn readerPlugIn) {
        super(readerPlugIn);
    }

    public static File getEnviImageFile(File headerFile) throws IOException {
        String hdrName = headerFile.getName();
        String imgName = hdrName.substring(0, hdrName.indexOf(46));
        File parentFolder = headerFile.getParentFile();
        for (String ext : EnviConstants.IMAGE_EXTENSIONS) {
            File imgFileLowerCase = new File(parentFolder, imgName + ext);
            if (imgFileLowerCase.exists()) {
                return imgFileLowerCase;
            }
            File imgFileUpperCase = new File(parentFolder, imgName + ext.toUpperCase());
            if (!imgFileUpperCase.exists()) continue;
            return imgFileUpperCase;
        }
        File[] files = parentFolder.listFiles();
        if (files != null) {
            for (File file : files) {
                if (Files.isSameFile(file.toPath(), headerFile.toPath()) || !file.getName().startsWith(imgName)) continue;
                return file;
            }
        }
        throw new IOException("No matching ENVI image file found for header file: " + headerFile.getPath());
    }

    protected Product readProductNodesImpl() throws IOException {
        try {
            return this.innerReadProductNodes();
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Product innerReadProductNodes() throws IOException {
        Object inputObject = this.getInput();
        File inputFile = EnviProductReaderPlugIn.getInputFile(inputObject);
        BufferedReader headerReader = this.getHeaderReader(inputFile);
        String inputFileName = inputFile.getName();
        String[] splittedInputFileName = inputFileName.split("!");
        String productName = splittedInputFileName.length > 1 ? splittedInputFileName[1] : splittedInputFileName[0];
        int dotIndex = productName.lastIndexOf(46);
        if (dotIndex > -1) {
            productName = productName.substring(0, dotIndex);
        }
        try {
            Header header = new Header(headerReader);
            Product product = new Product(productName, header.getSensorType(), header.getNumSamples(), header.getNumLines());
            product.setProductReader((ProductReader)this);
            product.setFileLocation(inputFile);
            product.setDescription(header.getDescription());
            product.getMetadataRoot().addElement(header.getAsMetadata());
            this.initGeoCoding(product, header);
            this.initBands(inputFile, product, header);
            EnviProductReader.applyBeamProperties(product, header.getBeamProperties());
            Product product2 = product;
            return product2;
        }
        finally {
            if (headerReader != null) {
                headerReader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readBandRasterDataImpl(int sourceOffsetX, int sourceOffsetY, int sourceWidth, int sourceHeight, int sourceStepX, int sourceStepY, Band destBand, int destOffsetX, int destOffsetY, int destWidth, int destHeight, ProductData destBuffer, ProgressMonitor pm) throws IOException {
        int sourceMaxY = sourceOffsetY + sourceHeight - 1;
        Product product = destBand.getProduct();
        int sourceRasterWidth = product.getSceneRasterWidth();
        ImageInputStream imageInputStream = this.imageInputStreamMap.get(destBand);
        int elemSize = destBuffer.getElemSize();
        Header header = this.headerMap.get(destBand);
        int headerOffset = header.getHeaderOffset();
        int bandIndex = product.getBandIndex(destBand.getName());
        String interleave = header.getInterleave();
        if ("bil".equalsIgnoreCase(interleave)) {
            long lineSizeInBytes = header.getNumSamples() * elemSize;
            int numBands = product.getNumBands();
            pm.beginTask("Reading band '" + destBand.getName() + "'...", sourceMaxY - sourceOffsetY);
            try {
                int destPos = 0;
                for (int sourceY = sourceOffsetY; sourceY <= sourceMaxY; sourceY += sourceStepY) {
                    if (pm.isCanceled()) {
                    }
                    ImageInputStream imageInputStream2 = imageInputStream;
                    synchronized (imageInputStream2) {
                        long lineStartPos = (long)headerOffset + (long)(sourceY * numBands) * lineSizeInBytes + (long)bandIndex * lineSizeInBytes;
                        imageInputStream.seek(lineStartPos + (long)(elemSize * sourceOffsetX));
                        destBuffer.readFrom(destPos, destWidth, imageInputStream);
                        destPos += destWidth;
                    }
                    pm.worked(1);
                }
            }
            finally {
                pm.done();
            }
        } else if ("bip".equalsIgnoreCase(interleave)) {
            int numBands = product.getNumBands();
            long lineSizeInBytes = header.getNumSamples() * numBands * elemSize;
            ProductData lineData = ProductData.createInstance((int)destBuffer.getType(), (int)(sourceWidth * numBands));
            pm.beginTask("Reading band '" + destBand.getName() + "'...", sourceMaxY - sourceOffsetY);
            try {
                int destPos = 0;
                for (int sourceY = sourceOffsetY; sourceY <= sourceMaxY; sourceY += sourceStepY) {
                    if (pm.isCanceled()) {
                    }
                    ImageInputStream lineStartPos = imageInputStream;
                    synchronized (lineStartPos) {
                        long lineStartPos2 = (long)headerOffset + (long)sourceY * lineSizeInBytes;
                        imageInputStream.seek(lineStartPos2 + (long)(elemSize * sourceOffsetX * numBands));
                        lineData.readFrom(0, sourceWidth * numBands, imageInputStream);
                    }
                    for (int x = 0; x < sourceWidth; ++x) {
                        destBuffer.setElemDoubleAt(destPos++, lineData.getElemDoubleAt(x * numBands + bandIndex));
                    }
                    pm.worked(1);
                }
            }
            finally {
                pm.done();
            }
        } else {
            long bandStartPosition = this.bandStreamPositionMap.get(destBand);
            pm.beginTask("Reading band '" + destBand.getName() + "'...", sourceMaxY - sourceOffsetY);
            try {
                int destPos = 0;
                for (int sourceY = sourceOffsetY; sourceY <= sourceMaxY; sourceY += sourceStepY) {
                    if (pm.isCanceled()) {
                        break;
                    }
                    long sourcePosY = (long)sourceY * (long)sourceRasterWidth;
                    ImageInputStream imageInputStream3 = imageInputStream;
                    synchronized (imageInputStream3) {
                        long pos = bandStartPosition + (long)elemSize * (sourcePosY + (long)sourceOffsetX);
                        try {
                            imageInputStream.seek(pos);
                        }
                        catch (IndexOutOfBoundsException e) {
                            System.out.printf("pos=%d%n", pos);
                            throw e;
                        }
                        destBuffer.readFrom(destPos, destWidth, imageInputStream);
                        destPos += destWidth;
                    }
                    pm.worked(1);
                }
            }
            finally {
                pm.done();
            }
        }
    }

    public void close() throws IOException {
        for (Band band : this.imageInputStreamMap.keySet()) {
            ImageInputStream imageInputStream = this.imageInputStreamMap.get(band);
            if (imageInputStream == null) continue;
            imageInputStream.close();
        }
        if (this.productZip != null) {
            this.productZip.close();
            this.productZip = null;
        }
        super.close();
    }

    public TreeNode<File> getProductComponents() {
        try {
            File headerFile = EnviProductReaderPlugIn.getInputFile(this.getInput());
            File parentDir = headerFile.getParentFile();
            TreeNode root = new TreeNode(parentDir.getCanonicalPath());
            root.setContent((Object)parentDir);
            TreeNode header = new TreeNode(headerFile.getName());
            header.setContent((Object)headerFile);
            root.addChild(header);
            if (this.productZip == null) {
                File imageFile = EnviProductReader.getEnviImageFile(headerFile);
                TreeNode image = new TreeNode(imageFile.getName());
                image.setContent((Object)imageFile);
                root.addChild(image);
            }
            return root;
        }
        catch (IOException ignored) {
            return null;
        }
    }

    private ImageInputStream initializeInputStreamForBandData(File inputFile, ByteOrder byteOrder) throws IOException {
        ImageInputStream imageInputStream = EnviProductReaderPlugIn.isCompressedFile(inputFile) ? this.createImageStreamFromZip(inputFile) : EnviProductReader.createImageStreamFromFile(inputFile);
        imageInputStream.setByteOrder(byteOrder);
        return imageInputStream;
    }

    protected static void applyBeamProperties(Product product, Header.BeamProperties beamProperties) throws IOException {
        String sensingStop;
        if (beamProperties == null) {
            return;
        }
        String sensingStart = beamProperties.getSensingStart();
        if (sensingStart != null) {
            try {
                product.setStartTime(ProductData.UTC.parse((String)sensingStart));
            }
            catch (ParseException e) {
                String message = e.getMessage() + " at property sensingStart in the header file.";
                throw new IOException(message, e);
            }
        }
        if ((sensingStop = beamProperties.getSensingStop()) != null) {
            try {
                product.setEndTime(ProductData.UTC.parse((String)sensingStop));
            }
            catch (ParseException e) {
                String message = e.getMessage() + " at property sensingStop in the header file.";
                throw new IOException(message, e);
            }
        }
    }

    private ImageInputStream createImageStreamFromZip(File file) throws IOException {
        String innerHdrZipPath;
        String filePath = file.getAbsolutePath();
        if (filePath.contains("!")) {
            String[] splittedHeaderFile = filePath.split("!");
            this.productZip = new ZipFile(new File(splittedHeaderFile[0]));
            innerHdrZipPath = splittedHeaderFile[1].replace("\\", "/");
        } else {
            this.productZip = new ZipFile(file, 1);
            innerHdrZipPath = EnviProductReader.findFirstHeader(this.productZip).getName();
        }
        try {
            innerHdrZipPath = innerHdrZipPath.substring(0, innerHdrZipPath.length() - 4);
            ArrayList<String> innerZipDataFilePaths = new ArrayList<String>();
            for (int i = 0; i < EnviConstants.IMAGE_EXTENSIONS.length; ++i) {
                innerZipDataFilePaths.add(FileUtils.ensureExtension((String)innerHdrZipPath, (String)EnviConstants.IMAGE_EXTENSIONS[i]));
            }
            Enumeration<? extends ZipEntry> enumeration = this.productZip.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                for (String innerZipDataFilePath : innerZipDataFilePaths) {
                    if (!zipEntry.getName().equalsIgnoreCase(innerZipDataFilePath)) continue;
                    InputStream inputStream = this.productZip.getInputStream(this.productZip.getEntry(zipEntry.getName()));
                    return new FileCacheImageInputStream(inputStream, null);
                }
            }
        }
        catch (IOException ioe) {
            try {
                this.productZip.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ioe;
        }
        throw new IOException("Not able to initialise band input stream.");
    }

    private static ImageInputStream createImageStreamFromFile(File file) throws IOException {
        File imageFile = EnviProductReader.getEnviImageFile(file);
        return new FileImageInputStream(imageFile);
    }

    protected void initGeoCoding(Product product, Header header) {
        EnviMapInfo enviMapInfo = header.getMapInfo();
        if (enviMapInfo == null) {
            return;
        }
        EnviProjectionInfo projectionInfo = header.getProjectionInfo();
        DefaultGeographicCRS crs = null;
        if (projectionInfo != null) {
            try {
                crs = EnviCrsFactory.createCrs(projectionInfo.getProjectionNumber(), projectionInfo.getParameter(), enviMapInfo.getDatum(), enviMapInfo.getUnit());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if ("Geographic Lat/Lon".equalsIgnoreCase(enviMapInfo.getProjectionName())) {
            crs = DefaultGeographicCRS.WGS84;
            if ("seconds".equalsIgnoreCase(enviMapInfo.getUnit())) {
                enviMapInfo.setEasting(enviMapInfo.getEasting() / 3600.0);
                enviMapInfo.setNorthing(enviMapInfo.getNorthing() / 3600.0);
                enviMapInfo.setPixelSizeX(enviMapInfo.getPixelSizeX() / 3600.0);
                enviMapInfo.setPixelSizeY(enviMapInfo.getPixelSizeY() / 3600.0);
            }
        } else if ("UTM".equalsIgnoreCase(enviMapInfo.getProjectionName())) {
            try {
                int zone = enviMapInfo.getUtmZone();
                String hemisphere = enviMapInfo.getUtmHemisphere();
                if (zone >= 1 && zone <= 60) {
                    CRSAuthorityFactory factory = ReferencingFactoryFinder.getCRSAuthorityFactory((String)"EPSG", null);
                    if ("North".equalsIgnoreCase(hemisphere)) {
                        int WGS84_UTM_zone_N_BASE = 32600;
                        crs = factory.createProjectedCRS("EPSG:" + (32600 + zone));
                    } else {
                        int WGS84_UTM_zone_S_BASE = 32700;
                        crs = factory.createProjectedCRS("EPSG:" + (32700 + zone));
                    }
                }
            }
            catch (FactoryException zone) {
                // empty catch block
            }
        }
        if (crs != null) {
            try {
                AffineTransform i2m = new AffineTransform();
                i2m.translate(enviMapInfo.getEasting(), enviMapInfo.getNorthing());
                i2m.scale(enviMapInfo.getPixelSizeX(), -enviMapInfo.getPixelSizeY());
                i2m.rotate(Math.toRadians(-enviMapInfo.getOrientation()));
                i2m.translate(-(enviMapInfo.getReferencePixelX() - 1.0), -(enviMapInfo.getReferencePixelY() - 1.0));
                Rectangle rect = new Rectangle(product.getSceneRasterWidth(), product.getSceneRasterHeight());
                CrsGeoCoding geoCoding = new CrsGeoCoding((CoordinateReferenceSystem)crs, rect, i2m);
                product.setSceneGeoCoding((GeoCoding)geoCoding);
            }
            catch (FactoryException | TransformException fe) {
                Debug.trace((Throwable)fe);
            }
        }
    }

    protected BufferedReader getHeaderReader(File inputFile) throws IOException {
        if (EnviProductReaderPlugIn.isCompressedFile(inputFile)) {
            ZipEntry zipEntry;
            ZipFile zipFile;
            if (inputFile.getPath().toLowerCase().endsWith(".zip")) {
                zipFile = new ZipFile(inputFile);
                zipEntry = EnviProductReader.findFirstHeader(zipFile);
            } else {
                String[] splittedHeaderFile = inputFile.getAbsolutePath().split("!");
                zipFile = new ZipFile(new File(splittedHeaderFile[0]));
                String innerZipPath = splittedHeaderFile[1].replace("\\", "/");
                zipEntry = zipFile.getEntry(innerZipPath);
            }
            if (zipEntry == null) {
                throw new IOException("No .hdr file found in zip file.");
            }
            InputStream inputStream = zipFile.getInputStream(zipEntry);
            return new BufferedReader(new InputStreamReader(inputStream));
        }
        return new BufferedReader(new FileReader(inputFile));
    }

    private static ZipEntry findFirstHeader(ZipFile zipFile) {
        Enumeration<? extends ZipEntry> entryEnum = zipFile.entries();
        while (entryEnum.hasMoreElements()) {
            ZipEntry entry = entryEnum.nextElement();
            if (!entry.getName().toLowerCase().endsWith(".hdr")) continue;
            return entry;
        }
        return null;
    }

    protected void initBands(File inputFile, Product product, Header header) throws IOException {
        int enviDataType = header.getDataType();
        int dataType = DataTypeUtils.toBeam(enviDataType);
        Double dataIgnoreValue = header.getDataIgnoreValue();
        int sizeInBytes = DataTypeUtils.getSizeInBytes(enviDataType);
        int bandSizeInBytes = header.getNumSamples() * header.getNumLines() * sizeInBytes;
        int headerOffset = header.getHeaderOffset();
        String[] bandNames = EnviProductReader.getBandNames(header);
        float[] wavelength = this.getWavelength(header, bandNames.length);
        float[] bandwidth = this.getBandwidth(header, bandNames.length);
        double[] offsets = this.getOffsetValues(bandNames.length, header);
        double[] gains = this.getGainValues(bandNames.length, header);
        for (int i = 0; i < bandNames.length; ++i) {
            String description;
            String validBandName;
            String originalBandName = bandNames[i];
            if (ProductNode.isValidNodeName((String)originalBandName)) {
                validBandName = originalBandName;
                description = "";
            } else {
                validBandName = EnviProductReader.createValidNodeName(originalBandName);
                description = "non formatted band name: " + originalBandName;
            }
            Band[] band = new Band(validBandName, dataType, product.getSceneRasterWidth(), product.getSceneRasterHeight());
            band.setDescription(description);
            band.setSpectralWavelength(wavelength[i]);
            band.setSpectralBandwidth(bandwidth[i]);
            band.setScalingOffset(offsets[i]);
            band.setScalingFactor(gains[i]);
            if (dataIgnoreValue != null) {
                band.setNoDataValueUsed(true);
                band.setNoDataValue(dataIgnoreValue.doubleValue());
            }
            product.addBand((Band)band);
            long bandStartPosition = headerOffset + bandSizeInBytes * i;
            this.bandStreamPositionMap.put((Band)band, bandStartPosition);
            this.imageInputStreamMap.put((Band)band, this.initializeInputStreamForBandData(inputFile, header.getJavaByteOrder()));
            this.headerMap.put((Band)band, header);
        }
        int numClasses = header.getNumClasses();
        String[] classNames = header.getClassNmaes();
        if (numClasses > 0 && classNames.length == numClasses) {
            Band[] bands;
            IndexCoding indexCoding = new IndexCoding("classification");
            for (int i = 0; i < numClasses; ++i) {
                indexCoding.addIndex(classNames[i], i, "");
            }
            product.getIndexCodingGroup().add((ProductNode)indexCoding);
            for (Band band : bands = product.getBands()) {
                band.setSampleCoding((SampleCoding)indexCoding);
            }
            int[] classRGB = header.getClassColorRGB();
            if (classRGB.length == numClasses * 3) {
                ColorPaletteDef.Point[] points = new ColorPaletteDef.Point[numClasses];
                for (int i = 0; i < numClasses; ++i) {
                    Color color = new Color(classRGB[i * 3], classRGB[i * 3 + 1], classRGB[i * 3 + 2]);
                    points[i] = new ColorPaletteDef.Point((double)i, color, classNames[i]);
                }
                ImageInfo imageInfo = new ImageInfo(new ColorPaletteDef(points, points.length));
                for (Band band : bands) {
                    band.setImageInfo(imageInfo);
                }
            }
        }
    }

    private double[] getOffsetValues(int numBands, Header header) {
        double[] dataOffsetValues = header.getDataOffsetValues();
        if (dataOffsetValues.length == 0) {
            dataOffsetValues = new double[numBands];
            Arrays.fill(dataOffsetValues, 0.0);
            return dataOffsetValues;
        }
        return dataOffsetValues;
    }

    private double[] getGainValues(int numBands, Header header) {
        double[] dataGainValues = header.getDataGainValues();
        if (dataGainValues.length == 0) {
            dataGainValues = new double[numBands];
            Arrays.fill(dataGainValues, 1.0);
            return dataGainValues;
        }
        return dataGainValues;
    }

    static String[] getBandNames(Header header) {
        String[] bandNames = header.getBandNames();
        if (bandNames.length == 0) {
            int numBands = header.getNumBands();
            if (numBands == 0) {
                return new String[]{"Band"};
            }
            bandNames = new String[numBands];
            for (int i = 0; i < bandNames.length; ++i) {
                bandNames[i] = "Band_" + (i + 1);
            }
            return bandNames;
        }
        return bandNames;
    }

    private float[] getWavelength(Header header, int numBands) {
        return this.transformWavelength(header.getWavelengths(), header.getWavelengthsUnit(), numBands);
    }

    private float[] getBandwidth(Header header, int numBands) {
        return this.transformWavelength(header.getFWHM(), header.getWavelengthsUnit(), numBands);
    }

    private float[] transformWavelength(String[] wavelengthsStrings, String wavelengthsUnit, int numBands) {
        float[] wavelengths = new float[numBands];
        int scaleFactor = 1;
        if (wavelengthsUnit != null && wavelengthsUnit.equalsIgnoreCase("Micrometers")) {
            scaleFactor = 1000;
        }
        if (wavelengthsStrings != null && wavelengthsStrings.length == numBands) {
            for (int i = 0; i < wavelengthsStrings.length; ++i) {
                wavelengths[i] = Float.parseFloat(wavelengthsStrings[i]) * (float)scaleFactor;
            }
        }
        return wavelengths;
    }

    private static String createValidNodeName(String originalBandName) {
        String name = StringUtils.createValidName((String)originalBandName, null, (char)'_');
        while (name.startsWith("_")) {
            name = name.substring(1);
        }
        while (name.endsWith("_")) {
            name = name.substring(0, name.length() - 1);
        }
        return name;
    }
}

