/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.envi;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.dataio.envi.EnviProductReader;
import org.esa.snap.dataio.envi.EnviProductReaderPlugIn;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class EnviProductReaderPluginTest {
    private EnviProductReaderPlugIn readerPlugIn;
    private File headerFile;

    @Test
    public void testGetDefaultFileExtensions() {
        String[] defaultFileExtensions = this.readerPlugIn.getDefaultFileExtensions();
        Assert.assertEquals((long)2L, (long)defaultFileExtensions.length);
        Assert.assertEquals((Object)".hdr", (Object)defaultFileExtensions[0]);
        Assert.assertEquals((Object)".zip", (Object)defaultFileExtensions[1]);
    }

    @Test
    public void testInputTypes() {
        Class[] inputTypes = this.readerPlugIn.getInputTypes();
        Assert.assertNotNull((Object)inputTypes);
        Assert.assertEquals((long)2L, (long)inputTypes.length);
        Assert.assertEquals(String.class, (Object)inputTypes[0]);
        Assert.assertEquals(File.class, (Object)inputTypes[1]);
    }

    @Test
    public void testDecodeQualfication_wrongObject() {
        Assert.assertEquals((Object)DecodeQualification.UNABLE, (Object)this.readerPlugIn.getDecodeQualification((Object)new Double(23.8)));
    }

    @Test
    public void testDecodeQualfication_Stream_success() {
        String line = "ENVIdklfj\n234j\nsdf\tsdf\tsdaf\n";
        ByteArrayInputStream bais = new ByteArrayInputStream("ENVIdklfj\n234j\nsdf\tsdf\tsdaf\n".getBytes());
        MemoryCacheImageInputStream stReader = new MemoryCacheImageInputStream(bais);
        Assert.assertEquals((Object)DecodeQualification.SUITABLE, (Object)this.readerPlugIn.getDecodeQualification((Object)stReader));
    }

    @Test
    public void testDecodeQualfication_Stream_fail_invalid() {
        String lines = "This is no success!";
        ByteArrayInputStream bais = new ByteArrayInputStream("This is no success!".getBytes());
        MemoryCacheImageInputStream stReader = new MemoryCacheImageInputStream(bais);
        Assert.assertEquals((Object)DecodeQualification.UNABLE, (Object)this.readerPlugIn.getDecodeQualification((Object)stReader));
    }

    @Test
    public void testDecodeQualification_File_success() throws IOException {
        String line = "ENVIdklfj\n234j\nsdf\tsdf\tsdaf\n";
        this.writeToTestFile("ENVIdklfj\n234j\nsdf\tsdf\tsdaf\n");
        Assert.assertEquals((Object)DecodeQualification.SUITABLE, (Object)this.readerPlugIn.getDecodeQualification((Object)this.headerFile));
    }

    @Test
    public void testDecodeQualification_File_failure() throws IOException {
        this.writeToTestFile("blaberrhabarber");
        Assert.assertEquals((Object)DecodeQualification.UNABLE, (Object)this.readerPlugIn.getDecodeQualification((Object)this.headerFile));
    }

    @Test
    public void testDecodeQualification_String_success() throws IOException {
        String line = "ENVIdklfj\n234j\nsdf\tsdf\tsdaf\n";
        this.writeToTestFile("ENVIdklfj\n234j\nsdf\tsdf\tsdaf\n");
        Assert.assertEquals((Object)DecodeQualification.SUITABLE, (Object)this.readerPlugIn.getDecodeQualification((Object)this.headerFile.getName()));
    }

    @Test
    public void testDecodeQualification_String_failure() throws IOException {
        this.writeToTestFile("blaberrhabarber");
        Assert.assertEquals((Object)DecodeQualification.UNABLE, (Object)this.readerPlugIn.getDecodeQualification((Object)this.headerFile.getName()));
    }

    @Test
    public void testDecodeQualification_ZipFile_success() throws IOException {
        String line = "ENVIdklfj\n234j\nsdf\tsdf\tsdaf\n";
        this.writeToZipTestFile("ENVIdklfj\n234j\nsdf\tsdf\tsdaf\n", true);
        Assert.assertEquals((Object)DecodeQualification.SUITABLE, (Object)this.readerPlugIn.getDecodeQualification((Object)this.headerFile));
    }

    @Test
    public void testDecodeQualification_ZipFile_failure() throws IOException {
        this.writeToZipTestFile("blaberrhabarber", true);
        Assert.assertEquals((Object)DecodeQualification.UNABLE, (Object)this.readerPlugIn.getDecodeQualification((Object)this.headerFile));
    }

    @Test
    public void testDecodeQualification_ZipFile_failureNotEnoughEntries() throws IOException {
        String line = "ENVIdklfj\n234j\nsdf\tsdf\tsdaf\n";
        this.writeToZipTestFile("ENVIdklfj\n234j\nsdf\tsdf\tsdaf\n", false);
        Assert.assertEquals((Object)DecodeQualification.UNABLE, (Object)this.readerPlugIn.getDecodeQualification((Object)this.headerFile));
    }

    @Test
    public void testCreateReaderInstance() {
        ProductReader reader = this.readerPlugIn.createReaderInstance();
        Assert.assertNotNull((Object)reader);
        Assert.assertSame(EnviProductReader.class, reader.getClass());
    }

    @Test
    public void testGetInputFile() {
        String inputFileName = "test.file";
        File file = EnviProductReaderPlugIn.getInputFile((Object)"test.file");
        Assert.assertEquals((Object)"test.file", (Object)file.getName());
        File inputFile = new File("test.file");
        file = EnviProductReaderPlugIn.getInputFile((Object)inputFile);
        Assert.assertEquals((Object)"test.file", (Object)file.getName());
    }

    @Test
    public void testIsCompressedFile() {
        File file = new File("envi.file");
        Assert.assertFalse((boolean)EnviProductReaderPlugIn.isCompressedFile((File)file));
        file = new File("envi.zip");
        Assert.assertTrue((boolean)EnviProductReaderPlugIn.isCompressedFile((File)file));
    }

    @Test
    public void testGetFormatNames() {
        String[] formatNames = this.readerPlugIn.getFormatNames();
        Assert.assertEquals((long)1L, (long)formatNames.length);
        Assert.assertEquals((Object)"ENVI", (Object)formatNames[0]);
    }

    @Test
    public void testGetDescription() {
        Assert.assertEquals((Object)"ENVI Data Products", (Object)this.readerPlugIn.getDescription(null));
    }

    @Test
    public void testGetProductFileFilter() {
        SnapFileFilter snapFileFilter = this.readerPlugIn.getProductFileFilter();
        Assert.assertEquals((Object)".hdr", (Object)snapFileFilter.getDefaultExtension());
        String[] extensions = snapFileFilter.getExtensions();
        Assert.assertEquals((Object)".hdr", (Object)extensions[0]);
        Assert.assertEquals((Object)".zip", (Object)extensions[1]);
        Assert.assertEquals((Object)"ENVI Data Products (*.hdr,*.zip)", (Object)snapFileFilter.getDescription());
        Assert.assertEquals((Object)"ENVI", (Object)snapFileFilter.getFormatName());
    }

    @Before
    public void setUp() throws Exception {
        this.readerPlugIn = new EnviProductReaderPlugIn();
    }

    @After
    public void tearDown() throws Exception {
        if (this.headerFile != null) {
            if (!this.headerFile.delete()) {
                Assert.fail((String)("unable to delete testdata: " + this.headerFile.getName()));
            }
            this.headerFile = null;
        }
    }

    private void writeToTestFile(String line) throws IOException {
        this.headerFile = new File("test.hdr");
        this.headerFile.createNewFile();
        FileOutputStream outStream = new FileOutputStream(this.headerFile);
        outStream.write(line.getBytes());
        outStream.flush();
        outStream.close();
    }

    private void writeToZipTestFile(String line, boolean writeImgEntry) throws IOException {
        this.headerFile = new File("test.zip");
        ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(this.headerFile.getName()));
        zipOut.putNextEntry(new ZipEntry("test.hdr"));
        zipOut.write(line.getBytes());
        zipOut.closeEntry();
        if (writeImgEntry) {
            zipOut.putNextEntry(new ZipEntry("test.img"));
            zipOut.write(line.getBytes());
            zipOut.closeEntry();
        }
        zipOut.close();
    }
}

