/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.db;

import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileFilter;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.esa.beam.framework.dataio.ProductIO;
import org.esa.beam.framework.dataio.ProductReader;
import org.esa.beam.framework.datamodel.Product;
import org.esa.snap.db.ProductDB;
import org.esa.snap.db.ProductEntry;
import org.esa.snap.util.ProductFunctions;
import org.esa.snap.util.TestUtils;
import org.junit.Before;
import org.junit.Test;

public class TestProductDao {
    private static String dbPropertiesPath = "org/esa/snap/config/productDB.properties";
    private ProductDB db;

    @Before
    public void setUp() throws Exception {
        URL fileUrl = this.getClass().getClassLoader().getResource(dbPropertiesPath);
        this.db = ProductDB.testInstance((File)new File(fileUrl.getFile()));
    }

    @Test
    public void testAddAll() throws Exception {
        File folder1 = new File(TestUtils.rootPathASAR);
        if (!folder1.exists()) {
            TestUtils.skipTest((Object)this, (String)(folder1.getAbsolutePath() + " not found"));
            return;
        }
        TestProductDao.recurseProcessFolder(folder1, this.db);
    }

    public static void recurseProcessFolder(File folder, ProductDB db) throws SQLException {
        File[] fileList;
        for (File file : fileList = folder.listFiles((FileFilter)new ProductFunctions.ValidProductFileFilter(true))) {
            ProductReader reader;
            if (file.isDirectory()) {
                TestProductDao.recurseProcessFolder(file, db);
                continue;
            }
            if (db.pathExistsInDB(file) || (reader = ProductIO.getProductReaderForInput((Object)file)) == null) continue;
            Product sourceProduct = null;
            try {
                sourceProduct = reader.readProductNodes((Object)file, null);
            }
            catch (Exception e) {
                System.out.println("Unable to read " + file.getAbsolutePath());
            }
            if (sourceProduct == null) continue;
            db.saveProduct(sourceProduct);
            sourceProduct.dispose();
        }
    }

    @Test
    public void testListAll() throws SQLException {
        ProductEntry[] list;
        for (ProductEntry entry : list = this.db.getProductEntryList(false)) {
        }
    }

    @Test
    public void testGetAllMissions() throws SQLException {
        String[] missions;
        TestUtils.log.info("Missions:");
        for (String str : missions = this.db.getAllMissions()) {
            TestUtils.log.info(str);
        }
    }

    @Test
    public void testGetENVISATProductTypes() throws SQLException {
        String[] productTypes;
        TestUtils.log.info("ENVISAT productTypes:");
        for (String str : productTypes = this.db.getProductTypes(new String[]{"ENVISAT"})) {
            TestUtils.log.info(str);
        }
    }

    @Test
    public void testGetAllProductTypes() throws SQLException {
        String[] productTypes;
        TestUtils.log.info("All productTypes:");
        for (String str : productTypes = this.db.getAllProductTypes()) {
            TestUtils.log.info(str);
        }
    }

    @Test
    public void testSelect() throws SQLException {
        String strGetProductsWhere = "SELECT * FROM APP.PRODUCTS WHERE MISSION='ENVISAT'";
        Statement queryStatement = this.db.getConnection().createStatement();
        ResultSet results = queryStatement.executeQuery("SELECT * FROM APP.PRODUCTS WHERE MISSION='ENVISAT'");
    }

    @Test
    public void testRectIntersect() {
        Rectangle2D.Float a = new Rectangle2D.Float(-10.0f, 10.0f, 100.0f, 100.0f);
        Rectangle2D.Float b = new Rectangle2D.Float(-20.0f, 20.0f, 50.0f, 50.0f);
        boolean r1 = a.intersects(b);
        boolean r2 = b.intersects(a);
        System.out.println();
    }
}

